/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sql;

import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import java.util.HashMap;
import java.util.Map;

public class SqlUtils {
    public static final int PATIENT = 0;
    public static final int STUDY = 1;
    public static final int SERIES = 2;
    public static final int IMAGE = 3;
    public static final String[] LEVELS = new String[]{"patient", "study", "series", "image"};
    public static String[] MULTIFRAME_TABLES = new String[]{"ptimage", "nmimages"};
    static final char DELIM = '|';

    private SqlUtils() {
    }

    public static int getLevelIndex(String levelString) {
        int index = -1;
        for (int i = 0; i < LEVELS.length; ++i) {
            if (!LEVELS[i].equalsIgnoreCase(levelString)) continue;
            index = i;
            break;
        }
        return index;
    }

    public static String getImageTableName(String imageId) {
        int index = imageId.indexOf(124);
        return index > 0 ? imageId.substring(0, index) : "";
    }

    public static String getImageKey(String imageId) {
        if (null == imageId) {
            return "";
        }
        int index = imageId.indexOf(124);
        return index > 0 ? imageId.substring(index + 1) : "";
    }

    public static String getSqlString(DMQuery q, Map cache) {
        String str = "";
        if (q != null) {
            String lhs = "";
            String rhs = "";
            switch (q.qtype) {
                case 1: {
                    String columnName = (String)cache.get(new DMTag(q.group, q.element));
                    if (columnName == null) break;
                    str = str + columnName + q.relString() + "'" + q.sval + "'";
                    break;
                }
                case 10: {
                    lhs = SqlUtils.getSqlString(q.lhs, cache);
                    rhs = SqlUtils.getSqlString(q.rhs, cache);
                    if (lhs.length() == 0 || rhs.length() == 0) break;
                    str = str + lhs + " AND " + rhs;
                    break;
                }
                case 11: {
                    lhs = SqlUtils.getSqlString(q.lhs, cache);
                    rhs = SqlUtils.getSqlString(q.rhs, cache);
                    if (lhs.length() == 0 || rhs.length() == 0) break;
                    str = str + "(" + lhs + ") OR (" + rhs + ")";
                }
            }
        }
        return str;
    }

    public static String getMultiframeColumn(String imageTable) {
        String multiframe = "";
        for (int i = 0; i < MULTIFRAME_TABLES.length; ++i) {
            if (!MULTIFRAME_TABLES[i].equals(imageTable.toLowerCase())) continue;
            multiframe = ", numberofframes";
            break;
        }
        return multiframe;
    }

    public static Map getReverse(Map map) {
        HashMap reverseMap = new HashMap(map.size());
        for (Object key : map.keySet()) {
            reverseMap.put(map.get(key), key);
        }
        return reverseMap;
    }
}

