/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.tools;

import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SubSample {
    private static double[] filldoubles(String str) {
        String[] s = str.split("\\\\");
        double[] dv = new double[s.length];
        for (int i = 0; i < s.length; ++i) {
            dv[i] = Double.parseDouble(s[i]);
        }
        return dv;
    }

    public static void pl(String str, double[] data) {
        System.out.print(str + " ");
        for (int i = 0; i < data.length; ++i) {
            System.out.print(data[i] + " ");
        }
        System.out.println();
    }

    public static String arrayToStr(double[] array) {
        String s = "";
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                s = s + "\\";
            }
            s = s + array[i];
        }
        return s;
    }

    public static void main(String[] args) {
        DMSession dms = new DMSession("file", args[0], null);
        File dir = new File(args[1]);
        dir.mkdir();
        DMComposite[] dmc = dms.getComposites();
        double scale = 0.5;
        for (int i = 0; i < dmc.length; ++i) {
            DicomComposite dc = new DicomComposite();
            String name = new File(dmc[i].getFilePath()).getName();
            DMImage dmi = dmc[i].getImages(null)[0];
            double[] spacing = SubSample.filldoubles((String)dmi.getValue(40, 48));
            int j = 0;
            while (j < spacing.length) {
                int n = j++;
                spacing[n] = spacing[n] / 0.5;
            }
            SubSample.pl("spacing ", spacing);
            dc.read(dmc[i].getInputStream());
            BufferedImage img = dmi.getPixelData();
            AffineTransform tx = new AffineTransform();
            tx.setToIdentity();
            tx.scale(0.5, 0.5);
            AffineTransformOp op = new AffineTransformOp(tx, 2);
            int nw = (int)((double)img.getWidth() * 0.5);
            int nh = (int)((double)img.getHeight() * 0.5);
            BufferedImage dest = new BufferedImage(nw, nh, img.getType());
            op.filter(img, dest);
            short[] destdata = ((DataBufferUShort)dest.getRaster().getDataBuffer()).getData();
            short[] data = ((DataBufferUShort)img.getRaster().getDataBuffer()).getData();
            dc.setValue(40, 16, new Integer(nh));
            dc.setValue(40, 17, new Integer(nw));
            ByteBuffer bb = ByteBuffer.allocate(destdata.length * 2);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.asShortBuffer().put(destdata);
            dc.setValue(32736, 16, bb.array());
            dc.setValue(40, 48, SubSample.arrayToStr(spacing));
            dc.setValue(8, 24, UidGenerator.newInstanceUID());
            try {
                System.err.println(">>>> Saving image#: " + name);
                FileOutputStream fos = new FileOutputStream(new File(dir, name));
                dc.write(fos, true);
                fos.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

