/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.volume;

import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.dm.DMVolume;
import com.ge.med.terra.tap.dm.sessionFile.dicomImageGen;
import com.ge.med.terra.tap.dm.sessionFile.fileImage;
import com.ge.med.terra.tap.dm.volume.ImageWrap;
import com.ge.med.terra.tap.dm.volume.MultiChannelDataSupport;
import com.ge.med.terra.tap.dm.volume.VolumeInfo;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public class DMObjectVolume
extends DMVolume {
    public static final int flip;
    private MultiChannelDataSupport mcs;
    private int width;
    private int height;
    private boolean littleEndian;
    private int bitsPerPix = -1;
    private int pixType = 0;
    private DMObject dcmObject;
    private DMComposite dcmComp;
    private double[] rasXdir = new double[3];
    private double[] rasYdir = new double[3];
    private VolumeInfo vinfo;
    private static final DMTag[] defaultTags;

    public DMObjectVolume(DMObject dmo) {
        this(new Object[]{dmo});
    }

    public DMObjectVolume(Object[] obj) {
        DMComposite[] comp;
        DMTagValueInterface dmTagValue;
        DMTag[] neededtags;
        DMTag[] dMTagArray = neededtags = obj.length > 1 ? (DMTag[])obj[1] : defaultTags;
        if (obj[0] instanceof DMObject) {
            DMObject series;
            dmTagValue = this.dcmObject = (series = (DMObject)obj[0]);
            comp = series.getComposites();
        } else if (obj[0] instanceof DMComposite[] && ((DMComposite[])obj[0]).length > 0) {
            comp = (DMComposite[])obj[0];
            this.dcmComp = comp[0];
            dmTagValue = this.dcmComp;
        } else {
            throw new IllegalArgumentException("First element in the array must be either a DMObject or a DMComposite array.");
        }
        this.mcs = new MultiChannelDataSupport(dmTagValue);
        double[] rasXY = new double[6];
        double[] pixSpac = new double[2];
        double[] sliceNormal = null;
        double sliceThickness = 0.0;
        ArrayList<MultiChannelDataSupport.Slice> al = new ArrayList<MultiChannelDataSupport.Slice>(comp.length);
        double[] topLeft = new double[3];
        for (int channel = 0; channel < this.getNumChannels(); ++channel) {
            al.clear();
            for (int i = 0; i < comp.length; ++i) {
                String ts;
                String path = comp[i].getFilePath();
                tagValue[] tget = fileImage.getImageTags(comp[i].getPeer(), neededtags);
                String imgType = ((String)dicomImageGen.get(tget, 40, 4)).trim();
                int dimy = (Integer)dicomImageGen.get(tget, 40, 16);
                int dimx = (Integer)dicomImageGen.get(tget, 40, 17);
                int frames = dicomImageGen.get(tget, 40, 8) != null ? Integer.parseInt((String)dicomImageGen.get(tget, 40, 8)) : 1;
                DMElement channelDataTag = this.mcs.loadChannelDataTag(channel, (DMElement[])tget, comp[i]);
                if (i == 0) {
                    Object str = dicomImageGen.get(tget, 32, 55);
                    if (str != null) {
                        DMObjectVolume.filldoubles(str.toString(), rasXY);
                    } else {
                        rasXY = null;
                    }
                    str = dicomImageGen.get(tget, 40, 48);
                    if (str != null) {
                        DMObjectVolume.filldoubles(str.toString(), pixSpac);
                    } else {
                        pixSpac = null;
                    }
                    str = dicomImageGen.get(tget, 24, 80);
                    if (str != null) {
                        sliceThickness = Double.parseDouble(str.toString());
                    } else {
                        double d = sliceThickness = pixSpac != null ? pixSpac[0] : 1.0;
                    }
                    if (rasXY == null || pixSpac == null) {
                        throw new DMException("Invalid input data. Missing (0028,0030) Pixel Spacing and (0020,0037) Image Orientation (Patient) tags.");
                    }
                    this.rasXdir[0] = -rasXY[0] * pixSpac[0];
                    this.rasXdir[1] = -rasXY[1] * pixSpac[0];
                    this.rasXdir[2] = rasXY[2] * pixSpac[0];
                    this.rasYdir[0] = -rasXY[3] * pixSpac[1];
                    this.rasYdir[1] = -rasXY[4] * pixSpac[1];
                    this.rasYdir[2] = rasXY[5] * pixSpac[1];
                    sliceNormal = DMObjectVolume.crossProduct3(null, this.rasXdir, this.rasYdir);
                    DMObjectVolume.normalize(sliceNormal);
                    this.bitsPerPix = fileImage.getBitsPerPix((DMElement[])tget);
                    if ("MONOCHROME2".equalsIgnoreCase(imgType) || "MONOCHROME1".equalsIgnoreCase(imgType)) {
                        this.pixType = 1;
                    } else if ("RGB".equalsIgnoreCase(imgType)) {
                        this.pixType = 2;
                    } else if ("PALETTE COLOR".equalsIgnoreCase(imgType)) {
                        this.pixType = 3;
                    }
                    for (int tags = 0; tags < tget.length; ++tags) {
                        if (!tget[tags].is(32736, 16)) continue;
                        this.littleEndian = tget[tags].isLittleEndian();
                    }
                }
                boolean explicitVr = (ts = (String)dicomImageGen.get(tget, 2, 16)).equals(DMUtils.TS_EBE) || ts.equals(DMUtils.TS_ELE);
                tagValue tv = DMUtils.findtag(tget, 32, 50);
                if (tv != null) {
                    String str = (String)tv.value;
                    DMObjectVolume.filldoubles(str, topLeft);
                    topLeft[0] = -topLeft[0];
                    topLeft[1] = -topLeft[1];
                }
                this.width = dimx;
                this.height = dimy;
                double[] frameTopLeft = new double[3];
                int frameLength = dimy * dimx * (this.getBitsPerVoxel() / 8);
                int k = 0;
                while (k < frames) {
                    MultiChannelDataSupport.Slice slice = new MultiChannelDataSupport.Slice();
                    slice.filename = path;
                    DMObjectVolume.scaleAdd(topLeft, (double)k * sliceThickness, sliceNormal, frameTopLeft);
                    System.arraycopy(frameTopLeft, 0, slice.topLeft, 0, 3);
                    slice.offset = channelDataTag.getOffset() + (long)(k * frameLength) + (long)(explicitVr ? 12 : 8);
                    slice.dmc = comp[i];
                    slice.sliceNo = k++;
                    al.add(slice);
                }
            }
            MultiChannelDataSupport.Slice[] slices = al.toArray(new MultiChannelDataSupport.Slice[al.size()]);
            final double[] v = new double[]{slices[0].topLeft[0] - slices[1].topLeft[0], slices[0].topLeft[1] - slices[1].topLeft[1], slices[0].topLeft[2] - slices[1].topLeft[2]};
            double[] t = DMObjectVolume.crossProduct3(null, this.rasXdir, this.rasYdir);
            double k = DMObjectVolume.dot(t, v);
            if ((double)flip * k > 0.0) {
                v[0] = -v[0];
                v[1] = -v[1];
                v[2] = -v[2];
            }
            final double[] p = new double[]{slices[0].topLeft[0], slices[0].topLeft[1], slices[0].topLeft[2]};
            Arrays.sort(slices, new Comparator(){
                double[] tmp = new double[3];

                public int compare(Object o1, Object o2) {
                    MultiChannelDataSupport.Slice i1 = (MultiChannelDataSupport.Slice)o1;
                    MultiChannelDataSupport.Slice i2 = (MultiChannelDataSupport.Slice)o2;
                    DMObjectVolume.sub(i1.topLeft, p, this.tmp);
                    double t1 = DMObjectVolume.dot(this.tmp, v);
                    DMObjectVolume.sub(i2.topLeft, p, this.tmp);
                    double t2 = DMObjectVolume.dot(this.tmp, v);
                    return Double.compare(t2, t1);
                }
            });
            this.mcs.getChannel((int)channel).slices = slices;
        }
    }

    @Override
    public int[] getVolumeDimensions(int[] dims) {
        if (dims == null) {
            dims = new int[]{this.width, this.height, this.mcs.getChannel((int)0).slices.length};
        }
        return dims;
    }

    @Override
    public double[] getRASOfOrigin(double[] rasulc) {
        if (rasulc == null) {
            rasulc = new double[3];
        }
        System.arraycopy(this.mcs.getChannel((int)0).slices[0].topLeft, 0, rasulc, 0, 3);
        return rasulc;
    }

    @Override
    public double[] getXDirectionRAS(double[] rasdx) {
        if (rasdx == null) {
            rasdx = new double[3];
        }
        System.arraycopy(this.rasXdir, 0, rasdx, 0, 3);
        return rasdx;
    }

    @Override
    public double[] getYDirectionRAS(double[] rasdy) {
        if (rasdy == null) {
            rasdy = new double[3];
        }
        System.arraycopy(this.rasYdir, 0, rasdy, 0, 3);
        return rasdy;
    }

    @Override
    public double[] getZDirectionRAS(double[] rasdz) {
        if (rasdz == null) {
            rasdz = new double[3];
        }
        MultiChannelDataSupport.Slice[] slices = this.mcs.getChannel((int)0).slices;
        rasdz[0] = slices[1].topLeft[0] - slices[0].topLeft[0];
        rasdz[1] = slices[1].topLeft[1] - slices[0].topLeft[1];
        rasdz[2] = slices[1].topLeft[2] - slices[0].topLeft[2];
        return rasdz;
    }

    @Override
    public long getVSliceOffset(int channel, int slice) {
        return this.mcs.getVSliceOffset(channel, slice);
    }

    @Override
    public long getVSliceOffset(int slice) {
        return this.getVSliceOffset(0, slice);
    }

    @Override
    public String getVSlicePath(int channel, int slice) {
        return this.mcs.getVSlicePath(channel, slice);
    }

    @Override
    public String getVSlicePath(int slice) {
        return this.getVSlicePath(0, slice);
    }

    @Override
    public boolean isVolumeLittleEndian() {
        return this.littleEndian;
    }

    @Override
    public int getBitsPerVoxel() {
        return this.bitsPerPix;
    }

    @Override
    public int getPixelType() {
        return this.pixType;
    }

    @Override
    public Object getVSliceValue(int channel, int slice, int group, int element) {
        return this.mcs.getVSliceValue(channel, slice, group, element);
    }

    @Override
    public Object getVSliceValue(int slice, int group, int element) {
        return this.getVSliceValue(0, slice, group, element);
    }

    public void getVSliceValues(int channel, int slice, DMElement[] dme) {
        this.mcs.getVSliceValues(channel, slice, dme);
    }

    @Override
    public void getVSliceValues(int slice, DMElement[] dme) {
        this.getVSliceValues(0, slice, dme);
    }

    @Override
    public Object getValue(int group, int element) {
        return this.getVSliceValue(0, 0, group, element);
    }

    @Override
    public int getValues(XjTagValue[] xjTagValueArray) {
        DMElement[] data = DMElement.genDMelements(xjTagValueArray);
        if (this.dcmObject != null) {
            this.dcmObject.getValues(data);
        } else {
            this.dcmComp.getValues(data);
        }
        return DMElement.getXjTagValue(data, xjTagValueArray);
    }

    @Override
    public String getRelatedComposite() {
        return this.mcs.getChannel((int)0).slices[0].filename;
    }

    @Override
    public VolumeInfo getInfoFileName() {
        if (this.vinfo != null) {
            return this.vinfo;
        }
        try {
            this.vinfo = VolumeInfo.createTmpInfo(this);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return this.vinfo;
    }

    @Override
    public int getNumChannels() {
        return this.mcs.getNumChannels();
    }

    @Override
    public String getMultiChannelType() {
        return this.mcs.getMultiChannelType();
    }

    @Override
    public String getChannelName(int channel) {
        return this.mcs.getChannelName(channel);
    }

    public XjImage getImage(int slice) {
        return new ImageWrap(this, slice);
    }

    public static double[] crossProduct3(double[] c, double[] a, double[] b) {
        if (c == null) {
            c = new double[]{a[1] * b[2] - b[1] * a[2], a[2] * b[0] - b[2] * a[0], a[0] * b[1] - b[0] * a[1]};
        }
        return c;
    }

    private static void normalize(double[] a) {
        double len = Math.sqrt(DMObjectVolume.dot(a, a));
        a[0] = a[0] / len;
        a[1] = a[1] / len;
        a[2] = a[2] / len;
    }

    private static void scaleAdd(double[] a, double k, double[] b, double[] res) {
        res[0] = a[0] + k * b[0];
        res[1] = a[1] + k * b[1];
        res[2] = a[2] + k * b[2];
    }

    private static void sub(double[] a, double[] b, double[] c) {
        c[0] = a[0] - b[0];
        c[1] = a[1] - b[1];
        c[2] = a[2] - b[2];
    }

    private static double dot(double[] a, double[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    private static void filldoubles(String str, double[] dv) {
        String[] s = str.split("\\\\");
        for (int i = 0; i < s.length; ++i) {
            dv[i] = Double.parseDouble(s[i]);
        }
    }

    private MultiChannelDataSupport.Slice[] removeDupSlices(MultiChannelDataSupport.Slice[] slices, double[] v) {
        Vector<MultiChannelDataSupport.Slice> slc = new Vector<MultiChannelDataSupport.Slice>();
        slc.add(slices[0]);
        double[] p = new double[]{slices[0].topLeft[0], slices[0].topLeft[1], slices[0].topLeft[2]};
        double t = 0.0;
        double[] tmp = new double[3];
        for (int i = 1; i < slices.length; ++i) {
            DMObjectVolume.sub(slices[i].topLeft, p, tmp);
            double t1 = DMObjectVolume.dot(tmp, v);
            if (Math.abs(t1 - t) < 0.001) {
                MultiChannelDataSupport.Slice slice = (MultiChannelDataSupport.Slice)slc.lastElement();
                slice.filename = slice.filename + "|" + slices[i].filename + "|" + slices[i].offset;
                continue;
            }
            t = t1;
            slc.add(slices[i]);
        }
        MultiChannelDataSupport.Slice[] newSlices = new MultiChannelDataSupport.Slice[slc.size()];
        for (int i = 0; i < slc.size(); ++i) {
            newSlices[i] = (MultiChannelDataSupport.Slice)slc.get(i);
        }
        return newSlices;
    }

    static {
        String s = null;
        try {
            s = System.getProperty("tap.flipVolume");
        }
        catch (Exception exception) {
            // empty catch block
        }
        flip = s != null ? -1 : 1;
        defaultTags = new DMTag[]{new DMTag(2, 16), new DMTag(8, 96), new DMTag(16, 16), new DMTag(24, 4384), new DMTag(32, 50), new DMTag(32, 55), new DMTag(40, 2), new DMTag(40, 4), new DMTag(40, 8), new DMTag(40, 16), new DMTag(40, 17), new DMTag(40, 18), new DMTag(40, 48), new DMTag(40, 256), new DMTag(40, 257), new DMTag(40, 258), new DMTag(40, 4176), new DMTag(40, 4177), new DMTag(40, 4178), new DMTag(40, 4179)};
    }
}

