/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.volume;

import com.ge.med.idc.XjVolume;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Hashtable;

public abstract class ImageWrapBase {
    public static final int IMGGET_READ = 1;
    public static final int IMGGET_NEW = 2;
    public static final int IMGGET_CACHED = 3;
    protected XjVolume vol;
    protected int slice;
    private BufferedImage slice_img;

    protected BufferedImage buildImage(int w, int h, int type) {
        BufferedImage img = null;
        switch (type) {
            case 0: {
                img = new BufferedImage(w, h, 11);
                break;
            }
            case 1: {
                img = this.build16BitSigned(w, h, null);
                break;
            }
            case 2: {
                img = new BufferedImage(w, h, 5);
            }
        }
        return img;
    }

    protected BufferedImage build16BitSigned(int dimx, int dimy, Hashtable properties) {
        short[] data = new short[dimx * dimy];
        int offset = 0;
        DataBufferShort dbs = new DataBufferShort(data, dimx * dimy, offset);
        int[] bandOffsets = new int[]{0};
        WritableRaster wr = Raster.createInterleavedRaster(dbs, dimx, dimy, dimx, 1, bandOffsets, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[]{16};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, 2);
        try {
            properties.put("PROPERTY_HASH", properties.keys());
        }
        catch (Exception exception) {
            // empty catch block
        }
        BufferedImage img = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), properties);
        return img;
    }

    /*
     * Unable to fully structure code
     */
    public RenderedImage getImageData() {
        if (this.slice_img != null && this.getImageCacheMode() == 3) {
            return this.slice_img;
        }
        dim = this.vol.getVolumeDimensions(null);
        bpv = this.vol.getBitsPerVoxel() / 8;
        size = dim[0] * dim[1] * bpv;
        type = this.vol.getPixelType();
        if (this.slice_img == null) {
            this.slice_img = this.buildImage(dim[0], dim[1], type);
        }
        img = this.slice_img;
        raf = null;
        chan = null;
        try {
            fileName = this.vol.getVSlicePath(this.slice);
            raf = new RandomAccessFile(fileName, "r");
            off = this.vol.getVSliceOffset(this.slice);
            chan = raf.getChannel();
            mode = FileChannel.MapMode.READ_ONLY;
            bb = chan.map(mode, off, size);
            b = this.vol.isVolumeLittleEndian() != false ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            bb.order(b);
            switch (type) {
                case 0: {
                    sbuf = ((DataBufferUShort)img.getRaster().getDataBuffer()).getData();
                    bb.asShortBuffer().get(sbuf);
                    ** break;
lbl28:
                    // 1 sources

                    break;
                }
                case 1: {
                    sbuf = ((DataBufferShort)img.getRaster().getDataBuffer()).getData();
                    bb.asShortBuffer().get(sbuf);
                    ** break;
lbl34:
                    // 1 sources

                    break;
                }
                case 2: {
                    bbuf = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
                    bb.get(bbuf);
                    break;
                }
                ** default:
lbl41:
                // 1 sources

                break;
            }
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != chan) {
                try {
                    chan.close();
                }
                catch (IOException var17_21) {}
            }
            if (null != raf) {
                try {
                    raf.close();
                }
                catch (IOException var17_22) {}
            }
        }
        if (this.getImageCacheMode() == 2) {
            this.slice_img = null;
        }
        return img;
    }

    public abstract int getImageCacheMode();
}

