/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dmui.table;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peerutils.Util;
import com.ge.med.terra.tap.dmui.table.DmuFormatterAdapter;
import java.util.ArrayList;
import java.util.Comparator;

public class DmuFormatDefault
extends DmuFormatterAdapter {
    protected String tagStr;
    protected Comparator<DMObject> defcomp = new Comparator<DMObject>(){

        @Override
        public int compare(DMObject dmo1, DMObject dmo2) {
            if (dmo1 == null) {
                return 1;
            }
            if (dmo2 == null) {
                return -1;
            }
            Object o1 = dmo1.getValue(DmuFormatDefault.this.tagStr);
            Object o2 = dmo2.getValue(DmuFormatDefault.this.tagStr);
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 instanceof String) {
                return ((String)o1).compareTo(o2.toString());
            }
            if (o1 instanceof Integer && o2 instanceof Integer) {
                return ((Integer)o1).compareTo((Integer)o2);
            }
            return o1.hashCode() - o2.hashCode();
        }
    };

    public DmuFormatDefault(String str) {
        this.tagStr = str;
    }

    @Override
    public String getName() {
        return this.tagStr;
    }

    @Override
    public int getPreferredWidth() {
        return 50;
    }

    @Override
    public Comparator<DMObject> getComparator() {
        return this.defcomp;
    }

    @Override
    public DMTag[] getNeededTags() {
        String[] tagStrs = Util.breakupString(this.tagStr);
        ArrayList<DMTag> tags = new ArrayList<DMTag>(tagStrs.length);
        for (int i = 0; i < tagStrs.length; ++i) {
            if ((i & 1) != 0) continue;
            tags.add(DMTag.parseTagString(tagStrs[i]));
        }
        return tags.toArray(new DMTag[tags.size()]);
    }

    @Override
    public Object getValue(DMTagValueInterface tagValIF) {
        Object obj = Util.getValue(tagValIF, this.tagStr);
        if (obj == null) {
            return "";
        }
        return obj;
    }
}

