/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.clientServer.Utils;
import com.ge.med.terra.tap.util.clientServer.XmBasicService;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;

public class DicomTransfer
extends XmBasicService {
    static String[] mfDicom = new String[]{"\\\\3.70.204.14\\images\\NM\\cmp0000001397_fixed.tdb", "\\\\3.70.204.14\\images\\NM\\cmp0000000790_fixed.tdb", "\\\\3.70.204.14\\images\\NM\\cmp0000001389_fixed.tdb", "\\\\3.70.204.14\\images\\NM\\cmp0000000050.tdb", "\\\\3.70.204.14\\images\\CJK\\Jp_12", "\\\\3.70.204.14\\images\\i18n\\Jp_12", "\\\\3.70.204.14\\images\\hast\\dicom01238.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01239.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00687.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00726.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00240.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00241.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00242.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00243.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00244.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00245.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00246.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00247.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00248.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00249.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00250.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00251.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00252.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00253.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00254.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00256.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00257.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00948.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00949.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00950.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00951.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00264.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00265.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00953.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00266.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00954.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00267.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00955.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00268.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00269.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00270.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00271.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00272.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00273.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00274.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00969.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00970.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00316.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01087.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01090.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01092.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01094.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01095.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01097.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01102.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01104.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01106.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01108.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01109.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01110.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01111.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01114.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01115.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01117.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01118.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01121.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01123.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01126.dcm", "\\\\3.70.204.14\\images\\xray\\00000001", "\\\\3.70.204.14\\images\\mr-mf\\DYNMAMMO", "\\\\3.70.204.14\\images\\mr-mf\\ILIACSUB", "\\\\3.70.204.14\\images\\mr-mf\\MOVEKNEE", "\\\\3.70.204.14\\images\\mr-mf\\MOVEKNIN", "\\\\3.70.204.14\\images\\mr-mf\\MPRSAGBR", "\\\\3.70.204.14\\images\\mr-mf\\VOLBRAIN", "\\\\3.70.204.14\\images\\mr-mf\\VHMFLEGS", "\\\\3.70.204.14\\images\\mr-mf\\BIGHEART", "\\\\3.70.204.14\\images\\mr-mf\\BRFLAIR", "\\\\3.70.204.14\\images\\nmbug\\47200423483531219384.tdb", "\\\\3.70.204.14\\images\\multiframe\\rmimage.3155"};
    byte TRANSFER = 0;
    byte SEND = 1;
    byte TOPP = (byte)2;
    Vector que;
    HashMap files;
    dicomParser parser;
    HashMap map;
    final int HEADER = 20;
    boolean sending;
    static FileFilter mffilter = new FileFilter(){
        tagValue[] tv = new tagValue[]{new tagValue(40, 8)};
        dicomParser parser = new dicomParser();
        HashSet exclude = new HashSet<String>(Arrays.asList(".tar", ".tgz", ".gz"));

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            if (550000L > pathname.length()) {
                return false;
            }
            String s = pathname.getName();
            int index = s.lastIndexOf(".");
            if (index > 0 && this.exclude.contains(s.substring(index))) {
                return false;
            }
            try {
                int frames;
                this.parser.setFile(pathname.getAbsolutePath());
                this.parser.fill(this.tv);
                int n = frames = this.tv[0].value != null ? Integer.parseInt((String)this.tv[0].value) : 1;
                if (frames > 1) {
                    System.out.println(pathname.getAbsolutePath());
                    boolean bl = true;
                    return bl;
                }
            }
            catch (FileNotFoundException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.parser.clearFile();
            }
            return false;
        }
    };
    static long lasttime = System.nanoTime();

    public DicomTransfer() {
        this.setMethods(new String[]{"__requestTransfer", "__send", "__highPriority"});
        this.que = new Vector();
        this.files = new HashMap();
        this.que.add(new Packet());
        this.parser = new dicomParser();
        this.map = new HashMap();
        this.HEADER = 20;
        this.sending = false;
    }

    public byte[] __requestTransfer(byte[] data) throws IOException {
        String[] s = new String(data).split("\\|");
        DicomFile d = this._requestTransfer(Integer.parseInt(s[0]), s[1], s[2]);
        int n = d.noOfFames;
        byte[] ret = new byte[8];
        Utils.putInt(ret, 0, n);
        Utils.putInt(ret, 4, (int)(d.startOfFrames + (long)(d.noOfFames * d.frameSize)));
        return ret;
    }

    private DicomFile _requestTransfer(int id, String src, String dest) throws IOException {
        DicomFile d = new DicomFile(src);
        for (int i = 0; i <= d.noOfFames; ++i) {
            this.que.add(new Packet(id, d, dest, i));
        }
        return d;
    }

    public int requestTransfer(String src, String dest) {
        int id = DicomTransfer.newTid();
        Task t = new Task();
        t.src = src;
        t.dest = dest;
        this.map.put(new Integer(id), t);
        String str = id + "|" + src + "|" + dest;
        int tid = this.call(this.TRANSFER, (byte)4, str.getBytes());
        byte[] ret = this.waitForRsp(this.TRANSFER, tid);
        int n = Utils.getInt(ret, 0);
        t.fileLength = Utils.getInt(ret, 4);
        t.frameLoaded = new byte[n + 1];
        return id;
    }

    private void send() throws IOException {
        int ret;
        boolean endOfFrame;
        if (this.que.isEmpty()) {
            this.sending = false;
            return;
        }
        Packet p = (Packet)this.que.get(0);
        if (p.src == null) {
            this.sending = false;
            return;
        }
        this.sending = true;
        File f = new File(p.src);
        if (p.fis == null) {
            p.fis = new RandomAccessFile(f, "r");
        }
        int read = 4096;
        byte[] data = new byte[read + 20];
        long off = p.offset + (long)p.partSent;
        boolean bl = endOfFrame = p.len - p.partSent <= read;
        if (endOfFrame) {
            read = p.len - p.partSent;
            p.partSent += read;
            this.que.remove(p);
        } else {
            p.partSent += read;
        }
        p.fis.seek(off);
        for (int got = 0; got < read; got += ret) {
            ret = p.fis.read(data, 20, read);
            if (ret != -1) continue;
            throw new IOException("failed to finish read");
        }
        if (endOfFrame) {
            p.fis.close();
        }
        ByteBuffer buff = ByteBuffer.wrap(data);
        buff.putLong(off);
        buff.putInt(read);
        buff.putInt(p.id);
        buff.putInt(endOfFrame ? p.frame : -1);
        int tid = this.call(this.SEND, (byte)6, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] __send(byte[] data) throws IOException {
        block10: {
            ByteBuffer buff = ByteBuffer.wrap(data);
            long off = buff.getLong();
            int read = buff.getInt();
            int id = buff.getInt();
            int frame = buff.getInt();
            Task t = (Task)this.map.get(new Integer(id));
            try {
                if (t.fos == null) {
                    t.fos = new RandomAccessFile(t.dest, "rw");
                    t.fos.setLength(t.fileLength);
                }
                t.fos.seek(off);
                t.fos.write(data, 20, read);
                if (frame == -1) break block10;
                Tap.log.log(Level.FINER, "Deactivating full bandwidth mode for DicomTransfer");
                this.getParent().setFullBandwidth(false);
                t.frameLoaded[frame] = 2;
                t.fos.getChannel().force(true);
                Task task = t;
                synchronized (task) {
                    t.notifyAll();
                }
                boolean done = true;
                for (int i = 0; i < t.frameLoaded.length; ++i) {
                    if (2 == t.frameLoaded[i]) continue;
                    done = false;
                }
                t.done = done;
                if (!done) break block10;
                t.fos.close();
                t.fos = null;
                Task task2 = t;
                synchronized (task2) {
                    t.notifyAll();
                }
            }
            catch (Exception e) {
                Tap.log.log(Level.WARNING, "Unable to send data: ", e);
            }
        }
        return null;
    }

    @Override
    protected void messageSent() {
        if (this.que.isEmpty()) {
            return;
        }
        try {
            this.send();
        }
        catch (IOException e) {
            Tap.log.log(Level.WARNING, "Unable to send packet: ", e);
        }
    }

    public void topPriority(int id, int frame) {
        Task t = (Task)this.map.get(new Integer(id));
        if (0 != t.frameLoaded[frame]) {
            return;
        }
        t.frameLoaded[frame] = 1;
        Tap.log.log(Level.FINER, "Activating full bandwidth mode for DicomTransfer");
        this.getParent().setFullBandwidth(true);
        int f = this.call(this.TOPP, (byte)6, (t.src + "|" + frame).getBytes());
    }

    public byte[] __highPriority(byte[] data) throws IOException {
        String[] s = new String(data).split("\\|");
        this._highPriority(s[0], Integer.parseInt(s[1]));
        return null;
    }

    private void _highPriority(String src, int frame) throws FileNotFoundException {
        int moveto = 0;
        for (int i = 0; i < this.que.size(); ++i) {
            Packet p = (Packet)this.que.get(i);
            if (!src.equals(p.src) || p.frame != frame && p.frame != 0) continue;
            this.que.remove(p);
            if (p.frame == 0) {
                this.que.add(0, p);
                moveto = 1;
                if (frame != 0) continue;
                break;
            }
            this.que.add(moveto, p);
            break;
        }
        try {
            this.send();
        }
        catch (IOException e) {
            Tap.log.log(Level.WARNING, "Unable to send packet after bumping priority: ", e);
        }
    }

    private void printQue() {
        for (int i = 0; i < this.que.size(); ++i) {
            Packet p = (Packet)this.que.get(i);
            if (p.src == null) {
                System.out.println("--- stop ---");
            } else {
                System.out.println(p.src.substring(p.src.lastIndexOf("/")) + ":" + p.frame);
            }
            if (i <= 4) continue;
            System.out.println("...");
            break;
        }
    }

    public static Object get(tagValue[] t, int g, int e) {
        for (int i = 0; i < t.length; ++i) {
            if (t[i].group != g || t[i].element != e) continue;
            return t[i].value;
        }
        return null;
    }

    public static int getBitsPerPix(tagValue[] tget) {
        int bitsPerPix = 0;
        String imgType = ((String)DicomTransfer.get(tget, 40, 4)).trim();
        if (imgType.equals("MONOCHROME2") || imgType.equals("MONOCHROME1")) {
            bitsPerPix = (Integer)DicomTransfer.get(tget, 40, 256) == 16 ? 16 : 8;
        } else if (imgType.equals("RGB")) {
            bitsPerPix = 24;
        } else if (imgType.equals("PALETTE COLOR")) {
            bitsPerPix = (Integer)DicomTransfer.get(tget, 40, 256) == 16 ? 16 : 8;
        } else {
            System.err.println("could not parse \"" + imgType + "\"");
        }
        return bitsPerPix;
    }

    public static Object get(HashMap map, Integer ge) {
        tagValue tv = (tagValue)map.get(ge);
        if (tv == null) {
            return null;
        }
        return tv.value;
    }

    public tagValue[] getTags() {
        int[][] tags = new int[][]{{2, 16}, {16, 16}, {40, 2}, {40, 4}, {40, 8}, {40, 16}, {40, 17}, {40, 18}, {40, 256}, {40, 257}, {40, 258}, {40, 259}, {32736, 16}};
        tagValue[] tget = new tagValue[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            tget[i] = new tagValue(tags[i][0], tags[i][1]);
        }
        tget[tget.length - 1].setFillValue(false);
        return tget;
    }

    public int getTask(String src) {
        Set s = this.map.keySet();
        for (Integer element : s) {
            if (!((Task)this.map.get((Object)element)).src.equals(src)) continue;
            return element;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTask(int id) {
        Task t = (Task)this.map.get(new Integer(id));
        if (t == null) {
            throw new NoSuchElementException("no id named " + id);
        }
        try {
            Task task = t;
            synchronized (task) {
                while (!t.done) {
                    t.wait();
                }
            }
        }
        catch (InterruptedException e) {
            Tap.log.log(Level.WARNING, "Unable to wait for task=" + id + ": ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFrame(int id, long timeout, int frame) throws InterruptedException {
        Task t = (Task)this.map.get(new Integer(id));
        if (t == null) {
            throw new NoSuchElementException("no id named " + id);
        }
        Task task = t;
        synchronized (task) {
            while (2 != t.frameLoaded[frame]) {
                t.wait(timeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTask(int id, long timeout) {
        Task t = (Task)this.map.get(new Integer(id));
        if (t == null) {
            throw new NoSuchElementException("no id named " + id);
        }
        try {
            Task task = t;
            synchronized (task) {
                while (!t.done) {
                    t.wait(timeout);
                }
            }
        }
        catch (InterruptedException e) {
            Tap.log.log(Level.WARNING, "Unable to wait for task=" + id + ", timeout=" + timeout + ": ", e);
        }
    }

    public static File[] find(File file, FileFilter ff) {
        ArrayList<File> al = new ArrayList<File>();
        al.add(file);
        for (int i = 0; i < al.size(); ++i) {
            file = (File)al.get(i);
            System.out.println(i + "," + file.getAbsolutePath());
            if (!file.isDirectory()) continue;
            al.remove(i);
            --i;
            al.addAll(Arrays.asList(file.listFiles(ff)));
        }
        return al.toArray(new File[al.size()]);
    }

    public static void ptimer(String s) {
        if (s != null) {
            long now = System.nanoTime() - lasttime;
            System.out.println(lasttime + ": " + (float)now / 1000000.0f + " ms");
        }
        lasttime = System.nanoTime();
    }

    public static void main_OLD(String[] args) {
        DicomTransfer dt = new DicomTransfer();
        long count = 0L;
        File tmp = new File("C:\\MFout");
        tmp.mkdir();
        for (int i = 0; i < mfDicom.length; ++i) {
            try {
                DicomTransfer.ptimer(null);
                File out = File.createTempFile("image", "dcm", tmp);
                out.deleteOnExit();
                dt.requestTransfer(mfDicom[i], out.getAbsolutePath());
                DicomTransfer.ptimer(mfDicom[i]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            count += new File(mfDicom[i]).length();
        }
        System.out.println(count);
    }

    public static void main(String[] args) {
        XmSession xms = null;
        try {
            Tap.setLogLevel(Level.SEVERE);
            xms = SimpleUtilities.startServer();
            DicomTransfer xss = new DicomTransfer();
            xss.installInto(xms);
            File dir = new File("C:\\MFout");
            System.out.println("........");
            Thread.sleep(2000L);
            System.out.println("........");
            dir.mkdir();
            for (int i = 0; i < mfDicom.length; ++i) {
                File f = new File(mfDicom[i]);
                if (!f.exists()) {
                    System.err.println("\"" + f.getAbsolutePath() + "\" does not exist");
                    continue;
                }
                File tmp = File.createTempFile("multiFrame", ".dcm", dir);
                int id = xss.requestTransfer(mfDicom[i], tmp.getAbsolutePath());
                xss.waitForTask(id);
                SimpleUtilities.compareFiles(mfDicom[i], tmp.getAbsolutePath());
                System.out.println("........");
                boolean worked = tmp.delete();
                if (worked) continue;
                System.out.println("fail to delete !!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
            System.out.println("........");
            Thread.sleep(2000L);
            System.out.println("........");
            Thread.sleep(1000L);
            SimpleUtilities.endServer(xms);
            SimpleUtilities.sleep(2000L);
        }
        catch (Exception e) {
            e.printStackTrace();
            SimpleUtilities.endServer(xms);
        }
    }

    class Task {
        public static final byte DEFAULT = 0;
        public static final byte REQUESTED = 1;
        public static final byte LOADED = 2;
        String src;
        String dest;
        byte[] frameLoaded;
        boolean done;
        long fileLength;
        RandomAccessFile fos;

        Task() {
        }
    }

    class DicomFile {
        String name;
        int noOfFames;
        int frameSize;
        long startOfFrames;

        public DicomFile(String file) throws FileNotFoundException {
            this.name = file;
            DicomTransfer.this.parser.setFile(file);
            tagValue[] tags = DicomTransfer.this.getTags();
            DicomTransfer.this.parser.fill(tags);
            int dimy = (Integer)DicomTransfer.get(tags, 40, 16);
            int dimx = (Integer)DicomTransfer.get(tags, 40, 17);
            int frames = DicomTransfer.get(tags, 40, 8) != null ? Integer.parseInt((String)DicomTransfer.get(tags, 40, 8)) : 1;
            int bits = DicomTransfer.getBitsPerPix(tags);
            this.startOfFrames = tags[tags.length - 1].getOffset();
            String ts = (String)DicomTransfer.get(tags, 2, 16);
            boolean explicitVr = ts.equals(DMUtils.TS_EBE) || ts.equals(DMUtils.TS_ELE);
            this.startOfFrames += (long)(explicitVr ? 12 : 8);
            this.noOfFames = frames;
            this.frameSize = dimx * dimy * (bits / 8);
            DicomTransfer.this.parser.clearFile();
        }

        public String toString() {
            return this.name + "," + this.noOfFames + "," + this.frameSize + "," + this.startOfFrames;
        }
    }

    class Packet {
        String src;
        String dest;
        int frame;
        long offset;
        int partSent = 0;
        int len;
        int id;
        RandomAccessFile fis;

        public String toString() {
            String s = this.src.substring(this.src.lastIndexOf(File.separator) + 1) + " ";
            s = s + "(F" + this.frame + ")";
            return s;
        }

        public Packet() {
            this.id = -1;
            this.frame = -1;
            this.dest = null;
            this.src = null;
        }

        public Packet(int id, DicomFile file, String dest, int frame) {
            this.id = id;
            this.frame = frame;
            this.dest = dest;
            this.src = file.name;
            if (frame == 0) {
                this.offset = 0L;
                this.len = (int)file.startOfFrames;
                return;
            }
            this.offset = file.startOfFrames + (long)(file.frameSize * (frame - 1));
            this.len = file.frameSize;
        }
    }
}

