/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.util.clientServer.XmService;
import com.ge.med.terra.tap.util.clientServer.XmServiceAdapter;
import com.ge.med.terra.tap.util.clientServer.XmServiceStatus;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DisplayDemoService
extends JPanel
implements XmService {
    XmServiceStatus status;
    XmSession xms;
    short serviceType;
    byte[] sbuff = new byte[100];
    ByteBuffer readBuffer = ByteBuffer.wrap(this.sbuff);
    BufferedImage img;
    byte[] bytedata = new byte[0];
    boolean server = true;
    BufferedImage serverimg = null;
    byte[] serverData = null;

    public DisplayDemoService() {
        this.status = new XmServiceStatus();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("DisplayDemoService");
        DisplayDemoService p = new DisplayDemoService();
        f.setContentPane(p);
        f.setDefaultCloseOperation(3);
        f.setBounds(10, 10, 512, 512);
        f.setVisible(true);
        XmSession xms = new XmSession("3.70.208.122", 5248);
        xms.installHandle(p);
    }

    @Override
    public void setID(short type) {
        this.serviceType = type;
    }

    @Override
    public short getID() {
        return this.serviceType;
    }

    @Override
    public void setParent(XmSession client) {
        this.xms = client;
        this.server = !client.isClient();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, null);
        }
    }

    @Override
    public int readMessage(InputStream is) throws IOException {
        return this.server ? this.readServerMessage(is) : this.readClientMessage(is);
    }

    public int readClientMessage(InputStream is) throws IOException {
        int n;
        int[] imgbuf;
        if (this.img == null || this.img.getWidth() != this.getWidth() || this.img.getHeight() != this.getHeight()) {
            this.img = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        }
        if (this.bytedata.length != (imgbuf = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData()).length * 4) {
            this.bytedata = new byte[imgbuf.length * 4];
        }
        int len = 0;
        while ((len += (n = is.read(this.bytedata, len, this.bytedata.length - len))) < this.bytedata.length) {
        }
        ByteBuffer.wrap(this.bytedata).asIntBuffer().get(imgbuf);
        this.repaint();
        return len;
    }

    public int readServerMessage(InputStream is) throws IOException {
        int n;
        int len = 0;
        while ((len += (n = is.read(this.sbuff, len, this.sbuff.length - len))) < this.sbuff.length) {
        }
        this.readBuffer.position(0);
        int w = this.readBuffer.getInt();
        int h = this.readBuffer.getInt();
        int x = this.readBuffer.getInt();
        int y = this.readBuffer.getInt();
        if (this.serverimg == null || this.serverimg.getWidth() != w) {
            this.serverimg = new BufferedImage(w, h, 1);
            this.serverData = new byte[4 * w * h];
        }
        Graphics g = this.serverimg.getGraphics();
        g.setColor(Color.black);
        g.fillRect(0, 0, w, h);
        g.setColor(Color.red);
        g.drawArc(x - 20, y - 20, 40, 40, 0, 360);
        g.setColor(Color.blue);
        g.drawString("(" + x + "," + y + ")", 20, 50);
        int[] imgbuf = ((DataBufferInt)this.serverimg.getRaster().getDataBuffer()).getData();
        ByteBuffer bdata = ByteBuffer.wrap(this.serverData);
        bdata.asIntBuffer().put(imgbuf);
        XmServiceAdapter s = new XmServiceAdapter(){

            @Override
            public short getID() {
                return DisplayDemoService.this.serviceType;
            }

            @Override
            public int writeMessage(OutputStream is, short mid) throws IOException {
                is.write(DisplayDemoService.this.serverData);
                return DisplayDemoService.this.serverData.length;
            }
        };
        this.xms.writeMessage(s);
        return this.serverData.length;
    }

    @Override
    public int writeMessage(OutputStream is, short mid) throws IOException {
        return 0;
    }

    private void jbInit() throws Exception {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                DisplayDemoService.this.this_mouseDragged(e);
            }
        });
    }

    public void this_mouseDragged(MouseEvent e) {
        final byte[] data = new byte[this.sbuff.length];
        ByteBuffer b = ByteBuffer.wrap(data);
        b.putInt(this.getWidth());
        b.putInt(this.getHeight());
        b.putInt(e.getX());
        b.putInt(e.getY());
        XmServiceAdapter s = new XmServiceAdapter(){

            @Override
            public short getID() {
                return DisplayDemoService.this.serviceType;
            }

            @Override
            public int writeMessage(OutputStream is, short mid) throws IOException {
                is.write(data);
                return data.length;
            }
        };
        this.xms.writeMessage(s);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void connectionLost() {
    }

    @Override
    public XmServiceStatus getStatus() {
        return this.status;
    }
}

