/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SyncManager {
    private long timeout = 40000000L;
    private static int tcount;
    private final Map responseMap = Collections.synchronizedMap(new HashMap());

    public synchronized int newTid() {
        return ++tcount;
    }

    private static Long genkey(int type, int tid) {
        return new Long((long)type << 32 | (long)tid);
    }

    private int[] parsekey(Long key) {
        int[] vals = new int[]{(int)(key >> 32 & 0xFFFFFFFFFFFFFFFFL), (int)(key & 0xFFFFFFFFFFFFFFFFL)};
        return vals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForResponse(int type, int tid) {
        Long key = SyncManager.genkey(type, tid);
        long start = System.currentTimeMillis();
        Map map = this.responseMap;
        synchronized (map) {
            while (!this.responseMap.containsKey(key)) {
                try {
                    this.responseMap.wait(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - start <= this.timeout) continue;
                throw new RuntimeException("response timeout");
            }
            return this.responseMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(int type, int tid, Object msg) {
        Long msgT = SyncManager.genkey(type, tid);
        Map map = this.responseMap;
        synchronized (map) {
            this.responseMap.put(msgT, msg);
            this.responseMap.notifyAll();
        }
    }

    public void clearResponse(int type, int tid) {
        this.responseMap.remove(SyncManager.genkey(type, tid));
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

