/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.rm.RmService;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.clientServer.CompressedInputStream;
import com.ge.med.terra.tap.util.clientServer.CompressedOutputStream;
import com.ge.med.terra.tap.util.clientServer.Utils;
import com.ge.med.terra.tap.util.clientServer.XmServer;
import com.ge.med.terra.tap.util.clientServer.XmService;
import com.ge.med.terra.tap.util.clientServer.XmServiceAdapter;
import com.ge.med.terra.tap.util.clientServer.XmServiceStatus;
import com.ge.med.terra.tap.util.clientServer.event.XmSessionEvent;
import com.ge.med.terra.tap.util.clientServer.event.XmSessionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import javax.net.SocketFactory;

public class XmSession {
    public static final int ID_POOL_MIN_LIMIT = 2;
    public static final int HEADER_LENGTH = 32;
    public static final int DEFAULT_CLIENT_TYPE = 0;
    public static final int RECONNECT_TIMEOUT;
    private static final int NUMBER_TRANSFER_INTERVALS = 100;
    private static final int DEFAULT_NUM_SERVICES = 40;
    private static final int INCR_NUM_SERVICES = 1;
    private static final double KB_TO_B = 1024.0;
    private static final double NSEC_TO_SEC = 1.0E9;
    public int readMsgCounter = 0;
    public long readCounter = 0L;
    public int writeMsgCounter = 0;
    public long writeCounter = 0L;
    boolean client = true;
    boolean compressed = false;
    short id = (short)-1;
    long[] inBytes = new long[40];
    long[] outBytes = new long[40];
    volatile XmService[] services = new XmService[40];
    Socket socket;
    Vector msgQue = new Vector();
    private static HashMap map;
    private static SocketFactory factorySF;
    private Object servicesLock = new Object();
    private SocketFactory socketfactory = null;
    private boolean closed = false;
    private String host;
    private int port;
    private int clientType;
    private boolean terminated = true;
    private Vector oldServiceIds = new Vector();
    private short newServiceId;
    private boolean check = true;
    private byte[] endMarker = new byte[4];
    private byte[] chkMarker = new byte[this.endMarker.length];
    private boolean daemon = true;
    private Thread readerThread;
    private Thread writerThread;
    private short messageCounter = 0;
    private short lastReceivedMid = 0;
    private Vector requestMessageQueue = new Vector();
    private boolean fullBandwidth = false;
    private long[] transferBytes = new long[100];
    private long[] transferDeltaTimes = new long[100];
    private long lastNanoTime = -1L;
    private int transferIndex = -1;
    private int fullBandwidthIndex = 0;
    private double avgTransferRate = 0.0;
    private double maxTransferRate = 0.0;
    private Vector listeners = new Vector();
    private byte state = 0;
    private XmServer server = null;

    private XmSession(boolean isClient) {
        Random r = new Random(654323L);
        r.nextBytes(this.endMarker);
        this.client = isClient;
        this.newServiceId = (short)(isClient ? 1 : 2);
    }

    public XmSession(boolean compress, Socket s, short id, int clientType) {
        this(false);
        this.compressed = compress;
        this.id = id;
        this.clientType = clientType;
        try {
            this.connect(s);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public XmSession(String host, int port) {
        this(true);
        this.initAndConnect(false, null, host, port, 0);
    }

    public XmSession(boolean compress, String host, int port) {
        this(true);
        this.initAndConnect(compress, null, host, port, 0);
    }

    private XmSession(boolean compress, SocketFactory sf, String host, int port, int clientType) {
        this(true);
        this.initAndConnect(compress, sf, host, port, clientType);
    }

    private void initAndConnect(boolean compress, SocketFactory sf, String host, int port, int clientType) {
        this.compressed = compress;
        this.socketfactory = sf;
        this.host = host;
        this.port = port;
        this.clientType = clientType;
        try {
            this.connect();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void factoryUseSocketFactory(SocketFactory sf) {
        factorySF = sf;
    }

    public static XmSession factory(String address) {
        return XmSession.factory(false, address, 0);
    }

    public static XmSession factory(boolean compress, String address) {
        return XmSession.factory(compress, address, 0);
    }

    public static XmSession factory(boolean compress, String address, int clientType) {
        if (map.containsKey(address)) {
            return (XmSession)map.get(address);
        }
        if (address.indexOf(58) < 0) {
            throw new IllegalArgumentException("Port number is not specified: <address>:<port>");
        }
        String[] split = address.split(":");
        int port = 0;
        try {
            port = Integer.parseInt(split[1]);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid port number: " + split[1]);
        }
        XmSession c = new XmSession(compress, factorySF, split[0], port, clientType);
        map.put(address, c);
        return c;
    }

    public static XmSession[] listSessions() {
        return new ArrayList(map.values()).toArray(new XmSession[map.size()]);
    }

    public static boolean factoryContains(String address) {
        return map.containsKey(address);
    }

    protected static void removeFromFactory(XmSession xms) {
        if (map.containsValue(xms)) {
            for (String key : map.keySet()) {
                if (xms != map.get(key)) continue;
                map.remove(key);
            }
        }
    }

    public short getId() {
        return this.id;
    }

    public short newMid() {
        short s = this.messageCounter;
        this.messageCounter = (short)(s + 1);
        return (short)(s % Short.MAX_VALUE);
    }

    public boolean isClient() {
        return this.client;
    }

    public String getHostAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getClientType() {
        return this.clientType;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        if (this.compressed != compressed) {
            this.compressed = compressed;
            try {
                this.socket.close();
            }
            catch (IOException ioex) {
                Tap.log.log(Level.WARNING, "Session id=" + this.id + ": Unable to close socket while setting compression to " + compressed, ioex);
            }
        }
    }

    XmServer getServer() {
        return this.server;
    }

    void setServer(XmServer server) {
        this.server = server;
    }

    public boolean isFullBandwidth() {
        return this.fullBandwidth;
    }

    public synchronized void setFullBandwidth(boolean flag) {
        if (flag) {
            ++this.fullBandwidthIndex;
            if (Tap.log.isLoggable(Level.FINER)) {
                Object[] params = new Object[]{String.valueOf(this.id), String.valueOf(this.fullBandwidthIndex)};
                Tap.log.log(Level.FINER, "Session id={0}: Starting new full bandwidth transfer #{1}", params);
            }
            this.fullBandwidth = true;
        } else {
            --this.fullBandwidthIndex;
            if (0 > this.fullBandwidthIndex) {
                this.fullBandwidthIndex = 0;
                Tap.log.log(Level.WARNING, "Session id={0}: Full bandwidth transfer index is negative.  Resetting to zero.", String.valueOf(this.id));
            }
            if (0 == this.fullBandwidthIndex) {
                this.getTransferRate();
                if (Tap.log.isLoggable(Level.FINER)) {
                    Object[] params = new Object[]{String.valueOf(this.id), String.valueOf(this.fullBandwidthIndex)};
                    Tap.log.log(Level.FINER, "Session id={0}: Stopping new full bandwidth transfer #{1}", params);
                }
                this.fullBandwidth = false;
                this.lastNanoTime = -1L;
            }
        }
    }

    private void updateTransferRate(long bytes, long nanoTime) {
        if (-1L < this.lastNanoTime) {
            int i = ++this.transferIndex % this.transferBytes.length;
            this.transferBytes[i] = bytes;
            this.transferDeltaTimes[i] = nanoTime - this.lastNanoTime;
            if (Tap.log.isLoggable(Level.FINEST)) {
                Object[] params = new Object[]{String.valueOf(this.id), String.valueOf(i), String.valueOf(this.transferBytes[i]), String.valueOf(this.transferDeltaTimes[i])};
                Tap.log.log(Level.FINEST, "Session id={0}: transfer data [{1}] ({2}, {3})", params);
            }
        }
        this.lastNanoTime = nanoTime;
    }

    public double getMaximumTransferRate() {
        return this.maxTransferRate;
    }

    public double getTransferRate() {
        if (this.fullBandwidth) {
            long bytesTotal = 0L;
            long deltaTimesTotal = 0L;
            for (int n = 0; n < this.transferBytes.length && 0L != this.transferBytes[n]; ++n) {
                bytesTotal += this.transferBytes[n];
                deltaTimesTotal += this.transferDeltaTimes[n];
            }
            if (0L != bytesTotal && 0L != deltaTimesTotal) {
                this.avgTransferRate = 976562.5 * (double)bytesTotal / (double)deltaTimesTotal;
                if (this.avgTransferRate > this.maxTransferRate) {
                    this.maxTransferRate = this.avgTransferRate;
                }
            }
            if (Tap.log.isLoggable(Level.FINE)) {
                Object[] params = new Object[]{String.valueOf(this.id), String.valueOf(bytesTotal), String.valueOf(deltaTimesTotal), String.valueOf(this.avgTransferRate), String.valueOf(this.maxTransferRate)};
                Tap.log.log(Level.FINE, "Session id={0}: ave transfer rate = {1} / {2} = {3} KB / sec, max transfer rate {4} KB / sec", params);
            }
        } else if (Tap.log.isLoggable(Level.FINE)) {
            Object[] params = new Object[]{String.valueOf(this.id), String.valueOf(this.avgTransferRate), String.valueOf(this.maxTransferRate)};
            Tap.log.log(Level.FINE, "Session id={0}: ave transfer rate = {1} KB / sec, max transfer rate {2} KB / sec", params);
        }
        return this.avgTransferRate;
    }

    public XmService getHandle(short type) {
        XmService service = 0 < type && type < this.services.length ? this.services[type] : null;
        return service;
    }

    public short installHandle(XmService service) {
        String msg;
        short serviceId;
        if (this.oldServiceIds.size() > 2) {
            Short osi = (Short)this.oldServiceIds.remove(0);
            serviceId = osi;
            msg = "old";
        } else {
            serviceId = this.newServiceId;
            this.newServiceId = (short)(this.newServiceId + 2);
            msg = "new";
        }
        if (Tap.log.isLoggable(Level.FINE)) {
            Object[] params = new Object[]{String.valueOf(this.id), msg, String.valueOf(serviceId), service.getClass().getName()};
            Tap.log.log(Level.FINE, "Session id={0}: Using {1} identifier {2} to install service [{3}]", params);
        }
        this.installHandle(serviceId, service);
        this.sendInstallMessage(serviceId, service.getClass().getName());
        return serviceId;
    }

    protected void installHandle(InputStream is) throws IOException {
        int n;
        byte[] buff = new byte[1024];
        int len = 0;
        do {
            if ((n = is.read(buff, len, 1)) >= 0) continue;
            throw new RuntimeException("Session id=" + this.id + ": Unable to install service.  Wrong length in reading.");
        } while (buff[(len += n) - 1] != 0);
        String str = new String(buff, 0, len).trim();
        String[] sp = str.split(":");
        String className = sp[1];
        short type = Short.parseShort(sp[0]);
        this.installHandle(type, className);
    }

    protected void installHandle(short type, String className) {
        if ("null".equals(className)) {
            this.removeHandle(type);
            return;
        }
        try {
            Class<?> c = Class.forName(className);
            XmService handle = (XmService)c.newInstance();
            this.installHandle(type, handle);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installHandle(short type, XmService service) {
        String sessionID = String.valueOf(this.id);
        Object[] params = new Object[]{sessionID, service.getClass().getName(), String.valueOf(type)};
        if (Tap.log.isLoggable(Level.FINE)) {
            Tap.log.log(Level.FINE, "Session id={0}: Installing service [{1}] as type {2}", params);
        }
        service.setID(type);
        service.setParent(this);
        Object object = this.servicesLock;
        synchronized (object) {
            int oldLength = this.services.length;
            if (type >= oldLength) {
                int newLength = type + 1;
                if (Tap.log.isLoggable(Level.FINE)) {
                    Tap.log.log(Level.FINE, "Session id={0}: Expanding services array to {1}", new Object[]{sessionID, String.valueOf(newLength)});
                }
                XmService[] newmh = new XmService[newLength];
                System.arraycopy(this.services, 0, newmh, 0, oldLength);
                this.services = newmh;
                long[] outTmp = new long[newLength];
                long[] inTmp = new long[newLength];
                System.arraycopy(this.inBytes, 0, inTmp, 0, this.inBytes.length);
                System.arraycopy(this.outBytes, 0, outTmp, 0, this.outBytes.length);
                this.outBytes = outTmp;
                this.inBytes = inTmp;
            }
            this.services[type] = service;
        }
        if (Tap.log.isLoggable(Level.INFO)) {
            Tap.log.log(Level.INFO, "Session id={0}: Installed service [{1}] as type {2}", params);
        }
        XmSession.printServices(sessionID, this.services);
    }

    public void uninstallHandle(short type) {
        Object[] objectArray;
        if (0 == type) {
            throw new IllegalArgumentException("Session id=" + this.id + ": Invalid type " + type);
        }
        this.removeHandle(type);
        if (Tap.log.isLoggable(Level.INFO)) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = String.valueOf(this.id);
            objectArray = objectArray2;
            objectArray2[1] = String.valueOf(type);
        } else {
            objectArray = null;
        }
        Object[] params = objectArray;
        Tap.log.log(Level.INFO, "Session id={0}: Sending message to remove service type {1} remotely", params);
        this.sendInstallMessage(type, "null");
        Tap.log.log(Level.INFO, "Session id={0}: Adding service type {1} to pool", params);
        this.oldServiceIds.add(new Short(type));
    }

    protected void removeAllHandle() {
        for (short i = 1; i < this.services.length; i = (short)(i + 1)) {
            if (null == this.services[i]) continue;
            this.removeHandle(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHandle(short type) {
        String sessionID = String.valueOf(this.id);
        if (0 > type || this.services.length <= type) {
            throw new IllegalArgumentException("Session id=" + sessionID + ": Invalid type " + type);
        }
        if (0 == type) {
            if (Tap.log.isLoggable(Level.INFO)) {
                Tap.log.log(Level.INFO, "Session id={0}: Received request to close session and remove all services.", sessionID);
            }
            this.closeLocalConnection();
        } else {
            XmService service = this.getHandle(type);
            if (null != service) {
                String serviceName = service.getClass().getName();
                Object[] params = new Object[]{sessionID, serviceName, String.valueOf(type)};
                if (Tap.log.isLoggable(Level.FINE)) {
                    Tap.log.log(Level.FINE, "Session id={0}: Removing service [{1}] type {2}}", params);
                }
                try {
                    service.connectionLost();
                }
                catch (Exception ex) {
                    Tap.log.log(Level.WARNING, "Session id=" + sessionID + ": Unable to close service [" + serviceName + "] type " + type + ": ", ex);
                }
                Object object = this.servicesLock;
                synchronized (object) {
                    this.services[type] = null;
                }
                if (Tap.log.isLoggable(Level.INFO)) {
                    Tap.log.log(Level.INFO, "Session id={0}: Removed service [{1}] type {2}", params);
                }
                XmSession.printServices(sessionID, this.services);
            } else {
                Tap.log.log(Level.WARNING, "Session id={0}: Service type {1} is already 'null'", new Object[]{sessionID, String.valueOf(type)});
            }
        }
    }

    protected void sendInstallMessage(short type, String className) {
        XmInstallService sendInstall = new XmInstallService(type, className);
        this.writeMessage(sendInstall);
    }

    protected static void printServices(String sessionID, XmService[] services) {
        if (Tap.log.isLoggable(Level.FINER)) {
            String prefix = "com.ge.med.";
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(SimpleUtilities.getLineSeparator());
            sbuf.append("[0] reserved");
            for (int i = 1; i < services.length; ++i) {
                sbuf.append(SimpleUtilities.getLineSeparator());
                sbuf.append("[");
                sbuf.append(i);
                sbuf.append("] ");
                XmService service = services[i];
                if (null == service) {
                    sbuf.append("null");
                    continue;
                }
                sbuf.append(service.getID());
                sbuf.append(" (");
                String name = service.getClass().getName();
                sbuf.append(name.startsWith(prefix) ? name.substring(prefix.length()) : name);
                XmServiceStatus ss = service.getStatus();
                if (null != ss) {
                    sbuf.append(")<-(");
                    name = ss.caller;
                    sbuf.append(name.startsWith(prefix) ? name.substring(prefix.length()) : name);
                    if (null != ss.callerAbove) {
                        sbuf.append(")<-(");
                        name = ss.callerAbove;
                        sbuf.append(name.startsWith(prefix) ? name.substring(prefix.length()) : name);
                        sbuf.append(")");
                    }
                }
                sbuf.append(")");
            }
            if (0 < sbuf.length()) {
                String msg = "Session id=" + sessionID + ": List of Services";
                sbuf.insert(0, msg);
                Tap.log.log(Level.FINER, sbuf.toString());
            }
        }
    }

    void connect() throws UnknownHostException, IOException {
        this.createSocketAndSetupThreads();
        if (Tap.log.isLoggable(Level.INFO)) {
            Tap.log.log(Level.INFO, "Session id={0}: Connect Succeeded", String.valueOf(this.id));
        }
        this.fireConnectedEvent();
    }

    void connect(Socket s) throws IOException {
        this.setupThreads(s);
        if (Tap.log.isLoggable(Level.INFO)) {
            Tap.log.log(Level.INFO, "Session id={0}: Connect with Socket Succeeded", String.valueOf(this.id));
        }
        this.fireConnectedEvent();
    }

    void reconnect() throws UnknownHostException, IOException {
        this.createSocketAndSetupThreads();
        if (Tap.log.isLoggable(Level.INFO)) {
            Tap.log.log(Level.INFO, "Session id={0}: Reconnect Succeeded", String.valueOf(this.id));
        }
        this.fireReconnectedEvent();
    }

    void reconnect(Socket s) throws IOException {
        this.setupThreads(s);
        if (Tap.log.isLoggable(Level.INFO)) {
            Tap.log.log(Level.INFO, "Session id={0}: Reconnect with Socket Succeeded", String.valueOf(this.id));
        }
        this.fireReconnectedEvent();
    }

    private void createSocketAndSetupThreads() throws UnknownHostException, IOException {
        Socket s = this.socketfactory != null ? this.socketfactory.createSocket(this.host, this.port) : new Socket(this.host, this.port);
        try {
            s.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        byte[] buf = new byte[32];
        Utils.putFloat(buf, 0, 1.0f);
        Utils.putShort(buf, 4, this.id);
        Utils.putBoolean(buf, 6, this.compressed);
        Utils.putInt(buf, 7, this.clientType);
        s.getOutputStream().write(buf);
        Utils.readFully(s.getInputStream(), buf);
        this.id = Utils.getShort(buf, 0);
        this.setupThreads(s);
    }

    private void setupThreads(Socket s) throws IOException {
        if (!this.terminated) {
            this.terminateConnection();
            try {
                if (this.readerThread != null) {
                    this.readerThread.join(3000L);
                }
                if (this.writerThread != null) {
                    this.writerThread.join(3000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.terminated = false;
        short lastConfirmedMid = 0;
        byte[] buf = new byte[2];
        if (this.isClient()) {
            Utils.putShort(buf, 0, this.lastReceivedMid);
            s.getOutputStream().write(buf);
            lastConfirmedMid = Utils.readShort(s.getInputStream(), buf);
        } else {
            lastConfirmedMid = Utils.readShort(s.getInputStream(), buf);
            Utils.putShort(buf, 0, this.lastReceivedMid);
            s.getOutputStream().write(buf);
        }
        this.removeConfirmedRequests(lastConfirmedMid);
        this.messageCounter = (short)(lastConfirmedMid + 1);
        if (!this.requestMessageQueue.isEmpty()) {
            Vector list = new Vector(this.msgQue);
            this.msgQue.clear();
            for (int i = 0; i < this.requestMessageQueue.size(); ++i) {
                Packet packet = (Packet)this.requestMessageQueue.get(i);
                this.msgQue.add(packet.msg);
            }
            this.msgQue.addAll(list);
        }
        this.requestMessageQueue.clear();
        this.socket = s;
        this.reader(this.socket.getInputStream());
        this.writer(this.socket.getOutputStream());
    }

    public synchronized boolean isConnected() {
        return null != this.socket && this.socket.isConnected();
    }

    public void close() {
        if (this.isConnected()) {
            this.closeRemoteConnection();
        } else {
            this.closeLocalConnection();
        }
    }

    protected void closeRemoteConnection() {
        if (Tap.log.isLoggable(Level.INFO)) {
            Tap.log.log(Level.INFO, "Session id={0}: Sending message to close session remotely", String.valueOf(this.id));
        }
        this.sendInstallMessage((short)0, "null");
    }

    protected void closeLocalConnection() {
        if (Tap.log.isLoggable(Level.INFO)) {
            Tap.log.log(Level.INFO, "Session id={0}: Closing session locally", String.valueOf(this.id));
        }
        XmSession.removeFromFactory(this);
        this.closed = true;
        this.terminateConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void terminateConnection() {
        if (!this.terminated) {
            Thread t;
            this.terminated = true;
            Vector vector = this.msgQue;
            synchronized (vector) {
                this.msgQue.notifyAll();
            }
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException ex) {
                Tap.log.log(Level.WARNING, "Session id=" + this.id + ": Unable to close socket connection", ex);
            }
            this.fireDisconnectedEvent();
            if (this.isClient()) {
                t = new Thread(){

                    @Override
                    public void run() {
                        long end = System.currentTimeMillis() + (long)RECONNECT_TIMEOUT;
                        while (!XmSession.this.closed && !XmSession.this.isConnected() && System.currentTimeMillis() < end) {
                            SimpleUtilities.sleep(2000L);
                            try {
                                if (Tap.log.isLoggable(Level.INFO)) {
                                    Tap.log.log(Level.INFO, "Session id={0}: Reconnecting...", String.valueOf(XmSession.this.id));
                                }
                                XmSession.this.reconnect();
                            }
                            catch (Exception exception) {}
                        }
                        if (!XmSession.this.isConnected()) {
                            XmSession.this.removeAllHandle();
                            if (Tap.log.isLoggable(Level.INFO)) {
                                Tap.log.log(Level.INFO, XmSession.this.closed ? "Session id={0}: Connection Closed" : "Session id={0}: Reconnect Failed. Connection Closed", String.valueOf(XmSession.this.id));
                            }
                            XmSession.this.fireClosedEvent();
                        }
                    }
                };
                t.setName("XmSession Client Reconnect Thread");
                t.setDaemon(true);
                t.start();
            } else {
                t = new Thread(){

                    @Override
                    public void run() {
                        long end = System.currentTimeMillis() + (long)RECONNECT_TIMEOUT;
                        while (!XmSession.this.closed && !XmSession.this.isConnected() && System.currentTimeMillis() < end) {
                            SimpleUtilities.sleep(2000L);
                            if (!Tap.log.isLoggable(Level.INFO)) continue;
                            Tap.log.log(Level.INFO, "Session id={0}: Checking for Reconnect request...", String.valueOf(XmSession.this.id));
                        }
                        if (!XmSession.this.isConnected() && XmSession.this.server.removeSession(XmSession.this)) {
                            XmSession.this.removeAllHandle();
                            if (Tap.log.isLoggable(Level.INFO)) {
                                Tap.log.log(Level.INFO, XmSession.this.closed ? "Session id={0}: Connection Closed" : "Session id={0}: Reconnect Failed. Connection Closed", String.valueOf(XmSession.this.id));
                            }
                            XmSession.this.fireClosedEvent();
                        }
                    }
                };
                t.setName("XmSession Server Reconnect Wait Thread");
                t.setDaemon(true);
                t.start();
            }
        }
    }

    protected void reader(InputStream is) throws IOException {
        final FilterInputStream xis = this.isCompressed() ? new CompressedInputStream(is) : new BufferedInputStream(is);
        Thread t = new Thread(){
            byte[] buf = new byte[6];

            @Override
            public void run() {
                try {
                    while (true) {
                        Utils.readFully(xis, this.buf);
                        short currentMid = Utils.getShort(this.buf, 0);
                        short lastConfirmedMid = Utils.getShort(this.buf, 2);
                        XmSession.this.removeConfirmedRequests(lastConfirmedMid);
                        short type = Utils.getShort(this.buf, 4);
                        XmService service = XmSession.this.getHandle(type);
                        if (type == 0) {
                            XmSession.this.installHandle(xis);
                        } else if (null != service) {
                            ++XmSession.this.readMsgCounter;
                            int nbytes = service.readMessage(xis);
                            if (XmSession.this.fullBandwidth) {
                                XmSession.this.updateTransferRate(nbytes, System.nanoTime());
                            }
                            XmSession.this.readCounter += (long)nbytes;
                            short s = type;
                            XmSession.this.inBytes[s] = XmSession.this.inBytes[s] + (long)nbytes;
                            XmSession.this.lastReceivedMid = currentMid;
                        } else {
                            Tap.log.log(Level.SEVERE, "Session id=" + XmSession.this.id + ": Invalid type " + type + " or service is 'null'");
                            XmSession.this.closeLocalConnection();
                            return;
                        }
                        if (!XmSession.this.check || XmSession.this.checkMarker(xis)) continue;
                        String errmsg = "Session id=" + XmSession.this.id + ": End marker check failed for service type " + type + " = " + service;
                        Tap.log.log(Level.WARNING, errmsg);
                    }
                }
                catch (IOException ex) {
                    XmSession.this.terminateConnection();
                    return;
                }
            }
        };
        t.setName("XmSession Reader Thread");
        t.setDaemon(this.daemon);
        t.start();
        this.readerThread = t;
    }

    protected void writer(OutputStream os) throws IOException {
        final FilterOutputStream xos = this.isCompressed() ? new CompressedOutputStream(os) : new BufferedOutputStream(os);
        Thread t = new Thread(){
            byte[] buf = new byte[6];

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        t.setName("XmSession Writer Thread");
        t.setDaemon(this.daemon);
        t.start();
        this.writerThread = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConfirmedRequests(short lastConfirmedMid) {
        Vector vector = this.requestMessageQueue;
        synchronized (vector) {
            Packet packet;
            int index = -1;
            for (int i = 0; i < this.requestMessageQueue.size(); ++i) {
                packet = (Packet)this.requestMessageQueue.get(i);
                if (packet.mid != lastConfirmedMid) continue;
                index = i;
                break;
            }
            if (index > -1) {
                Iterator itr = this.requestMessageQueue.iterator();
                while (itr.hasNext()) {
                    packet = (Packet)itr.next();
                    itr.remove();
                    if (packet.mid != lastConfirmedMid) continue;
                    break;
                }
            }
        }
    }

    private void writeMarker(OutputStream os) throws IOException {
        os.write(this.endMarker);
    }

    private boolean checkMarker(InputStream is) throws IOException {
        int len;
        int n;
        for (len = 0; len < this.chkMarker.length && (n = is.read(this.chkMarker, len, this.chkMarker.length - len)) >= 0; len += n) {
        }
        if (len != this.chkMarker.length) {
            return false;
        }
        return Arrays.equals(this.chkMarker, this.endMarker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessage(XmService service) {
        short type = service.getID();
        if (0 < type && null == this.getHandle(type)) {
            throw new IllegalStateException("Session id=" + this.id + ": Cannot send message. Service type " + type + " is not installed.");
        }
        Vector vector = this.msgQue;
        synchronized (vector) {
            this.msgQue.add(service);
            this.msgQue.notifyAll();
        }
    }

    public void addSessionListener(XmSessionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSessionListener(XmSessionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireConnectedEvent() {
        if (this.isClient()) {
            this.fireCommunicationEvent((byte)1, null, "connected");
        } else {
            this.saveState((byte)1);
        }
    }

    protected void fireDisconnectedEvent() {
        this.fireCommunicationEvent((byte)2, null, "disconnected");
    }

    protected void fireReconnectedEvent() {
        if (this.isClient()) {
            this.fireCommunicationEvent((byte)3, null, "reconnected");
        } else {
            this.saveState((byte)3);
        }
    }

    protected void fireClosedEvent() {
        if (this.isClient()) {
            this.fireCommunicationEvent((byte)0, null, "closed");
        } else {
            this.saveState((byte)0);
        }
    }

    protected byte saveState(byte newState) {
        byte oldState = this.state;
        this.state = newState;
        if (Tap.log.isLoggable(Level.INFO)) {
            String oldStateName = XmSessionEvent.getStateName((byte)oldState);
            String stateName = XmSessionEvent.getStateName((byte)newState);
            Tap.log.log(Level.INFO, "Session id={0}: Switching from {1} to {2}", new Object[]{String.valueOf(this.getId()), oldStateName, stateName});
        }
        return oldState;
    }

    protected void fireCommunicationEvent(byte newState, String message, String methodName) {
        byte oldState = this.saveState(newState);
        XmSessionEvent event = new XmSessionEvent(this, message, oldState, newState);
        XmSessionListener[] listenersArray = this.listeners.toArray(new XmSessionListener[0]);
        try {
            Method method = XmSessionListener.class.getMethod(methodName, event.getClass());
            Object[] args = new Object[]{event};
            for (int i = 0; i < listenersArray.length; ++i) {
                XmSessionListener listener = listenersArray[i];
                try {
                    method.invoke((Object)listener, args);
                    continue;
                }
                catch (Exception ex) {
                    Tap.log.log(Level.WARNING, "Session id=" + this.id + ": " + methodName + "() for " + listener + " failed due to: ", ex);
                }
            }
        }
        catch (NoSuchMethodException nsmex) {
            Tap.log.log(Level.SEVERE, "Session id={0}: Unable to get XmSessionListener method to fire connection event change", String.valueOf(this.id));
        }
    }

    public static void main(String[] args) {
        XmSession c = new XmSession("127.0.0.1", XmServer.DEFAULT_PORT);
        c.installHandle(new RmService());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        c.close();
    }

    static /* synthetic */ boolean access$900(XmSession x0) {
        return x0.terminated;
    }

    static /* synthetic */ Vector access$1000(XmSession x0) {
        return x0.requestMessageQueue;
    }

    static /* synthetic */ short access$600(XmSession x0) {
        return x0.lastReceivedMid;
    }

    static /* synthetic */ void access$1100(XmSession x0, OutputStream x1) throws IOException {
        x0.writeMarker(x1);
    }

    static {
        map = new HashMap();
        factorySF = null;
        int ms = 60000;
        try {
            String str = System.getProperty("RECONNECT_TIMEOUT");
            if (str != null) {
                ms = Integer.parseInt(str);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        RECONNECT_TIMEOUT = ms;
    }

    private static class XmInstallService
    extends XmServiceAdapter {
        private final byte[] message;
        private final boolean closeConnection;

        public XmInstallService(int type, String className) {
            String str = type + ":" + className;
            byte[] strBytes = str.getBytes();
            this.message = new byte[strBytes.length + 1];
            System.arraycopy(strBytes, 0, this.message, 0, strBytes.length);
            this.closeConnection = 0 == type && "null".equals(className);
        }

        @Override
        public short getID() {
            return 0;
        }

        public boolean isCloseConnection() {
            return this.closeConnection;
        }

        @Override
        public int writeMessage(OutputStream is, short mid) throws IOException {
            is.write(this.message);
            return this.message.length;
        }
    }

    private class Packet {
        private short mid;
        private XmService msg;

        public Packet(short mid, XmService msg) {
            this.mid = mid;
            this.msg = msg;
        }
    }
}

