/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FixedStream
extends InputStream {
    private BufferedInputStream underLyingStream = null;
    private BufferedInputStream metaStream = null;
    boolean brokenStream = false;
    int metaSize;
    long bytesRead = 0L;
    long markPosition = -1L;

    public FixedStream(InputStream is) throws IOException {
        this.underLyingStream = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
        try {
            this.setupMetaStream(this.underLyingStream);
        }
        catch (DicomException e) {
            throw new DMException("DicomException: " + e.getMessage());
        }
    }

    @Override
    public int read() throws IOException {
        int byteRead = -1;
        byteRead = this.brokenStream && this.bytesRead < (long)this.metaSize ? this.metaStream.read() : this.underLyingStream.read();
        if (byteRead != -1) {
            ++this.bytesRead;
        }
        return byteRead;
    }

    @Override
    public int available() throws IOException {
        if (this.brokenStream && this.bytesRead < (long)this.metaSize) {
            return this.metaStream.available() + this.underLyingStream.available();
        }
        return this.underLyingStream.available();
    }

    @Override
    public void close() throws IOException {
        this.underLyingStream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.markPosition = this.bytesRead;
        if (this.brokenStream && this.bytesRead < (long)this.metaSize) {
            this.metaStream.mark(readlimit);
        } else {
            this.underLyingStream.mark(readlimit);
        }
    }

    @Override
    public boolean markSupported() {
        if (this.brokenStream && this.bytesRead < (long)this.metaSize) {
            return this.metaStream.markSupported();
        }
        return this.underLyingStream.markSupported();
    }

    @Override
    public void reset() throws IOException {
        if (this.brokenStream && this.markPosition < (long)this.metaSize) {
            this.metaStream.reset();
        } else {
            this.underLyingStream.reset();
        }
        this.bytesRead = this.markPosition;
        this.markPosition = -1L;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.brokenStream && this.bytesRead < (long)this.metaSize) {
            long remainingMeta = (long)this.metaSize - this.bytesRead;
            if (n > remainingMeta) {
                long skipped1 = this.metaStream.skip(remainingMeta);
                long skipped2 = this.underLyingStream.skip(n - remainingMeta);
                this.bytesRead += skipped1 + skipped2;
                return skipped1 + skipped2;
            }
            this.bytesRead += n;
            return this.metaStream.skip(n);
        }
        long skipped = this.underLyingStream.skip(n);
        this.bytesRead += skipped;
        return skipped;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.available() <= 0) {
            return -1;
        }
        int total = 0;
        int read = -1;
        for (int i = 0; i < len; ++i) {
            read = this.read();
            if (read == -1) {
                return total;
            }
            b[i + off] = (byte)read;
            ++total;
        }
        return total;
    }

    private void setupMetaStream(BufferedInputStream is) throws IOException, DicomException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        is.mark(is.available());
        dicomParser p = new dicomParser();
        p.setFile(is);
        tagValue t = new tagValue();
        DicomObject data = new DicomObject();
        while (p.hasMoreTags()) {
            t = p.readNext();
            if (t.group >= 8) break;
            data.set_ge(t.group, t.element, t.value);
        }
        if (t.group > 8) {
            throw new DMException("Group 0x0008 Not Found!");
        }
        if (p.brokenGroup2 || data.get_ge(2, 16).equals("1.2.840.113619.5.2")) {
            this.brokenStream = true;
            data.set_ge(2, 16, "1.2.840.10008.1.2");
            data.set_ge(2, 19, "GSP_TAP");
            DicomObject obj = new DicomObject();
            obj.setFileMetaInformation(data);
            obj.write(out, true);
            ByteArrayInputStream bin = new ByteArrayInputStream(out.toByteArray());
            is.reset();
            is.skip(t.fileOffset);
            this.metaStream = new BufferedInputStream(bin);
            this.metaSize = this.metaStream.available();
        } else {
            is.reset();
            this.metaStream = is;
        }
    }

    public static void main(String[] args) {
        try {
            String fName = "d:/dev/broken.dcm";
            FixedStream in = new FixedStream(new FileInputStream(fName));
            DicomObject dobj = new DicomObject();
            dobj.read(in);
            dobj.dumpVRs(System.out, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

