/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import java.math.BigInteger;
import java.util.UUID;

public class UUIDUtil {
    public static byte[] asByteArray(UUID uuid) {
        int i;
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        for (i = 0; i < 8; ++i) {
            buffer[i] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            buffer[i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return buffer;
    }

    public static UUID toUUID(byte[] byteArray) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(byteArray[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(byteArray[i] & 0xFF);
        }
        UUID result = new UUID(msb, lsb);
        return result;
    }

    public static BigInteger asInteger(UUID uuid) {
        byte[] uuidArray = UUIDUtil.asByteArray(uuid);
        BigInteger uuidInteger = new BigInteger(1, uuidArray);
        return uuidInteger;
    }

    public static UUID toUUID(BigInteger uuidInteger) {
        String uuidHex = uuidInteger.toString(16);
        String[] components = new String[]{uuidHex.substring(0, 8), uuidHex.substring(8, 12), uuidHex.substring(12, 16), uuidHex.substring(16, 20), uuidHex.substring(20)};
        uuidHex = components[0] + "-" + components[1] + "-" + components[2] + "-" + components[3] + "-" + components[4];
        UUID result = UUID.fromString(uuidHex);
        return result;
    }

    public static String randomUUIDAsInteger() {
        return UUIDUtil.asInteger(UUID.randomUUID()).toString();
    }
}

