/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.util.dicom.jdbDictElement;
import com.ge.med.terra.tap.util.dicom.tag;
import com.ge.med.terra.tap.util.dicom.vr;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class jdbDicomDict {
    Hashtable FieldMap;
    String filePath = "";
    private tag tmpTag = new tag(0, 0);

    public jdbDicomDict() {
        this("dicomDict.txt");
    }

    public jdbDicomDict(String fileName) {
        try {
            String str;
            String tagFilePath = System.getenv("TERRA_HOME");
            String externalFile = tagFilePath + File.separator + fileName;
            InputStreamReader stream = null;
            if (new File(externalFile).exists()) {
                stream = new InputStreamReader(new FileInputStream(externalFile));
                this.filePath = externalFile;
            } else {
                stream = new InputStreamReader(this.getClass().getResourceAsStream(fileName));
            }
            LineNumberReader lr = new LineNumberReader(stream);
            this.FieldMap = new Hashtable();
            while ((str = lr.readLine()) != null) {
                tag t;
                if (str.length() < 10) {
                    return;
                }
                jdbDicomDict.println("line = " + str);
                StringTokenizer st = new StringTokenizer(str, ";");
                String s = st.nextToken();
                jdbDictElement field = new jdbDictElement();
                short group = (short)Integer.decode(s).intValue();
                jdbDicomDict.println("group=====" + group);
                s = st.nextToken();
                short element = (short)Integer.decode(s).intValue();
                jdbDicomDict.println("element=======" + element);
                field.dTag = t = new tag(group, element);
                s = st.nextToken("\"");
                s = st.nextToken("\"");
                jdbDicomDict.println("s=======" + s);
                field.tagName = s;
                if (st.hasMoreTokens()) {
                    s = st.nextToken("\"");
                }
                if (st.hasMoreTokens()) {
                    s = st.nextToken("\"");
                    jdbDicomDict.println("vr======" + s);
                    field.vr = vr.StringVRint(s);
                } else {
                    field.vr = 0;
                }
                if (st.hasMoreTokens()) {
                    s = st.nextToken("\";");
                    jdbDicomDict.println("vm=====" + s);
                    field.vm = s;
                }
                this.FieldMap.put(t, field);
            }
            stream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public jdbDictElement getField(tag t) {
        jdbDicomDict.println("foo");
        jdbDictElement field = (jdbDictElement)this.FieldMap.get(t);
        Enumeration e = this.FieldMap.keys();
        while (e.hasMoreElements()) {
            jdbDicomDict.println(e.nextElement());
        }
        jdbDicomDict.println("foo " + this.FieldMap.size());
        return field;
    }

    public String getVM(int group, int element) {
        this.tmpTag.group = (short)group;
        this.tmpTag.element = (short)element;
        jdbDictElement field = (jdbDictElement)this.FieldMap.get(this.tmpTag);
        if (field == null) {
            return null;
        }
        return field.vm;
    }

    public int getVR(int group, int element) {
        this.tmpTag.group = (short)group;
        this.tmpTag.element = (short)element;
        jdbDictElement field = (jdbDictElement)this.FieldMap.get(this.tmpTag);
        if (field == null) {
            return 0;
        }
        return field.vr;
    }

    public String getDescription(int group, int element) {
        this.tmpTag.group = (short)group;
        this.tmpTag.element = (short)element;
        jdbDictElement field = (jdbDictElement)this.FieldMap.get(this.tmpTag);
        if (field == null) {
            return null;
        }
        return field.tagName;
    }

    private static void println(Object o) {
        jdbDicomDict.println(o.toString());
    }

    private static void println(String str) {
    }

    public void addTag(int group, int element, String description, int vr2, String vm) {
        tag t;
        jdbDictElement field = new jdbDictElement();
        field.dTag = t = new tag((short)group, (short)element);
        field.tagName = description;
        field.vr = vr2;
        field.vm = vm;
        this.FieldMap.put(t, field);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                long t1 = System.currentTimeMillis();
                jdbDicomDict dd = new jdbDicomDict();
                long t2 = System.currentTimeMillis();
                System.out.println("done in: " + (t2 - t1) + " ms");
                tag t = new tag(8, 0);
                jdbDictElement jdelem = dd.getField(t);
                System.out.println("done " + jdelem);
                System.out.println("tag.group: " + jdelem.dTag.group + ", tag.element: " + jdelem.dTag.element + ", name: " + jdelem.tagName + ", vr: " + jdelem.vr + ", vm: " + jdelem.vm);
            }
        }
        catch (Exception ex) {
            System.out.println("CWD = " + System.getProperty("user.dir"));
            ex.printStackTrace();
        }
    }
}

