/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.er;

import com.ge.med.terra.tap.util.er.EREvent;
import com.ge.med.terra.tap.util.er.EREventListener;
import com.ge.med.terra.tap.util.er.EventRouter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Vector;

public class ErClient
extends EventRouter {
    private String host = null;
    private int port = -1;
    DataInputStream is;
    DataOutputStream os;
    Socket s;
    private transient HashMap actionListeners = new HashMap();

    public ErClient() {
    }

    public ErClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.connect();
    }

    @Override
    public void connect(String host, int port) {
        this.host = host;
        this.port = port;
        this.connect();
    }

    public void connect() {
        if (this.port == -1) {
            return;
        }
        if (this.host == null) {
            return;
        }
        try {
            this.s = new Socket(this.host, this.port);
            this.setupConnection(this.s);
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setupConnection(Socket s) {
        try {
            this.is = new DataInputStream(s.getInputStream());
            this.os = new DataOutputStream(s.getOutputStream());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                ErClient.this.processEvents();
            }
        };
        t.setDaemon(true);
        t.setName("Event Router");
        t.start();
    }

    private void processEvents() {
        while (true) {
            try {
                while (true) {
                    int num;
                    if ((num = this.is.readInt()) == 0) {
                        continue;
                    }
                    EREvent[] e = new EREvent[num];
                    for (int i = 0; i < e.length; ++i) {
                        e[i] = new EREvent();
                        e[i].read(this.is);
                    }
                    this.fireEREventPerformed(e);
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        ErClient erClient1 = new ErClient();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.connect();
    }

    private void sendRemoveEvent(String type) {
        byte[] data = new byte[100];
        ByteBuffer buff = ByteBuffer.wrap(data);
        buff.putInt(1);
        buff.putInt(14);
        EREvent e = new EREvent();
        e.len = 0;
        e.type = type;
        e.write(buff);
        try {
            this.os.write(data, 0, buff.position());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void sendAddEvent(String type, int frequency) {
        byte[] data = new byte[100];
        ByteBuffer buff = ByteBuffer.wrap(data);
        EREvent e = new EREvent();
        buff.putInt(1);
        buff.putInt(13);
        e.len = 4;
        e.type = type;
        e.getBuffer().putInt(frequency);
        e.write(buff);
        try {
            this.os.write(data, 0, buff.position());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.connect();
    }

    @Override
    public void sendEvent(String type, String msg) {
        EREvent event = new EREvent();
        event.type = type;
        event.msg = msg.getBytes();
        event.len = event.msg.length;
        this.sendEvent(event);
    }

    @Override
    public void sendEvent(EREvent event) {
        try {
            this.os.writeInt(1);
            this.os.writeInt(15);
            event.write(this.os);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void sendEvent(String type, byte[] data) {
        EREvent event = new EREvent();
        event.type = type;
        event.msg = data;
        event.len = data.length;
        this.sendEvent(event);
    }

    @Override
    public synchronized void removeEREventListener(String type, EREventListener l) {
        Vector v = (Vector)this.actionListeners.get(type);
        if (v != null && v.contains(l)) {
            Vector newv = (Vector)v.clone();
            newv.removeElement(l);
            this.actionListeners.put(type, newv);
        }
        this.sendRemoveEvent(type);
    }

    @Override
    public synchronized void addEREventListener(String type, int frequency, EREventListener l) {
        Vector<EREventListener> v = (Vector<EREventListener>)this.actionListeners.get(type);
        if (v == null) {
            v = new Vector<EREventListener>(2);
            this.actionListeners.put(type, v);
        } else {
            v = (Vector)v.clone();
        }
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners.put(type, v);
        }
        this.sendAddEvent(type, frequency);
    }

    protected void fireEREventPerformed(EREvent[] e) {
        if (this.actionListeners != null) {
            Vector listeners = (Vector)this.actionListeners.get(e[0].type);
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((EREventListener)listeners.elementAt(i)).event(e);
            }
        }
    }
}

