/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.search;

public class LCS {
    private static final int ONE_HUNDRED_PERCENT = 100;
    private final int[][] lengths;

    public LCS(String a, String b) {
        int M = a.length();
        int N = b.length();
        this.lengths = new int[M + 1][N + 1];
        for (int i = M - 1; i >= 0; --i) {
            for (int j = N - 1; j >= 0; --j) {
                this.lengths[i][j] = a.charAt(i) == b.charAt(j) ? this.lengths[i + 1][j + 1] + 1 : Math.max(this.lengths[i + 1][j], this.lengths[i][j + 1]);
            }
        }
    }

    public static int getLCSLength(String a, String b) {
        int[][] lengths = new LCS((String)a, (String)b).lengths;
        return lengths[0][0];
    }

    public static String getLCS(String a, String b) {
        int[][] lengths = new LCS((String)a, (String)b).lengths;
        int pos = 0;
        char[] ans = new char[lengths[0][0]];
        int i = 0;
        int j = 0;
        int M = a.length();
        int N = b.length();
        while (i < M && j < N) {
            if (a.charAt(i) == b.charAt(j)) {
                ans[pos++] = a.charAt(i);
                ++i;
                ++j;
                continue;
            }
            if (lengths[i + 1][j] >= lengths[i][j + 1]) {
                ++i;
                continue;
            }
            ++j;
        }
        return new String(ans);
    }

    public static boolean match(String a, String b, boolean ignoreCase, boolean exactMatch) {
        String text;
        String searchString = ignoreCase ? a.toLowerCase() : a;
        String string = text = ignoreCase ? b.toLowerCase() : b;
        if (exactMatch || searchString.length() <= 3) {
            return text.contains(searchString);
        }
        String[] ans = text.split("\\s");
        int min = searchString.length() * 7 / 10;
        for (int i = 0; i < ans.length; ++i) {
            if (ans[i].length() <= min || LCS.getLCSLength(searchString, ans[i]) <= min) continue;
            return true;
        }
        return false;
    }

    public static int percentMatch(String a, String b) {
        if (null == a || null == b) {
            return 0;
        }
        if (0 == a.length() || 0 == b.length()) {
            return 0;
        }
        int lcsLength = LCS.getLCSLength(a, b);
        return lcsLength * 100 / a.length();
    }
}

