/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.socket;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;

public class SocketClient {
    private int len;
    private int read;
    private boolean dBug = true;
    private Socket s;
    private InputStream in;
    private OutputStream out;
    private byte[] buff1 = new byte[5];
    private byte[] buff2 = null;

    public SocketClient() {
    }

    public SocketClient(String ip, String port) {
        try {
            this.s = new Socket(ip, Integer.parseInt(port.trim()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void tcpip_test_stub(String ip, String port, String msg) throws IOException {
        Socket s = new Socket(ip, Integer.parseInt(port.trim()));
        s.setKeepAlive(true);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(s.getOutputStream()));
        BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
        out.write(msg);
        out.flush();
        out.newLine();
        out.flush();
        System.out.println("Wrote- " + msg);
        System.out.println("Read - " + in.readLine());
    }

    public void tcpip_object_test_stub(String ip, String port, String msg) throws IOException {
        Socket s = new Socket(ip, Integer.parseInt(port.trim()));
        ObjectOutputStream out = new ObjectOutputStream(s.getOutputStream());
        ObjectInputStream in = new ObjectInputStream(s.getInputStream());
        out.writeObject(msg);
        out.flush();
        System.out.println("Wrote- " + msg);
        try {
            System.out.println("Read - " + in.readObject());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void tcpip_byte_test_stub(byte[] msg) throws IOException {
        this.tcpip_byte_test_stub(null, null, msg);
    }

    public void tcpip_byte_test_stub(String ip, String port, String msg) throws IOException {
        this.tcpip_byte_test_stub(ip, port, msg.getBytes());
    }

    public void tcpip_byte_test_stub(String ip, String port, byte[] msg) throws IOException {
        int x;
        if (ip != null && port != null) {
            this.s = new Socket(ip, Integer.parseInt(port.trim()));
        }
        this.in = this.s.getInputStream();
        this.out = this.s.getOutputStream();
        this.len = msg.length;
        this.buff1[0] = 1;
        for (x = 1; x <= 4; ++x) {
            this.buff1[x] = (byte)(this.len & 0xFF);
            this.len >>>= 8;
        }
        this.out.write(this.buff1);
        this.out.write(msg);
        this.out.flush();
        this.in.read(this.buff1, 0, 5);
        this.len = 0;
        for (x = 4; x >= 1; --x) {
            this.len <<= 8;
            this.len |= 0xFF & this.buff1[x];
        }
        this.buff2 = new byte[this.len];
        this.read = 0;
        while (this.read < this.len) {
            this.read += this.in.read(this.buff2, this.read, this.len - this.read);
        }
        if (this.dBug) {
            System.out.println("Client Read Type- " + this.buff1[0]);
            System.out.println("Client Read Len - " + this.len);
            System.out.println("Client Read Msg - " + new String(this.buff2));
        }
    }

    public void udp_test_stub(String ip, String port, String msg) {
        String data = msg;
        try {
            DatagramSocket ds = new DatagramSocket();
            DatagramPacket dp = new DatagramPacket(data.getBytes(), data.length(), InetAddress.getLocalHost(), Integer.parseInt(port.trim()));
            ds.send(dp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setDebugOn(boolean b) {
        this.dBug = b;
    }

    public boolean isDebugOn() {
        return this.dBug;
    }

    public void usage() {
        System.out.println("Usage: SocketClient [udp|tcp] IP PORT MESSAGE");
        System.exit(1);
    }

    public static void main(String[] args) {
        SocketClient s = new SocketClient();
        if (args.length < 4) {
            s.usage();
        }
        try {
            if (args[0].equals("tcp")) {
                s.tcpip_byte_test_stub(args[1], args[2], args[3]);
            } else if (args[0].equals("udp")) {
                s.udp_test_stub(args[1], args[2], args[3]);
            } else {
                s.usage();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

