/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.socket;

import com.ge.med.terra.tap.util.socket.CustomSSLSocketFactory;
import com.ge.med.terra.tap.util.socket.LoadTLSConfigurationsUtil;
import com.ge.med.terra.tap.util.socket.TrustManagerComposite;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SocketUtil {
    private static final int DEFAULT_TIMEOUT = 0;
    private static final Logger logger = Logger.getLogger(SocketUtil.class.getName());
    private static Properties tlsConfigProps = new Properties();
    private SSLServerSocketFactory sslServerSocketFactory = null;
    private String[] configuredServerCipherSuites;
    private SSLSocketFactory sslClientSocketFactory = null;
    private String[] configuredClientCipherSuites;
    private String[] filteredServerCipherSuites;
    private String[] filteredClientCipherSuites;
    private String[] clientSSLVersions;
    private KeyManagerFactory keyManagerFactory = null;

    public SocketUtil() {
    }

    public SocketUtil(SSLServerSocketFactory sslServerFactory, SSLSocketFactory sslClientFactory) {
        LoadTLSConfigurationsUtil.getInstance();
        tlsConfigProps = LoadTLSConfigurationsUtil.loadTLSConfigurations();
        LoadTLSConfigurationsUtil.getInstance();
        LoadTLSConfigurationsUtil.setKeyAndTrustStore();
        this.sslServerSocketFactory = sslServerFactory != null ? sslServerFactory : (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        this.sslClientSocketFactory = sslClientFactory != null ? sslClientFactory : (SSLSocketFactory)SSLSocketFactory.getDefault();
        this.initializeCipherSuites();
        this.initializeSSLVersions();
    }

    private void initializeWithDefaultConfig() {
        LoadTLSConfigurationsUtil.getInstance();
        tlsConfigProps = LoadTLSConfigurationsUtil.loadTLSConfigurations();
        LoadTLSConfigurationsUtil.getInstance();
        LoadTLSConfigurationsUtil.setKeyAndTrustStore();
        this.sslServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        String dynamicCertLoading = tlsConfigProps.getProperty("tls.dynamiccertloading");
        if (dynamicCertLoading != null && dynamicCertLoading.trim().toLowerCase().equalsIgnoreCase("true")) {
            logger.log(Level.INFO, "Dicom TLS dynamic cert value is true");
            TrustManagerComposite[] customizedTrustManager = new TrustManagerComposite[]{new TrustManagerComposite()};
            this.doDynamicLoading();
            try {
                if (this.keyManagerFactory != null) {
                    this.sslClientSocketFactory = new CustomSSLSocketFactory(this.keyManagerFactory.getKeyManagers(), customizedTrustManager, null);
                }
            }
            catch (KeyManagementException e) {
                logger.log(Level.SEVERE, "KeyManagementException has occured", e);
            }
            catch (NoSuchAlgorithmException e) {
                logger.log(Level.SEVERE, "NoSuchAlgorithmException has occured. Requested algorithm was not present", e);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception has occured", e);
            }
        } else {
            logger.log(Level.INFO, "Dicom TLS dynamic cert value is false");
            this.sslClientSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        this.initializeCipherSuites();
        this.initializeSSLVersions();
    }

    private void doDynamicLoading() {
        try {
            File keyStoreFile;
            logger.log(Level.INFO, "Certificate configuration loading dynamically");
            String tlsStoreType = KeyStore.getDefaultType();
            String storeType = tlsConfigProps.getProperty("tls.store.type");
            if (storeType != null && !"".equalsIgnoreCase(storeType)) {
                tlsStoreType = storeType.trim();
            }
            KeyStore keyStore = KeyStore.getInstance(tlsStoreType);
            String tlskeyStorePassword = tlsConfigProps.getProperty("tls.keystore.password");
            String tlskeyStore = tlsConfigProps.getProperty("tls.keystore");
            String passwordEncrytion = tlsConfigProps.getProperty("tls.password.encryption");
            if ("on".equalsIgnoreCase(passwordEncrytion) || "true".equalsIgnoreCase(passwordEncrytion)) {
                tlskeyStorePassword = LoadTLSConfigurationsUtil.getDecryptedKeystorePassword();
            }
            if ((keyStoreFile = new File(tlskeyStore)).exists()) {
                try {
                    FileInputStream is = new FileInputStream(new File(tlskeyStore));
                    logger.log(Level.INFO, "Keystore exists... loading keystore with input keystore.jks file");
                    keyStore.load(is, tlskeyStorePassword.toCharArray());
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.SEVERE, "Can't load file, FileNotFoundException", e);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Can't load file, IOException", e);
                }
            } else {
                logger.log(Level.INFO, "Kesytore does not exists... loading keystore with null");
                keyStore.load(null, tlskeyStorePassword.toCharArray());
            }
            this.keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            this.keyManagerFactory.init(keyStore, tlskeyStorePassword.toCharArray());
        }
        catch (UnrecoverableKeyException e) {
            logger.log(Level.SEVERE, "UnrecoverableKeyException has occured. Keystore password and the key password might be different", e);
        }
        catch (KeyStoreException e) {
            logger.log(Level.SEVERE, "KeyStoreException has occured", e);
        }
        catch (CertificateException e) {
            logger.log(Level.SEVERE, "CertificateException has occured", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IOException has occured", e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception has occured", e);
        }
    }

    private void initializeCipherSuites() {
        this.configuredServerCipherSuites = this.readCipherSuitesFromConfig(tlsConfigProps.getProperty("tls.server.ciphersuites"));
        this.configuredClientCipherSuites = this.readCipherSuitesFromConfig(tlsConfigProps.getProperty("tls.client.ciphersuites"));
        this.filteredServerCipherSuites = this.getFilteredServerSocketCipherSuites();
        this.filteredClientCipherSuites = this.getFilteredClientSocketCipherSuites();
    }

    private void initializeSSLVersions() {
        String sslClientVersionsConfigured = tlsConfigProps.getProperty("tls.client.versions", null);
        logger.log(Level.INFO, "Configured tls client versions are " + sslClientVersionsConfigured);
        if (sslClientVersionsConfigured != null) {
            this.clientSSLVersions = sslClientVersionsConfigured.replaceAll("\\s", "").split(",");
        } else {
            logger.warning("No TLS client versions are configured in TLS Properties, Hence jdk takes default versions");
        }
    }

    private String[] readCipherSuitesFromConfig(String cipherSuitesStr) {
        String[] cipherSuitesArray = null;
        if (cipherSuitesStr != null && !cipherSuitesStr.isEmpty()) {
            cipherSuitesArray = cipherSuitesStr.replaceAll("\\s", "").split(",");
        } else {
            logger.warning("No Cipher Suites are configured in TLS Properties.");
        }
        return cipherSuitesArray;
    }

    private String[] getFilteredServerSocketCipherSuites() {
        return this.filterCipherSuites(this.sslServerSocketFactory.getDefaultCipherSuites(), this.configuredServerCipherSuites != null ? this.configuredServerCipherSuites : this.sslServerSocketFactory.getDefaultCipherSuites());
    }

    private String[] getFilteredClientSocketCipherSuites() {
        return this.filterCipherSuites(this.sslClientSocketFactory.getDefaultCipherSuites(), this.configuredClientCipherSuites != null ? this.configuredClientCipherSuites : this.sslClientSocketFactory.getDefaultCipherSuites());
    }

    private String[] filterCipherSuites(String[] defaultCipherSuites, String[] cipherSuites) {
        ArrayList<String> filteredCipherSuites = new ArrayList<String>();
        List<String> defaultCipherSuitesList = Arrays.asList(defaultCipherSuites);
        for (String cipher : cipherSuites) {
            if (defaultCipherSuitesList.contains(cipher)) {
                filteredCipherSuites.add(cipher);
                continue;
            }
            logger.warning("Configured Cipher : " + cipher + " not supported");
        }
        return filteredCipherSuites.toArray(new String[filteredCipherSuites.size()]);
    }

    private void setFilteredCipherSuites(SSLServerSocket sslServerSocket) {
        if (this.filteredServerCipherSuites.length == 0) {
            logger.log(Level.WARNING, "Secure Connection may fail as none of the configured Cipher suite is supported.");
        }
        sslServerSocket.setEnabledCipherSuites(this.filteredServerCipherSuites);
    }

    private void setFilteredCipherSuites(SSLSocket sslClientSocket) {
        if (this.filteredClientCipherSuites.length == 0) {
            logger.log(Level.WARNING, "Secure Connection may fail as configured Cipher suites are not supported.");
        }
        sslClientSocket.setEnabledCipherSuites(this.filteredClientCipherSuites);
    }

    private void setClientProtocols(SSLSocket sslClientSocket) throws IOException {
        ArrayList<String> filterVersionList = new ArrayList<String>();
        List<String> supportedVersionList = Arrays.asList(sslClientSocket.getSupportedProtocols());
        if (this.clientSSLVersions != null && this.clientSSLVersions.length > 0) {
            for (String versionsConfigured : this.clientSSLVersions) {
                if (supportedVersionList.contains(versionsConfigured.trim())) {
                    filterVersionList.add(versionsConfigured.trim());
                    continue;
                }
                logger.log(Level.WARNING, "Configured TLS client version " + versionsConfigured + " is invalid");
            }
            if (filterVersionList.isEmpty()) {
                logger.log(Level.WARNING, "None of the Configured TLS client versions are supported by jdk");
                throw new IOException("Unable to set Configured TLS versions in SSL client socket");
            }
            sslClientSocket.setEnabledProtocols(filterVersionList.toArray(new String[filterVersionList.size()]));
        }
    }

    public void setSSLClientCipherSuites(String[] clientCipherSuites) {
        this.configuredClientCipherSuites = clientCipherSuites;
        this.filteredClientCipherSuites = this.getFilteredClientSocketCipherSuites();
    }

    public void setSSLServerCipherSuites(String[] serverCipherSuites) {
        this.configuredServerCipherSuites = serverCipherSuites;
        this.filteredServerCipherSuites = this.getFilteredServerSocketCipherSuites();
    }

    public SSLServerSocket getSSLServerSocket(int port) throws IOException {
        if (this.sslServerSocketFactory == null) {
            this.initializeWithDefaultConfig();
        }
        SSLServerSocket sslServerSocket = (SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port);
        this.setFilteredCipherSuites(sslServerSocket);
        return sslServerSocket;
    }

    public ServerSocket getServerSocket(int port) throws IOException {
        return new ServerSocket(port);
    }

    public SSLSocket getSSLSocket(String remoteHostName, int port) throws IOException {
        return this.getSSLSocket(remoteHostName, port, 0);
    }

    public SSLSocket getSSLSocket(String remoteHostName, int port, int timeout) throws IOException {
        if (this.sslClientSocketFactory == null) {
            this.initializeWithDefaultConfig();
        }
        SSLSocket sslSocket = (SSLSocket)this.sslClientSocketFactory.createSocket();
        this.setFilteredCipherSuites(sslSocket);
        this.setClientProtocols(sslSocket);
        sslSocket.connect(new InetSocketAddress(remoteHostName, port), timeout);
        return sslSocket;
    }

    public Socket getSocket() throws IOException {
        return new Socket();
    }

    public Socket getSocket(String remoteHostName, int port) throws IOException {
        return this.getSocket(remoteHostName, port, 0);
    }

    public Socket getSocket(String remoteHostName, int port, int timeout) throws IOException {
        Socket sock = new Socket();
        sock.connect(new InetSocketAddress(remoteHostName, port), timeout);
        return sock;
    }
}

