/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.socket;

import com.ge.med.terra.tap.util.socket.LoadTLSConfigurationsUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class TrustManagerComposite
implements X509TrustManager {
    private final X509TrustManager compositeTrustmanager;
    private static Properties tlsConfigProps = new Properties();
    private static final Logger logger = Logger.getLogger(TrustManagerComposite.class.getName());

    public TrustManagerComposite() {
        X509TrustManager trustManagers = null;
        LoadTLSConfigurationsUtil.getInstance();
        tlsConfigProps = LoadTLSConfigurationsUtil.loadTLSConfigurations();
        String tlstrustStore = tlsConfigProps.getProperty("tls.truststore");
        try {
            FileInputStream truststoreInput = new FileInputStream(tlstrustStore);
            trustManagers = TrustManagerComposite.getCustomTrustmanager(truststoreInput);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception", e);
        }
        this.compositeTrustmanager = trustManagers;
    }

    private static X509TrustManager getCustomTrustmanager(InputStream trustStream) throws Exception {
        return TrustManagerComposite.createTrustManager(trustStream);
    }

    private static X509TrustManager createTrustManager(InputStream trustStream) throws Exception {
        TrustManager[] trustManagers;
        String storeType = tlsConfigProps.getProperty("tls.store.type");
        storeType = storeType != null && storeType.trim().length() > 0 ? storeType.trim() : KeyStore.getDefaultType();
        KeyStore trustStore = KeyStore.getInstance(storeType);
        String tlsTrustStorePassword = tlsConfigProps.getProperty("tls.truststore.password");
        if (tlsTrustStorePassword != null && tlsTrustStorePassword.trim().length() > 0) {
            String passwordEncrytion = tlsConfigProps.getProperty("tls.password.encryption");
            if ("on".equalsIgnoreCase(passwordEncrytion) || "true".equalsIgnoreCase(passwordEncrytion)) {
                tlsTrustStorePassword = LoadTLSConfigurationsUtil.getDecryptedTruststorePassword();
            }
            if (tlsTrustStorePassword != null) {
                trustStore.load(trustStream, tlsTrustStorePassword.trim().toCharArray());
            } else {
                logger.log(Level.SEVERE, "Recieved decrypted password as null ");
            }
        } else {
            trustStore.load(trustStream, null);
        }
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustFactory.init(trustStore);
        for (TrustManager trustManager : trustManagers = trustFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        return null;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.compositeTrustmanager.checkClientTrusted(chain, authType);
            return;
        }
        catch (CertificateException e) {
            logger.log(Level.SEVERE, "Exception while trusting the client", e);
            throw new CertificateException("None of the TrustManagers trust this certificate chain");
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.compositeTrustmanager.checkServerTrusted(chain, authType);
            return;
        }
        catch (CertificateException e) {
            logger.log(Level.SEVERE, "Exception while trusting the server ", e);
            throw new CertificateException("None of the TrustManagers trust this certificate chain");
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (X509Certificate cert : this.compositeTrustmanager.getAcceptedIssuers()) {
            certs.add(cert);
        }
        return certs.toArray(new X509Certificate[0]);
    }
}

