/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import com.ge.med.terra.xpv.ui.DragDropScreenPanel;
import com.ge.med.terra.xpv.ui.TitlePanel;
import com.ge.med.terra.xpv.util.ListTransferHandler;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class XPwDragDrapScreen
extends TitlePanel
implements CapableListener {
    static ResourceBundle res = XPutil.getLocalResourceBundle("com.ge.med.terra.xpv.autoControls.UIRes");
    XPscreen screen = null;
    AutoControlPanelSeek panelSeek = new AutoControlPanelSeek(this);
    ListTransferHandler hdl = new ListTransferHandler();
    DefaultListModel contentModel = new DefaultListModel();
    static Font dialogFont = new Font("Dialog", 1, 13);
    JLabel scrnContentLabel = new JLabel();
    JLabel portListLabel = new JLabel();
    DragDropScreenPanel screenContent = new DragDropScreenPanel();
    JList portList = new JList();
    JScrollPane jScrollPane = new JScrollPane();
    JPanel topPanel = new JPanel(new BorderLayout());
    JPanel mainPanel = new JPanel(new BorderLayout());
    private ComponentListener sizeListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            XPwDragDrapScreen.this.calcScreenSize();
        }
    };
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "data_changed" || evt.getPropertyName() == "layout_changed") {
                XPwDragDrapScreen.this.setTargetLayout(XPwDragDrapScreen.this.screen.getScreenLayout());
            }
        }
    };
    private ContainerListener containerListener = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            XPwDragDrapScreen.this.getUpdatedPortList();
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            XPwDragDrapScreen.this.getUpdatedPortList();
        }
    };

    public XPwDragDrapScreen() {
        this.addAncestorListener(this.panelSeek);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.portList.setDragEnabled(true);
        this.portList.setTransferHandler(this.hdl);
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout(2, 2));
        this.setTitle("Screen Content");
        this.scrnContentLabel.setFont(dialogFont);
        this.scrnContentLabel.setHorizontalAlignment(0);
        this.scrnContentLabel.setHorizontalTextPosition(0);
        this.scrnContentLabel.setText(res.getString("Current_Screen_"));
        this.screenContent.setMaximumSize(new Dimension(50, 50));
        this.screenContent.setMinimumSize(new Dimension(50, 50));
        this.screenContent.setPreferredSize(new Dimension(50, 50));
        this.portListLabel.setFont(dialogFont);
        this.portListLabel.setHorizontalAlignment(0);
        this.portListLabel.setHorizontalTextPosition(0);
        this.portListLabel.setText(res.getString("Loaded_Port_"));
        this.portList.setModel(this.contentModel);
        this.portList.setSelectionMode(0);
        this.jScrollPane.setVerticalScrollBarPolicy(22);
        this.jScrollPane.setMinimumSize(new Dimension(100, 150));
        this.jScrollPane.setPreferredSize(new Dimension(300, 150));
        this.jScrollPane.getViewport().add(this.portList);
        this.jScrollPane.setBorder(new EmptyBorder(0, 2, 2, 2));
        this.topPanel.add((Component)this.scrnContentLabel, "North");
        this.topPanel.add((Component)this.screenContent, "Center");
        this.mainPanel.add((Component)this.portListLabel, "North");
        this.mainPanel.add((Component)this.jScrollPane, "Center");
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.mainPanel, "Center");
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
        this.calcScreenSize();
        this.screenContent.setScreenToControl(screen);
        this.hdl.setPanel(screen);
        screen.addPropertyChangeListener(this.viewPortListener);
        screen.addContainerListener(this.containerListener);
        screen.addComponentListener(this.sizeListener);
        this.setTargetLayout(screen.getScreenLayout());
    }

    private void setTargetLayout(XPscreenLayout layout) {
        this.screenContent.setLayout(layout);
        this.getUpdatedPortList();
    }

    private void calcScreenSize() {
        Rectangle sRect = this.screen.getBounds();
        Rectangle iRect = this.screenContent.getBounds();
        if (iRect.width == 0 || iRect.height == 0 || sRect.width == 0 || sRect.height == 0) {
            return;
        }
        if (iRect.width * sRect.height > iRect.height * sRect.width) {
            int offset = (iRect.width - iRect.height * sRect.width / sRect.height) / 2;
            this.screenContent.setBorder(new EmptyBorder(0, offset, 0, offset));
        } else {
            int offset = (iRect.height - iRect.width * sRect.height / sRect.width) / 2;
            this.screenContent.setBorder(new EmptyBorder(offset, 0, offset, 0));
        }
    }

    private void getUpdatedPortList() {
        if (this.screen == null) {
            return;
        }
        JComponent[] comps = this.screen.getAllPorts();
        this.contentModel.clear();
        int count = 0;
        for (int i = 0; i < comps.length; ++i) {
            listContent ls;
            if (comps[i].getName() != null && !comps[i].getName().equals(" ")) {
                ls = new listContent(i, comps[i].getName());
                this.contentModel.add(count, new Object[]{ls, ls.portName});
                ++count;
                continue;
            }
            if (comps[i] instanceof XPscreen.EmptyPort) continue;
            ls = new listContent(i, "NoName" + count);
            comps[i].setName("NoName" + count);
            this.contentModel.add(count, ls);
            ++count;
        }
        this.portList.setModel(this.contentModel);
        this.portList.repaint();
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    class listContent
    implements Icon {
        int portNo = -1;
        String portName;
        final int iconSize = 24;

        listContent(int portNo, String name) {
            this.portNo = portNo;
            this.portName = name;
        }

        public String toString() {
            return this.portName;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.paintIcon(24, 24, g, x, y);
        }

        public void paintIcon(int w, int h, Graphics g, int offx, int offy) {
            XPwDragDrapScreen.this.screen.getScreenLayout().paintIcon(w, h, g, offx, offy, this.portNo);
        }

        @Override
        public int getIconWidth() {
            return 24;
        }

        @Override
        public int getIconHeight() {
            return 24;
        }
    }
}

