/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.idc.CineCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.util.log.Tid;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.autoControls.AutoControlResources;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.Timer;

public class XPwNext
extends JButton
implements CapableListener {
    static ResourceBundle res = AutoControlResources.STRING_RESOURCES;
    AutoControlPanelSeek panelSeek = new AutoControlPanelSeek(this);
    Timer tm = null;

    public XPwNext() {
        this.addAncestorListener(this.panelSeek);
        this.setIcon(new ImageIcon(XPwNext.class.getResource("/com/ge/med/terra/xpv/icons/nextFrame.png")));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setData(DMObject[] objs) {
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
        FramePositioningCapable FPPort = (FramePositioningCapable)this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable");
        if (FPPort != null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void setScreen(XPscreen screen) {
    }

    private void jbInit() throws Exception {
        this.setToolTipText(res.getString("Next_Image_"));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                XPwNext.this.this_keyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                XPwNext.this.this_keyReleased(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                XPwNext.this.this_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                XPwNext.this.this_mouseReleased(e);
            }
        });
    }

    public Integer getFrameIndex() {
        FramePositioningCapable FPPort = (FramePositioningCapable)this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable");
        if (FPPort == null) {
            return null;
        }
        return new Integer(FPPort.getFrameIndex());
    }

    public Integer getMaxFrame() {
        FramePositioningCapable FPPort = (FramePositioningCapable)this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable");
        if (FPPort == null) {
            return null;
        }
        return new Integer(FPPort.getNumFrames());
    }

    void moveNext() {
        XPutil.getLogger().log(Level.FINEST, "Start <XPwNext>  " + Tid.newTid());
        CineCapable cinePort = (CineCapable)this.panelSeek.getCapable("com.ge.med.idc.CineCapable");
        if (cinePort != null && cinePort.getCine()) {
            XPutil.getLogger().log(Level.FINEST, "End <XPwNext>");
            Tid.popTID();
            return;
        }
        FramePositioningCapable FPPort = (FramePositioningCapable)this.panelSeek.getCapable("com.ge.med.idc.FramePositioningCapable");
        if (FPPort == null) {
            XPutil.getLogger().log(Level.FINEST, "End <XPwNext>");
            Tid.popTID();
            return;
        }
        int nf = FPPort.getNumFrames();
        int fi = FPPort.getFrameIndex();
        if (nf == 0) {
            return;
        }
        FPPort.setFrameIndex((fi + 1) % nf);
        ((JComponent)((Object)FPPort)).repaint();
    }

    @Override
    public void setProperties(Properties properties) {
    }

    void this_mousePressed(MouseEvent e) {
        this.moveToNextFrame();
    }

    void stopTimer() {
        if (this.tm == null) {
            return;
        }
        if (this.tm.isRunning()) {
            this.tm.stop();
        }
        this.tm = null;
    }

    void this_mouseReleased(MouseEvent e) {
        this.stopTimer();
    }

    void moveToNextFrame() {
        this.moveNext();
        this.tm = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XPwNext.this.moveNext();
            }
        });
        this.tm.start();
    }

    void this_keyPressed(KeyEvent e) {
        this.moveToNextFrame();
    }

    void this_keyReleased(KeyEvent e) {
        this.stopTimer();
    }
}

