/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.idc.PanZoomCapable;
import com.ge.med.terra.tap.util.log.Tid;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.autoControls.Messages;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class XPwPanYTextField
extends JTextField
implements CapableListener {
    XPscreen screen = null;
    AutoControlPanelSeek panelSeek = null;
    double currentPanY;
    DecimalFormat panFormat = new DecimalFormat("00");
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "pan") {
                XPwPanYTextField.this.updatePanSetting();
            } else if (evt.getPropertyName() == "data_changed") {
                XPwPanYTextField.this.updatePanSetting();
            }
        }
    };

    public XPwPanYTextField() {
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
        PanZoomCapable pzPort = (PanZoomCapable)this.panelSeek.getCapable("com.ge.med.idc.PanZoomCapable");
        if (pzPort == null) {
            return;
        }
        this.setText(this.panFormat.format(pzPort.getPanY()));
        this.currentPanY = pzPort.getPanY();
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
        screen.addPropertyChangeListener(this.viewPortListener);
    }

    private void updatePanSetting() {
        PanZoomCapable pzPort = (PanZoomCapable)this.panelSeek.getCapable("com.ge.med.idc.PanZoomCapable");
        if (pzPort == null) {
            return;
        }
        if (XPutil.compareCallBack(this.currentPanY, pzPort.getPanY())) {
            this.setText(this.panFormat.format(pzPort.getPanY()));
        }
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    private void jbInit() throws Exception {
        this.setFont(new Font("Dialog", 0, 12));
        this.setMinimumSize(new Dimension(30, 23));
        this.setPreferredSize(new Dimension(30, 30));
        this.setToolTipText(Messages.getString("XPwPanYTextField.ycoordValue"));
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setText("0");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XPwPanYTextField.this.this_actionPerformed(e);
            }
        });
    }

    void this_actionPerformed(ActionEvent e) {
        XPutil.getLogger().log(Level.FINEST, "Start <XPwPanYTextField> " + Tid.newTid());
        PanZoomCapable pzPort = (PanZoomCapable)this.panelSeek.getCapable("com.ge.med.idc.PanZoomCapable");
        if (pzPort == null) {
            XPutil.getLogger().log(Level.FINEST, "End <XPwPanYTextField> ");
            Tid.popTID();
            return;
        }
        try {
            pzPort.setPanY(Double.parseDouble(this.getText()));
            this.currentPanY = pzPort.getPanY();
        }
        catch (NumberFormatException ex) {
            this.setText(this.panFormat.format(pzPort.getPanY()));
            this.currentPanY = pzPort.getPanY();
        }
        XPutil.getLogger().log(Level.FINEST, "End <XPwPanYTextField> ");
        Tid.popTID();
    }

    public Double getPanY() {
        PanZoomCapable pzPort = (PanZoomCapable)this.panelSeek.getCapable("com.ge.med.idc.PanZoomCapable");
        if (pzPort == null) {
            return null;
        }
        return new Double(pzPort.getPanY());
    }
}

