/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.cuiPanels;

import com.archimed.dicom.DicomObject;
import com.ge.med.idc.Capable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.util.dicom.WrapperStream;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.CuiPanelResources;
import com.ge.med.terra.xpv.cuiPanels.CuiPanelUtils;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import com.ge.med.terra.xpv.ui.SubTitlePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SaveStatePanel
extends XPcaAutoControlPanel
implements CapableListener {
    private static final String LOCAL_DB = "localDB";
    static ResourceBundle res = CuiPanelResources.STRING_RESOURCES;
    Properties prop;
    int numFrames = 0;
    ButtonGroup btG = new ButtonGroup();
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final String rangeBtn = "range";
    private final String allBtn = "all";
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "data_changed") {
                SaveStatePanel.this.updatePanel(SaveStatePanel.this.screen_.getSelectedPort());
            }
            if (evt.getPropertyName() == "CONTENT_CHANGED") {
                SaveStatePanel.this.updatePanel(SaveStatePanel.this.screen_.getSelectedPort());
            }
        }
    };
    JPanel buttonPanel = new JPanel();
    JPanel infoPanel = new JPanel();
    JPanel imgInfoPanel = new JPanel();
    JPanel imgPanel = new JPanel();
    JPanel rangePanel = new JPanel();
    JPanel allImgPanel = new JPanel();
    JPanel imgRangePanel = new JPanel();
    JRadioButton allImgRadioButton = new JRadioButton();
    JRadioButton rangeImgRadioButton = new JRadioButton();
    JTextField minTextField = new JTextField();
    JLabel max = new JLabel();
    JTextField maxTextField = new JTextField();
    JPanel descrPanel = new JPanel();
    JPanel savePanel = new JPanel();
    JButton saveButton = new JButton();
    JPanel descPanel = new JPanel();
    JLabel desc = new JLabel();
    JTextField descTextField = new JTextField();
    SubTitlePanel subTitlePanel = new SubTitlePanel();
    private final String MIN_FIELD = "minField";
    private final String MAX_FIELD = "maxField";
    boolean all = true;

    public SaveStatePanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.btG.add(this.allImgRadioButton);
        this.btG.add(this.rangeImgRadioButton);
        this.allImgRadioButton.setSelected(true);
        this.subTitlePanel.setTitle(res.getString("SaveStatePanel.save_state_title"));
        this.setBackground(null);
    }

    private void jbInit() throws Exception {
        this.setIcon(CuiPanelUtils.getIcon("SAVE_STATE_ICO"));
        this.setLayout(new BorderLayout());
        this.subTitlePanel.setLayout(new BorderLayout());
        this.buttonPanel.setLayout(new BorderLayout());
        this.infoPanel.setLayout(new GridBagLayout());
        this.imgInfoPanel.setLayout(new GridBagLayout());
        this.imgPanel.setLayout(new BorderLayout());
        this.rangePanel.setLayout(new BorderLayout());
        this.allImgRadioButton.setText(res.getString("SaveStatePanel.all_text"));
        this.rangeImgRadioButton.setText(res.getString("SaveStatePanel.img_from_text"));
        this.minTextField.setPreferredSize(new Dimension(60, 20));
        this.minTextField.setText(res.getString("SaveStatePanel.init_img_text"));
        this.minTextField.setHorizontalAlignment(4);
        this.minTextField.setName("minField");
        this.minTextField.addKeyListener(new DigitKeyListener(this.minTextField));
        this.minTextField.addFocusListener(new SaveStateFocusListener(this.minTextField));
        this.max.setText(res.getString("SaveStatePanel.to_text"));
        this.maxTextField.setPreferredSize(new Dimension(60, 20));
        this.maxTextField.setText(res.getString("SaveStatePanel.final_img_text"));
        this.maxTextField.setHorizontalAlignment(4);
        this.maxTextField.setName("maxField");
        this.maxTextField.addKeyListener(new DigitKeyListener(this.maxTextField));
        this.maxTextField.addFocusListener(new SaveStateFocusListener(this.maxTextField));
        this.descrPanel.setLayout(new BorderLayout());
        this.saveButton.setPreferredSize(new Dimension(120, 27));
        this.saveButton.setText(res.getString("SaveStatePanel.save_button"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveStatePanel.this.save_actionPerformed(e);
            }
        });
        this.desc.setText(res.getString("SaveStatePanel.description_text"));
        this.descTextField.setPreferredSize(new Dimension(150, 30));
        this.descTextField.setHorizontalAlignment(4);
        this.descTextField.setAutoscrolls(true);
        this.infoPanel.add((Component)this.imgInfoPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(-10, 0, 0, 0), 0, 0));
        this.imgInfoPanel.add((Component)this.imgPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.imgPanel.add((Component)this.allImgPanel, "West");
        this.allImgPanel.add(this.allImgRadioButton);
        this.imgInfoPanel.add((Component)this.rangePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.rangePanel.add((Component)this.imgRangePanel, "West");
        this.imgRangePanel.add(this.rangeImgRadioButton);
        this.imgRangePanel.add(this.minTextField);
        this.imgRangePanel.add(this.max);
        this.imgRangePanel.add(this.maxTextField);
        this.imgInfoPanel.add((Component)this.descrPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.descrPanel.add((Component)this.descPanel, "West");
        this.descPanel.add(new JLabel("  "));
        this.descPanel.add(this.desc);
        this.descPanel.add(this.descTextField);
        this.buttonPanel.add((Component)this.savePanel, "Center");
        this.savePanel.add(this.saveButton);
        this.add((Component)this.subTitlePanel, "Center");
        this.subTitlePanel.add((Component)this.infoPanel, "Center");
        this.subTitlePanel.add((Component)this.buttonPanel, "Last");
        this.allImgRadioButton.setName("all");
        this.rangeImgRadioButton.setName("range");
        this.rangeImgRadioButton.addActionListener(new PlayListener());
        this.allImgRadioButton.addActionListener(new PlayListener());
        this.max.setVisible(false);
        this.maxTextField.setVisible(false);
        this.minTextField.setVisible(false);
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
        this.updatePanel(newPort);
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.updatePanel(screen.getSelectedPort());
        screen.removePropertyChangeListener(this.viewPortListener);
        screen.addPropertyChangeListener(this.viewPortListener);
    }

    private void updatePanel(final JComponent comp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (comp instanceof Capable) {
                    Capable capable = (Capable)((Object)comp);
                    FramePositioningCapable fpc = (FramePositioningCapable)capable.getCapable("com.ge.med.idc.FramePositioningCapable");
                    if (fpc != null) {
                        SaveStatePanel.this.numFrames = fpc.getNumFrames();
                        if (SaveStatePanel.this.numFrames > 0) {
                            SaveStatePanel.this.minTextField.setText(Integer.toString(1));
                            SaveStatePanel.this.maxTextField.setText(Integer.toString(SaveStatePanel.this.numFrames));
                        } else {
                            SaveStatePanel.this.minTextField.setText(Integer.toString(0));
                            SaveStatePanel.this.maxTextField.setText(Integer.toString(0));
                        }
                    } else {
                        SaveStatePanel.this.minTextField.setText(Integer.toString(1));
                        SaveStatePanel.this.maxTextField.setText(Integer.toString(1));
                    }
                }
            }
        });
    }

    public void save_actionPerformed(ActionEvent e) {
        TransactionLogName tln = new TransactionLogName("TID=SD_SaveState");
        final JComponent comp = this.getSelectedPort();
        if (comp == null) {
            this.logger.log(Level.SEVERE, "{0} No selected Port found !!", tln);
            return;
        }
        int start = 0;
        int end = 0;
        String gspsDesc = null;
        if (comp instanceof XpCompositePort) {
            XpCompositePort compPort = (XpCompositePort)comp;
            int numFrames = compPort.getMaxFrame();
            int i = 1;
            int maxImage = numFrames;
            try {
                gspsDesc = this.descTextField.getText().trim();
                if (gspsDesc.length() == 0) {
                    gspsDesc = "JAMI_GSPS";
                }
            }
            catch (NullPointerException ex) {
                gspsDesc = "JAMI_GSPS";
            }
            this.all = true;
            if (this.rangeImgRadioButton.isSelected()) {
                int finalInit;
                this.all = false;
                try {
                    i = Integer.parseInt(this.minTextField.getText());
                }
                catch (NumberFormatException ex1) {
                    i = 1;
                }
                catch (NullPointerException ex) {
                    i = 1;
                }
                if (i > numFrames) {
                    i = numFrames;
                }
                if (i < 1) {
                    i = 1;
                }
                try {
                    maxImage = Integer.parseInt(this.maxTextField.getText());
                }
                catch (NumberFormatException ex2) {
                    maxImage = numFrames;
                }
                catch (NullPointerException exx) {
                    maxImage = numFrames;
                }
                if (maxImage > numFrames) {
                    maxImage = numFrames;
                }
                if (maxImage < 1) {
                    maxImage = 1;
                }
                final int finalMax = maxImage;
                start = finalInit = i;
                end = finalMax;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SaveStatePanel.this.maxTextField.setText(Integer.toString(finalMax));
                        SaveStatePanel.this.minTextField.setText(Integer.toString(finalInit));
                    }
                });
            }
            --i;
        } else {
            this.logger.log(Level.WARNING, "{0} Save State not supported by this component", tln);
            return;
        }
        final int fstart = start;
        final int fend = end;
        final String fgspsDesc = gspsDesc;
        Thread save = new Thread(){

            @Override
            public void run() {
                boolean status = SaveStatePanel.this.saveGSPS((XpViewport)comp, fstart, fend, fgspsDesc);
                if (status) {
                    // empty if block
                }
            }
        };
        save.start();
    }

    private boolean saveGSPS(XpViewport comp, int from, int to, String description) {
        TransactionLogName tln = new TransactionLogName("TID=SD_SaveState");
        this.logger.log(Level.INFO, "{0} begin", tln);
        DMSession sess = (DMSession)this.screen_.getClientProperty(LOCAL_DB);
        if (sess == null) {
            this.logger.log(Level.SEVERE, "{0} SEV5 DMSession is null", tln);
            return false;
        }
        if (comp instanceof XpCompositePort && sess != null) {
            System.err.println("...... Save State START...... XpCompositePort");
            try {
                XpMedicalImage[] imgs = comp.getImages();
                if (imgs == null || imgs.length == 0) {
                    this.logger.log(Level.SEVERE, "{0} SEV5 No Images !!", tln);
                    return false;
                }
                DMImage img = ((XpMedicalDmImage)comp.getImages()[0]).getDMImage();
                if (img == null) {
                    this.logger.log(Level.SEVERE, "{0} SEV5 No Images", tln);
                    return false;
                }
                String examid = (String)img.getValue(new DMTag(32, 16));
                String examuid = (String)img.getValue(new DMTag(32, 13));
                DMObject[] dmo = sess.getRelated("study", new DMQuery("(0x0020, 0x000D) = " + examuid + " AND (0x0020, 0x0010) = " + examid));
                if (dmo == null || dmo.length == 0) {
                    this.logger.log(Level.SEVERE, "{0} SEV5 No related Study Object found", tln);
                    return false;
                }
                String refSeriesNo = (String)img.getValue(new DMTag(32, 17));
                int gspsSeriesNo = Integer.parseInt(refSeriesNo) + 10000;
                String gspsSeNo = Integer.toString(gspsSeriesNo);
                String SeriesUID = null;
                DMObject[] series = dmo[0].getRelated("series");
                for (int i = 0; i < series.length; ++i) {
                    String seriesNo = (String)series[i].getValue(32, 17);
                    if (seriesNo == null || !seriesNo.equals(gspsSeNo)) continue;
                    SeriesUID = (String)series[i].getValue(32, 14);
                    break;
                }
                XpDicomElement[] overrides = null;
                XpDicomElement descTag = new XpDicomElement(112, 128, description);
                XpDicomElement serNoTag = new XpDicomElement(32, 17, gspsSeNo);
                if (SeriesUID != null) {
                    XpDicomElement seUIDTag = new XpDicomElement(32, 14, SeriesUID);
                    overrides = new XpDicomElement[]{descTag, serNoTag, seUIDTag};
                } else {
                    overrides = new XpDicomElement[]{descTag, serNoTag};
                }
                InputStream in = null;
                try {
                    if (!this.all) {
                        Method m = comp.getClass().getDeclaredMethod("getGSPS", Integer.TYPE, Integer.TYPE, XpDicomElement[].class);
                        m.setAccessible(true);
                        Object[] args = new Object[]{new Integer(from), new Integer(to), overrides};
                        in = (InputStream)m.invoke((Object)comp, args);
                    } else {
                        in = ((XpCompositePort)comp).getGSPS();
                    }
                }
                catch (SecurityException e) {
                    this.logger.log(Level.WARNING, "{0} SEV5 GSPS Save for image range not supported", tln);
                    in = ((XpCompositePort)comp).getGSPS();
                }
                catch (NoSuchMethodException e) {
                    this.logger.log(Level.WARNING, "{0} SEV5 GSPS Save for image range not supported", tln);
                    in = ((XpCompositePort)comp).getGSPS();
                }
                catch (IllegalArgumentException e) {
                    this.logger.log(Level.WARNING, "{0} SEV5 GSPS Save for image range not supported", tln);
                    in = ((XpCompositePort)comp).getGSPS();
                }
                catch (IllegalAccessException e) {
                    this.logger.log(Level.WARNING, "{0} SEV5 GSPS Save for image range not supported", tln);
                    in = ((XpCompositePort)comp).getGSPS();
                }
                catch (InvocationTargetException e) {
                    this.logger.log(Level.WARNING, "{0} SEV5 GSPS Save for image range not supported", tln);
                    in = ((XpCompositePort)comp).getGSPS();
                }
                sess.install(SaveStatePanel.getGSPS_IOSStream(dmo[0], in, overrides));
                System.err.println("...... Save State ...... DONE");
            }
            catch (IOException ex) {
                this.logger.log(Level.SEVERE, "{0} SEV8 " + ex.getMessage(), tln);
                return false;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return false;
        this.logger.log(Level.INFO, "{0} end", tln);
        return true;
    }

    public static InputStream getGSPS_IOSStream(DMObject study, InputStream is, XpDicomElement[] overrides) {
        System.err.println("in gsps_IOSStream");
        DicomObject obj = new DicomObject();
        try {
            obj.read(is);
            Object examID = study.getValue(32, 16);
            if (examID != null) {
                obj.set_ge(32, 16, examID);
            }
            if (overrides != null) {
                for (int i = 0; i < overrides.length; ++i) {
                    obj.set_ge(overrides[i].group, overrides[i].element, overrides[i].value);
                }
            }
        }
        catch (Exception ex) {
            return is;
        }
        return new WrapperStream(obj, null);
    }

    class SaveStateFocusListener
    implements FocusListener {
        private JTextField jtxField;

        public SaveStateFocusListener(JTextField jtxt) {
            this.jtxField = jtxt;
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                if (this.jtxField.getText().length() < 1) {
                    if (this.jtxField.getName().equals("maxField")) {
                        this.jtxField.setText("" + SaveStatePanel.this.numFrames);
                    }
                    if (this.jtxField.getName().equals("minField")) {
                        if (SaveStatePanel.this.numFrames > 0) {
                            this.jtxField.setText("1");
                        } else {
                            this.jtxField.setText("0");
                        }
                    }
                }
                if (this.jtxField.getName().equals("maxField") && Integer.parseInt(this.jtxField.getText()) < Integer.parseInt(SaveStatePanel.this.minTextField.getText())) {
                    this.jtxField.setText("" + SaveStatePanel.this.numFrames);
                }
            }
        }
    }

    class DigitKeyListener
    implements KeyListener {
        private JTextField jtxField;

        public DigitKeyListener(JTextField jtxt) {
            this.jtxField = jtxt;
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            if (!Character.isDigit(c) && c != '\b') {
                e.consume();
            }
            JTextField txt = (JTextField)e.getSource();
            String selTxt = txt.getSelectedText();
            String text = txt.getText();
            int caretPos = txt.getCaretPosition();
            String value = selTxt != null ? text.substring(0, txt.getSelectionStart()) + text.substring(txt.getSelectionEnd(), text.length()) : text;
            caretPos = text.length() - txt.getSelectionEnd();
            String txtVal = caretPos >= value.length() ? c + value.substring(0, value.length()) : value.substring(0, value.length() - caretPos) + c + value.substring(value.length() - caretPos, value.length());
            int val = 0;
            try {
                val = Integer.parseInt(txtVal);
            }
            catch (Exception ex) {
                val = 0;
            }
            if (val > SaveStatePanel.this.numFrames || val <= 0) {
                e.consume();
            }
            if (this.jtxField.getName().equals("minField") && val > Integer.parseInt(SaveStatePanel.this.maxTextField.getText())) {
                e.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    class PlayListener
    implements ActionListener {
        PlayListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButton btn = (JRadioButton)e.getSource();
            if (btn.getName().equals("range")) {
                SaveStatePanel.this.max.setVisible(true);
                SaveStatePanel.this.maxTextField.setVisible(true);
                SaveStatePanel.this.minTextField.setVisible(true);
            } else if (btn.getName().equals("all")) {
                SaveStatePanel.this.max.setVisible(false);
                SaveStatePanel.this.maxTextField.setVisible(false);
                SaveStatePanel.this.minTextField.setVisible(false);
            }
        }
    }
}

