/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.cuiPanels;

import com.ge.med.idc.PanZoomCapable;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.autoControls.XPwZoomSlider;
import com.ge.med.terra.xpv.autoControls.XPwZoomText;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.CuiPanelResources;
import com.ge.med.terra.xpv.cuiPanels.CuiPanelUtils;
import com.ge.med.terra.xpv.ui.SubTitlePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ZoomPanel
extends XPcaAutoControlPanel
implements ActionListener {
    private DecimalFormat df = new DecimalFormat("###0.0");
    static ResourceBundle res = CuiPanelResources.STRING_RESOURCES;
    boolean valueChanged = false;
    SubTitlePanel subTitlePanel = new SubTitlePanel();
    JPanel zoomPanel = new JPanel();
    JPanel sliderPanel = new JPanel();
    JLabel zoomLabel = new JLabel();
    XPwZoomText zoomF = new XPwZoomText();
    XPwZoomSlider zoomCtr = new XPwZoomSlider(false);
    SliderListener slider_listener = new SliderListener();
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("zoom")) {
                ZoomPanel.this.updateZoomSetting();
            } else if (evt.getPropertyName().equals("data_changed")) {
                ZoomPanel.this.updateZoomSetting();
            } else if (evt.getPropertyName().equals("ComponentSelection")) {
                ZoomPanel.this.updateZoomSetting();
            } else if (evt.getPropertyName().equals("parent_port_changed")) {
                ZoomPanel.this.updateZoomSetting();
            }
        }
    };

    public ZoomPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setBackground(null);
    }

    private void jbInit() throws Exception {
        this.setIcon(CuiPanelUtils.getIcon("ZOOM_PAN_ICO"));
        this.setLayout(new BorderLayout());
        this.subTitlePanel.setLayout(new BorderLayout());
        this.zoomLabel.setText(res.getString("PanZoomPanel.ZOOM_TEXT"));
        this.zoomF.setPreferredSize(new Dimension(50, 20));
        this.zoomF.setText("1");
        this.zoomF.setHorizontalAlignment(4);
        this.zoomF.addKeyListener(new WtKeyListener());
        this.zoomF.addFocusListener(new ZoomFocusListener());
        this.sliderPanel.setLayout(new BorderLayout());
        this.zoomPanel.setLayout(new FlowLayout(0));
        this.zoomCtr.setMaximum(800);
        this.zoomCtr.setMinimum(10);
        this.zoomCtr.removeChangeListener();
        this.zoomCtr.removePropertyChangeListener();
        this.zoomCtr.addChangeListener(this.slider_listener);
        this.zoomCtr.setValue(100);
        this.zoomCtr.setMajorTickSpacing(80);
        this.zoomCtr.setPaintTicks(true);
        this.zoomCtr.setMinorTickSpacing(0);
        this.zoomCtr.setInputMap(0, new InputMap());
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(10), new JLabel("0.1"));
        labelTable.put(new Integer(100), new JLabel("1.0"));
        labelTable.put(new Integer(200), new JLabel("2.0"));
        labelTable.put(new Integer(400), new JLabel("4.0"));
        labelTable.put(new Integer(600), new JLabel("6.0"));
        labelTable.put(new Integer(800), new JLabel("8.0"));
        this.zoomCtr.setLabelTable(labelTable);
        this.zoomCtr.setPaintLabels(true);
        this.sliderPanel.add((Component)this.zoomCtr, "Center");
        this.zoomPanel.add(this.zoomLabel);
        this.zoomPanel.add(this.zoomF);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(5, 5, 5, 5));
        content.add((Component)this.zoomPanel, "North");
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.sliderPanel, "North");
        content.add(p);
        this.subTitlePanel.add(content);
        this.add((Component)this.subTitlePanel, "Center");
        this.subTitlePanel.setTitle(res.getString("PanZoomPanel.ZOOM_TEXT"));
    }

    @Override
    public void setScreen(XPscreen screen) {
        if (screen == null) {
            return;
        }
        this.screen_ = screen;
        this.screen_.removePropertyChangeListener(this.viewPortListener);
        this.screen_.addPropertyChangeListener(this.viewPortListener);
        this.updateZoomSetting();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
    }

    private void updateZoomSetting() {
        int zoomVal;
        PanZoomCapable pz = this.getPZPort();
        if (pz != null && (zoomVal = (int)(pz.getZoom() * 100.0)) != this.zoomCtr.getValue()) {
            this.zoomCtr.removeChangeListener(this.slider_listener);
            this.zoomCtr.setValue(zoomVal);
            this.zoomF.setText("" + this.df.format(pz.getZoom()));
            this.zoomCtr.addChangeListener(this.slider_listener);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(new CuiLookAndFeel());
                }
                catch (UnsupportedLookAndFeelException e) {
                    e.printStackTrace();
                }
                JFrame f = new JFrame();
                f.setContentPane(new ZoomPanel());
                f.setSize(224, 512);
                f.setDefaultCloseOperation(3);
                f.setVisible(true);
            }
        });
    }

    class ZoomFocusListener
    implements FocusListener {
        ZoomFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            JTextField txt = (JTextField)e.getSource();
            txt.setText("" + (double)ZoomPanel.this.zoomCtr.getValue() / 100.0);
        }
    }

    class WtKeyListener
    implements KeyListener {
        WtKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            if (c == '\n') {
                JTextField txt = (JTextField)e.getSource();
                String selTxt = txt.getText();
                try {
                    double value = Double.parseDouble(selTxt);
                    if (value > 8.0 || value < 0.1) {
                        txt.setText("" + (double)ZoomPanel.this.zoomCtr.getValue() / 100.0);
                    } else {
                        ZoomPanel.this.zoomCtr.setValue((int)(value * 100.0));
                    }
                }
                catch (NumberFormatException nfe) {
                    txt.setText("" + (double)ZoomPanel.this.zoomCtr.getValue() / 100.0);
                }
            }
            if (!Character.isDigit(c) && c != '.' && c != '\b' && c != '\u007f') {
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int val = ZoomPanel.this.zoomCtr.getValue();
            double zoom = (double)val / 100.0;
            zoom = Double.parseDouble(ZoomPanel.this.df.format(zoom));
            if (!ZoomPanel.this.valueChanged) {
                ZoomPanel.this.zoomF.setText("" + zoom);
            }
            ZoomPanel.this.valueChanged = false;
            PanZoomCapable pzPort = (PanZoomCapable)ZoomPanel.this.getCapable("com.ge.med.idc.PanZoomCapable");
            if (pzPort == null) {
                return;
            }
            pzPort.setZoom(zoom);
            pzPort.repaint();
        }
    }
}

