/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.jfc;

import com.ge.med.terra.jami.XpComponentSave;
import com.ge.med.terra.xpv.jfc.FTPConnection;
import com.ge.med.terra.xpv.jfc.FilmPage;
import com.ge.med.terra.xpv.jfc.JavaFilmComposer;
import com.ge.med.terra.xpv.jfc.JavaFilmPage;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class JFCExport {
    Vector navImages = new Vector();
    File directory = null;
    String pName = null;
    String hName = null;
    File indexHtml = null;
    String imageFileType = null;
    JavaFilmComposer filmComposer;
    XpComponentSave sv = new XpComponentSave();
    int current = 0;

    public JFCExport() {
    }

    public JFCExport(JavaFilmComposer fc, String patientName, String hospitalName, String fileType) {
        try {
            this.directory = File.createTempFile("filmExport", "");
            this.directory.delete();
            this.directory.mkdir();
            System.err.println("making directory===" + this.directory.getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pName = patientName == null ? "NoName" : patientName;
        this.hName = hospitalName == null ? "NoName" : hospitalName;
        this.imageFileType = fileType;
        this.filmComposer = fc;
    }

    private void createFilesToExport() {
        int numPages = this.filmComposer.pageList.size();
        Iterator it = this.filmComposer.pageList.iterator();
        int navCount = 1;
        int imageCount = 0;
        while (it.hasNext()) {
            FilmPage fp = (FilmPage)it.next();
            JavaFilmPage cPage = this.filmComposer.getJavaFilmPage(fp);
            BufferedImage image = this.sv.renderOffscreen(cPage, 256, 256, 0);
            this.navImages.add(image);
            XPutil.imageSave(image, this.imageFileType, this.directory.getAbsolutePath() + File.separator + "page" + Integer.toString(this.navImages.size()) + "." + this.imageFileType);
            Vector vec = cPage.getImages();
            int numRow = cPage.row;
            int numCol = cPage.col;
            int[][] imgNames = new int[numRow][numCol];
            int numImages = 0;
            for (int i = 0; i < vec.size(); ++i) {
                JavaFilmPage singlePage = new JavaFilmPage(this.filmComposer, 1, 1);
                BufferedImage img = (BufferedImage)vec.get(i);
                if (img != null) {
                    singlePage.addImage(img, null, 0, 0);
                }
                BufferedImage singleImage = this.sv.renderOffscreen(singlePage, 1024, 1024, 0);
                BufferedImage singleImage1 = this.sv.renderOffscreen(singlePage, 256, 256, 0);
                XPutil.imageSave(singleImage1, this.imageFileType, this.directory.getAbsolutePath() + File.separator + "se" + Integer.toString(imageCount) + "." + this.imageFileType);
                XPutil.imageSave(singleImage, this.imageFileType, this.directory.getAbsolutePath() + File.separator + "ln" + Integer.toString(imageCount) + "." + this.imageFileType);
                int col = numImages % numRow;
                int row = numImages / numCol;
                System.err.println("row==" + row + "col==" + col + "i==" + i);
                imgNames[row][col] = imageCount++;
                ++numImages;
            }
            if (navCount < numPages) {
                this.writePage(navCount, imgNames, false);
            } else {
                this.writePage(navCount, imgNames, true);
            }
            ++navCount;
        }
        this.writeHeaderHtml();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String print(String host, String uname, String password, String dir, String folderName) {
        try {
            int count;
            FTPConnection ftp = new FTPConnection(true);
            System.out.println("Trying to connect to " + host);
            ftp.connect(host);
            if (!ftp.login(uname, password)) {
                System.out.println("Sorry. Could not connect.");
                return "Login Failed";
            }
            this.createFilesToExport();
            this.current = 50;
            File[] moveFiles = this.directory.listFiles();
            int inc = 50 / moveFiles.length;
            System.out.println("Successfully logged in!");
            System.out.println("System type is: " + ftp.getSystemType());
            System.out.println("Current dir is: " + ftp.getCurrentDirectory());
            String files = ftp.listFiles();
            String subDirs = ftp.listSubdirectories();
            if (!ftp.changeDirectory(dir)) {
                System.err.println("changing to " + dir + " failed");
                return dir + "not exist";
            }
            System.err.println("changing to " + dir + " successful");
            for (count = 0; !ftp.makeDirectory(folderName) && count < 10; ++count) {
                folderName = folderName + "0";
            }
            if (count < 10) {
                System.err.println("making folder ===" + folderName + " is successful");
            } else {
                System.err.println("making folder ===" + folderName + " failed");
            }
            if (!ftp.changeDirectory(folderName)) {
                System.err.println("changing to " + folderName + " failed");
                return "mkdir failed: folderName==" + folderName;
            }
            System.err.println("changing to " + folderName + " was successful");
            for (int i = 0; i < moveFiles.length; this.current += inc, ++i) {
                ftp.uploadFile(moveFiles[i].getName(), moveFiles[i].getAbsolutePath());
            }
            ftp.logout();
            ftp.disconnect();
            System.out.println("Disconnected and Logged Out.");
        }
        catch (IOException ex) {
            return "Unknown Host";
        }
        this.deleteTempFiles();
        return "O.K";
    }

    public int getCurrent() {
        return this.current;
    }

    private void deleteTempFiles() {
        File[] fileToBeDeleted = this.directory.listFiles();
        for (int i = 0; i < fileToBeDeleted.length; ++i) {
            fileToBeDeleted[i].delete();
        }
        this.directory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeaderHtml() {
        try (PrintStream pw = null;){
            File file = new File(this.directory.getAbsolutePath(), "index.htm");
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            System.err.println("in writeHeaderHtml..." + this.directory + File.separator + "index.htm");
            pw = new PrintStream(new FileOutputStream(file));
            pw.println("<HTML ><TITLE >" + this.pName + "</TITLE><BODY BGCOLOR=#2F3D6E ><H1 ><FONT COLOR=#FFFFFF><CENTER >" + this.pName + "</FONT></CENTER></H1><HR ></HR><FONT COLOR=#FFFFFF> <STRONG>Please be aware that the images contained in this electronic film may have lost information due to a lossy compression, and are not for diagnostic use. <BR> <BR></STRONG> </FONT>");
            pw.println();
            pw.println();
            pw.println("<TABLE>");
            pw.println("<TR><TD ><FONT COLOR=#FFFFFF>Hospital:</FONT></TD><TD><FONT COLOR=#FFFFFF>" + this.hName + "</FONT></TD></TR>");
            SimpleDateFormat df = new SimpleDateFormat("MMM-dd,yyyy-KK:mm:ss ");
            String currentDateTime = df.format(new Date());
            pw.println("<TR><TD ><FONT COLOR=#FFFFFF>Created on:</FONT></TD><TD ><FONT COLOR=#FFFFFF>" + currentDateTime + "</FONT></TD></TR>");
            int numJpeg = this.imageFileType.equals("png") ? 0 : this.navImages.size();
            int numPng = numJpeg == 0 ? this.navImages.size() : 0;
            int numPages = numJpeg == 0 ? numPng : numJpeg;
            pw.println("<TR><TD ><FONT COLOR=#FFFFFF>Pages:</FONT></TD><TD ><FONT COLOR=#FFFFFF>" + numPages + "</TD></TR>");
            pw.println("<TR><TD ><FONT COLOR=#FFFFFF>JPEG Images:</FONT></TD><TD ><FONT COLOR=#FFFFFF>" + numJpeg + "</FONT></TD></TR>");
            pw.println("<TR><TD ><FONT COLOR=#FFFFFF>PNG Images:</FONT></TD><TD ><FONT COLOR=#FFFFFF>" + numPng + "</FONT></TD></TR>");
            pw.println("</TABLE >");
            pw.println();
            pw.println();
            pw.println("<HR ></HR><TABLE BORDER=1 >");
            pw.println("<TR>");
            for (int i = 1; i <= this.navImages.size(); ++i) {
                pw.println("<TD ALIGN=CENTER HEIGHT=285 VALIGN=CENTER WIDTH=270 >");
                pw.println("<TABLE>");
                pw.println("<TR><TD ALIGN=CENTER ><A HREF=pg" + Integer.toString(i) + ".htm ><FONT COLOR=#FFFFFF>Page " + Integer.toString(i) + "</FONT></A></TD></TR>");
                pw.println("<TR><TD ALIGN=CENTER ><A HREF=pg" + Integer.toString(i) + ".htm >><IMG SRC=\"page" + Integer.toString(i) + "." + this.imageFileType + "\"></A></TD></TR>");
                pw.println("</TABLE>");
                pw.println("</TD>");
                if (i % 4 != 0) continue;
                pw.println("</TR>");
                pw.println("<TR>");
            }
            pw.println("</TR>");
            pw.println("</TABLE></BODY></HTML>");
            this.copyIcons("prev.PNG");
            this.copyIcons("next.PNG");
            this.copyIcons("index.PNG");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyIcons(String iconName) {
        System.err.println("coying icon===" + iconName);
        InputStream is = null;
        FileOutputStream fo = null;
        try {
            int ret;
            File file = new File(this.directory.getAbsolutePath(), iconName);
            if (file.exists()) {
                file.delete();
            }
            System.err.println("file.path===" + file.getAbsolutePath());
            file.createNewFile();
            is = this.getClass().getResourceAsStream("icons/" + iconName);
            fo = new FileOutputStream(file);
            byte[] buff = new byte[32768];
            while ((ret = is.read(buff)) >= 0) {
                fo.write(buff, 0, ret);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void writePage(int pageNum, int[][] images, boolean lastPage) {
        System.err.println("pageNum==" + pageNum + "lastPage===" + lastPage);
        try {
            System.err.println("in writePage..." + this.directory.getAbsolutePath() + File.separator + "pg" + Integer.toString(pageNum) + ".htm");
            File file = new File(this.directory.getAbsolutePath(), "pg" + Integer.toString(pageNum) + ".htm");
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            PrintStream pw = new PrintStream(new FileOutputStream(file));
            pw.println("<HTML >");
            pw.println("<TITLE >Page " + Integer.toString(pageNum) + "</TITLE>");
            pw.println("<BODY BGCOLOR=#2F3D6E>");
            pw.println("<H1 ><CENTER ><FONT COLOR=#FFFFFF>Page " + Integer.toString(pageNum) + "</FONT></CENTER></H1>");
            pw.println("<H4 >");
            pw.println("<TABLE WIDTH=\"100%\" >");
            pw.println("<TR>");
            if (pageNum == 1) {
                pw.println("<TD ALIGN=RIGHT WIDTH=\"45%\" ></TD>");
            } else {
                pw.println("<TD ALIGN=RIGHT WIDTH=\"45%\" ><A HREF=pg" + Integer.toString(pageNum - 1) + ".htm ><IMG BORDER=\"0\" SRC=\"prev.PNG\"></A></TD>");
            }
            pw.println("<TD ALIGN=CENTER WIDTH=\"10%\" ><A HREF=index.htm ><IMG BORDER=\"0\" SRC=\"index.PNG\"></A></TD>");
            if (lastPage) {
                pw.println("<TD ALIGN=LEFT WIDTH=\"45%\" ></TD>");
            } else {
                pw.println("<TD ALIGN=LEFT WIDTH=\"45%\" ><A HREF=pg" + Integer.toString(pageNum + 1) + ".htm ><IMG BORDER=\"0\" SRC=\"next.PNG\"></A></TD>");
            }
            pw.println("<TR>");
            pw.println("</TABLE>");
            pw.println("</H4>");
            pw.println();
            pw.println("<DIV STYLE=\"position:absolute; left:0px; top:200px\" >");
            pw.println("<TABLE BGCOLOR=\"#000000\" BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\" >");
            pw.println("<TR><TD ALIGN=CENTER HEIGHT=1024 VALIGN=CENTER WIDTH=1024 ><IMG src=\"shim.gif\" width=\"1024\" height=\"1024\" border=\"0\"></TD></TR>");
            pw.println("</TABLE>");
            pw.println("</DIV>");
            pw.println();
            pw.println("<DIV STYLE=\"position:absolute; left:0px; top:200px\" >");
            pw.println("<TABLE BGCOLOR=\"#000000\" BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\" >");
            for (int i = 0; i < images.length; ++i) {
                pw.println("<TR>");
                for (int j = 0; j < images[i].length; ++j) {
                    pw.println("<TD ALIGN=CENTER HEIGHT=512 VALIGN=CENTER WIDTH=512 ><A HREF=Se" + Integer.toString(images[i][j]) + "." + this.imageFileType + " ><IMG SRC=\"ln" + Integer.toString(images[i][j]) + "." + this.imageFileType + " \" BORDER=\"0\"></A></TD>");
                }
                pw.println("</TR>");
            }
            pw.println("</TABLE>");
            pw.println("</DIV>");
            pw.println("</BODY>");
            pw.println("</HTML>");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JFCExport ex = new JFCExport();
    }
}

