/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.jfc;

import com.ge.med.terra.xpv.jfc.FilmPage;
import com.ge.med.terra.xpv.jfc.JavaFilmComposer;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class JFCPrintGDI
implements Pageable {
    JavaFilmComposer filmComposer = null;
    int numOfPages = 0;

    public JFCPrintGDI(JavaFilmComposer filmComposer) {
        this.filmComposer = filmComposer;
        this.numOfPages = filmComposer.pageList.size();
    }

    public void print() {
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPageable(this);
        if (printerJob.printDialog()) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException exception) {
                        System.err.println("Printing error: " + exception);
                    }
                }
            });
            t.start();
        }
    }

    @Override
    public int getNumberOfPages() {
        return this.numOfPages;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < this.numOfPages) {
            return new PageFormat();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < this.numOfPages) {
            return this.filmComposer.getJavaFilmPage((FilmPage)this.filmComposer.pageList.get(pageIndex));
        }
        throw new IndexOutOfBoundsException();
    }
}

