/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.mouseController;

import com.ge.med.terra.jami.XpMouseController;
import com.ge.med.terra.xpv.mouseController.LeftMouseButtonController;
import com.ge.med.terra.xpv.mouseController.LeftMouseButtonModeCapable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class ConfigurableMouseController
extends LeftMouseButtonController {
    JPopupMenu popup_ = new JPopupMenu();
    List actionsList = new ArrayList();

    public ConfigurableMouseController() {
        this.impl_.addMouseController(new MenuController(), 4096);
    }

    @Override
    public void installController(XpMouseController controller, int mode) {
        super.installController(controller, mode);
        this.refreshMenu();
    }

    private void refreshMenu() {
        this.popup_.removeAll();
        int[] modes = this.getSupportedModes();
        ButtonGroup bg = new ButtonGroup();
        int selected = this.getLeftMouseButtonMode();
        for (int i = 0; i < modes.length; ++i) {
            String name = (String)ConfigurableMouseController.getMouseModeProperty(modes[i], "name_property");
            Icon ico = (Icon)this.getModeProperty(modes[i], "icon_property");
            if (name == null) {
                name = "Unknown mode";
            }
            final JRadioButtonMenuItem btn = new JRadioButtonMenuItem(name, ico);
            if (selected == modes[i]) {
                btn.setSelected(true);
            }
            this.popup_.add(btn);
            bg.add(btn);
            final int modesi = modes[i];
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigurableMouseController.this.setLeftMouseButtonMode(modesi);
                }
            });
            this.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (((LeftMouseButtonModeCapable)e.getSource()).getLeftMouseButtonMode() == modesi) {
                        btn.setSelected(true);
                    }
                }
            });
        }
        ListIterator iter = this.actionsList.listIterator();
        while (iter.hasNext()) {
            this.popup_.addSeparator();
            List element = (List)iter.next();
            for (Action action : element) {
                this.popup_.add(action);
            }
        }
    }

    public void addActionGroup(List actions) {
        this.actionsList.add(actions);
        this.refreshMenu();
    }

    public void addActionRadioGroup(List actions, int defaultIndex) {
    }

    public void addActionCheckGroup(List actions, List defaults) {
    }

    protected class MenuController
    extends MouseInputAdapter
    implements XpMouseController {
        protected MenuController() {
        }

        @Override
        public void setTarget(JComponent jc) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showMenu(e);
        }

        private void showMenu(MouseEvent e) {
            if (!ConfigurableMouseController.this.popup_.isShowing()) {
                ConfigurableMouseController.this.popup_.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showMenu(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.showMenu(e);
        }
    }
}

