/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.mouseController;

import com.ge.med.idc.CineCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.xpv.mouseController.Xp2DViewerMouseController;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class PagingMouseController
extends Xp2DViewerMouseController {
    private FramePositioningCapable vp;
    private Point startPoint = null;
    private Point prevPoint = null;
    private boolean mPressed = false;
    private double dyPrev = 0.0;

    @Override
    public void setTarget(JComponent comp) {
        while (!(comp instanceof FramePositioningCapable)) {
            if (comp == null) {
                return;
            }
            comp = (JComponent)comp.getParent();
        }
        this.vp = (FramePositioningCapable)((Object)comp);
    }

    private void page(double dy) {
        int size = this.vp.getNumFrames();
        if (dy - this.dyPrev < 0.0) {
            this.vp.setFrameIndex((this.vp.getFrameIndex() - 1 + size) % size);
        } else {
            this.vp.setFrameIndex((this.vp.getFrameIndex() + 1) % size);
        }
        this.dyPrev = dy;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.mPressed = true;
        this.prevPoint = this.startPoint = me.getPoint();
        this.dyPrev = 0.0;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (!this.mPressed || this.startPoint == null || this.vp == null) {
            return;
        }
        if (this.vp instanceof CineCapable && ((CineCapable)((Object)this.vp)).getCine()) {
            return;
        }
        Point p = me.getPoint();
        double dy = p.getY() - this.startPoint.getY();
        this.page(dy);
        this.prevPoint = p;
    }
}

