/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.mouseController;

import com.ge.med.terra.jami.XpMouseController;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class RetargetableMouseController
extends MouseInputAdapter
implements XpMouseController,
MouseWheelListener {
    static Logger logger = Logger.getLogger("com.ge.med.terra.xpv");
    protected Map controllerMap_ = new HashMap();
    private JComponent target_;
    private Map controllerReverseMap_ = new HashMap();
    private XpMouseController activeController_;

    public XpMouseController getMouseController(int binding) {
        return (XpMouseController)this.controllerMap_.get(new Integer(binding));
    }

    public static void main(String[] args) {
    }

    @Override
    public void setTarget(JComponent jc) {
        this.target_ = jc;
        for (XpMouseController controller : this.controllerMap_.values()) {
            controller.setTarget(jc);
        }
    }

    public void addMouseController(XpMouseController controller, int binding) {
        this.controllerMap_.put(new Integer(binding), controller);
        this.controllerReverseMap_.put(controller, new Integer(binding));
        if (this.target_ != null) {
            controller.setTarget(this.target_);
        }
    }

    public void removeMouseController(XpMouseController controller) {
        if (controller == null) {
            return;
        }
        this.controllerReverseMap_.remove(controller);
        Object o = this.controllerReverseMap_.get(controller);
        if (o != null) {
            this.controllerMap_.remove(o);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.activeController_ == null) {
            return;
        }
        this.activeController_.mouseClicked(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.activeController_ != null) {
            this.activeController_.mouseDragged(e);
        }
    }

    private void debugModifier(int modval) {
        String val = "";
        if ((modval & 0x400) != 0) {
            val = val + " | BUTTON1_DOWN";
        }
        if ((modval & 0x800) != 0) {
            val = val + " | BUTTON2_DOWN";
        }
        if ((modval & 0x1000) != 0) {
            val = val + " | BUTTON3_DOWN";
        }
        if ((modval & 0x10) != 0) {
            val = val + " | BUTTON1";
        }
        if ((modval & 8) != 0) {
            val = val + " | BUTTON2";
        }
        if ((modval & 4) != 0) {
            val = val + " | BUTTON3";
        }
        if (((long)modval & 0x10L) != 0L) {
            val = val + " | MOUSE_EVENT";
        }
        if ((modval & 4) != 0) {
            val = val + " | META";
        }
        if ((modval & 0x100) != 0) {
            val = val + " | META_DOWN";
        }
        System.err.println("modifier = [" + modval + "] " + val);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int modifier_ex = e.getModifiersEx() & 0xFFFFFEFF;
        this.activeController_ = (XpMouseController)this.controllerMap_.get(new Integer(modifier_ex));
        if (this.activeController_ == null) {
            System.err.println("mouse controller not found!");
            return;
        }
        this.activeController_.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.activeController_ == null) {
            return;
        }
        this.activeController_.mouseReleased(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }
}

