/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.mouseController;

import com.ge.med.idc.PanZoomCapable;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.xpv.mouseController.Xp2DViewerMouseController;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class ZoomMouseController
extends Xp2DViewerMouseController {
    private XpImageRenderAttributesOwner iraOwner = null;
    private PanZoomCapable vp = null;
    private Point startPoint = null;
    private Point prevPoint = null;
    private double startZoom = 1.0;
    public static double MAX_ZOOM = 8.0;
    public static double MIN_ZOOM = 0.1;
    private boolean mPressed = false;

    @Override
    public void setTarget(JComponent vc) {
        if (vc instanceof XpImageRenderAttributesOwner) {
            this.iraOwner = (XpImageRenderAttributesOwner)((Object)vc);
        }
        if (vc instanceof PanZoomCapable) {
            this.vp = (PanZoomCapable)((Object)vc);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.mPressed = true;
        this.prevPoint = this.startPoint = me.getPoint();
        XpImageRenderAttributes ira = this.iraOwner.getImageRenderAttributes();
        this.startZoom = ira.getZoom();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (!this.mPressed || this.startPoint == null || this.vp == null) {
            return;
        }
        Point p = me.getPoint();
        double dx = p.getX() - this.startPoint.getX();
        double dy = p.getY() - this.startPoint.getY();
        this.zoom(dx, dy);
        this.prevPoint = p;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mPressed = false;
        this.prevPoint = null;
    }

    private void zoom(double dx, double dy) {
        double zoom = this.startZoom - dy * zoomSensitivity;
        if (zoom < MIN_ZOOM) {
            zoom = MIN_ZOOM;
        }
        if (zoom > MAX_ZOOM) {
            zoom = MAX_ZOOM;
        }
        this.vp.setZoom(zoom);
        this.vp.repaint();
    }
}

