/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.print;

import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomElement;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PrintableXPVPort
implements Printable {
    private JComponent port = null;
    private final JFrame jf = new JFrame("Offscreen");
    private final JPanel jp = new JPanel();

    public PrintableXPVPort(JComponent port) {
        this.port = port;
    }

    @Override
    public int print(Graphics g, PageFormat format, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        this.port.setPreferredSize(new Dimension((int)format.getWidth(), (int)format.getHeight()));
        this.jf.setContentPane(this.port);
        this.jf.pack();
        Graphics2D g2d = (Graphics2D)g;
        this.port.paint(g2d);
        this.jf.setContentPane(this.jp);
        return 0;
    }

    public String toString() {
        if (this.port instanceof FramePositioningCapable) {
            int index = ((FramePositioningCapable)((Object)this.port)).getFrameIndex();
            String esi = "Ex: ";
            XpDicomElement exNum = new XpDicomElement(32, 16);
            XpDicomElement seNum = new XpDicomElement(32, 17);
            XpDicomElement imNum = new XpDicomElement(32, 19);
            ((XpCompositePort)this.port).getImages()[index].getValue(exNum);
            ((XpCompositePort)this.port).getImages()[index].getValue(seNum);
            ((XpCompositePort)this.port).getImages()[index].getValue(imNum);
            esi = exNum.value != null ? esi + (String)exNum.value : esi + "0";
            esi = seNum.value != null ? esi + "\tSe: " + (String)seNum.value : esi + "\tSe: 0";
            esi = imNum.value != null ? esi + "\tIm: " + (String)imNum.value : esi + "\tIm: 0";
            return esi;
        }
        return super.toString();
    }

    public Dimension getImageDimension() {
        if (this.port instanceof FramePositioningCapable) {
            int index = ((FramePositioningCapable)((Object)this.port)).getFrameIndex();
            RenderedImage ri = ((XpCompositePort)this.port).getImageAt(index).getPixelData();
            return new Dimension(ri.getWidth(), ri.getHeight());
        }
        return null;
    }
}

