/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.template;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.xpv.template.BasicTemplate;
import com.ge.med.terra.xpv.template.Template;
import com.ge.med.terra.xpv.template.TemplateFactory;
import com.ge.med.terra.xpv.util.XPutil;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.swing.Icon;

public class BasicTemplateFactory
implements TemplateFactory {
    Template[] xpTemplate;
    String[] templateNames;
    HashMap map;
    String[] names;

    @Override
    public void setProperties(Properties prop) {
        String templateDir = prop.getProperty("TemplateDir");
        File fd = new File(templateDir);
        if (!fd.exists()) {
            return;
        }
        File[] files = fd.listFiles();
        this.templateNames = new String[files.length];
        this.xpTemplate = new Template[files.length];
        for (int i = 0; i < files.length; ++i) {
            try {
                Properties tmpProp = new Properties(prop);
                tmpProp.load(new FileInputStream(files[i]));
                this.xpTemplate[i] = (Template)XPutil.getClassFor(tmpProp, "Template", Template.class);
                if (this.xpTemplate[i] == null) {
                    this.xpTemplate[i] = new BasicTemplate();
                }
                this.xpTemplate[i].setConfigProp(tmpProp);
                continue;
            }
            catch (Exception ex) {
                System.err.println("Could not load file" + files[i].getAbsolutePath());
                ex.printStackTrace();
            }
        }
    }

    @Override
    public String[] getNames(DMObject[] dmo) {
        this.map = new HashMap();
        boolean off = false;
        for (int i = 0; i < this.xpTemplate.length; ++i) {
            String[] tmp = this.xpTemplate[i].getScans(dmo);
            for (int k = 0; k < tmp.length; ++k) {
                this.map.put(tmp[k], this.xpTemplate[i]);
            }
        }
        Set s = this.map.keySet();
        this.names = s.toArray(new String[1]);
        return this.names;
    }

    @Override
    public Icon getTemplateIcons() {
        return null;
    }

    @Override
    public Template getTemplate(int n) {
        return this.xpTemplate[n];
    }
}

