/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.ui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class RowColButton
extends JPanel {
    private int row = 6;
    private int col = 6;
    JToggleButton[][] buttons;
    actListen callback = new actListen();
    private transient Vector actionListeners;
    GridLayout gridLayout1 = new GridLayout();
    private Dimension value = new Dimension(0, 0);

    public RowColButton() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateButtons() {
        this.removeAll();
        this.gridLayout1.setRows(this.row);
        this.gridLayout1.setColumns(this.col);
        this.buttons = new JToggleButton[this.row][this.col];
        for (int y = 0; y < this.row; ++y) {
            for (int x = 0; x < this.col; ++x) {
                JToggleButton t = new JToggleButton();
                t.putClientProperty("PTK_ICON_SHAPE", "NONE");
                t.putClientProperty("PTK_ICON_SIZE", new Dimension(12, 12));
                t.addActionListener(this.callback);
                this.buttons[y][x] = t;
                this.add(t);
            }
        }
    }

    public void updateButtons(ActionEvent e) {
        JToggleButton pressed = (JToggleButton)e.getSource();
        int maxx = 0;
        int maxy = 0;
        for (int y = 0; y < this.row; ++y) {
            for (int x = 0; x < this.col; ++x) {
                if (this.buttons[y][x] != pressed) continue;
                maxx = x;
                maxy = y;
            }
        }
        this.value.setSize(maxx, maxy);
        this.updateSelection();
        this.fireActionPerformed(e);
    }

    private void updateSelection() {
        int maxx = this.value.width;
        int maxy = this.value.height;
        for (int y = 0; y < this.row; ++y) {
            for (int x = 0; x < this.col; ++x) {
                this.buttons[y][x].setSelected(x <= maxx & y <= maxy);
            }
        }
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
        this.updateButtons();
    }

    public void setCol(int col) {
        this.col = col;
        this.updateButtons();
    }

    public int getCol() {
        return this.col;
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ActionListener)listeners.elementAt(i)).actionPerformed(e);
            }
        }
    }

    private void jbInit() throws Exception {
        this.gridLayout1.setHgap(-5);
        this.gridLayout1.setVgap(-5);
        this.setLayout(this.gridLayout1);
    }

    public void setValue(Dimension value) {
        this.value = value;
        this.updateSelection();
    }

    public Dimension getValue() {
        return this.value;
    }

    class actListen
    implements ActionListener {
        actListen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RowColButton.this.updateButtons(e);
        }
    }
}

