/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.ui;

import com.ge.med.ptk.PtkBorderFactory;
import com.ge.med.ptk.laf.CuiLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class TitlePanel
extends JPanel {
    private TitledBorder titledBorder1;
    private Color color;
    final int VERTICAL_INSETS = 2;
    boolean square;
    JLabel title = new JLabel("Your Message Here");
    Border bborder;
    BorderLayout borderLayout1 = new BorderLayout();

    public TitlePanel() {
        this(0, false);
    }

    public TitlePanel(int headerAlignment) {
        this(headerAlignment, false);
    }

    public TitlePanel(int headerAlignment, boolean square) {
        this.title.setHorizontalAlignment(headerAlignment);
        this.square = square;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setNoTitleBorder(boolean b) {
        this.setBorder(b ? new EmptyBorder(0, 0, 0, 0) : this.bborder);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.bborder = new Border(){
            JPanel pp = new JPanel(null);
            {
                double[] dArray;
                Insets insets = new Insets(2, 4, 2, 20);
                if (TitlePanel.this.square) {
                    double[] dArray2 = new double[4];
                    dArray2[0] = 0.0;
                    dArray2[1] = 0.0;
                    dArray2[2] = 0.0;
                    dArray = dArray2;
                    dArray2[3] = 0.0;
                } else {
                    double[] dArray3 = new double[4];
                    dArray3[0] = 4.0;
                    dArray3[1] = 0.0;
                    dArray3[2] = 0.0;
                    dArray = dArray3;
                    dArray3[3] = 4.0;
                }
                double[] corners = dArray;
                TitlePanel.this.title.setBorder(PtkBorderFactory.createRoundedCornerBorder(insets, corners));
                TitlePanel.this.title.setForeground(UIManager.getColor("P7"));
                TitlePanel.this.title.setBackground(UIManager.getColor("P10"));
                TitlePanel.this.title.setOpaque(true);
                this.pp.add(TitlePanel.this.title);
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                this.pp.setBackground(c.getParent().getBackground());
                TitlePanel.this.title.setBounds(0, 0, width, 20);
                Font font = TitlePanel.this.title.getFont();
                FontMetrics fm = TitlePanel.this.title.getFontMetrics(font);
                int h = fm.getAscent() + fm.getDescent() + fm.getLeading();
                int sp = 20 - TitlePanel.this.title.getInsets().top - TitlePanel.this.title.getInsets().bottom;
                if (h > sp) {
                    Font newf = new Font(font.getName(), font.getStyle(), (int)((double)font.getSize() * (double)sp / (double)h));
                    TitlePanel.this.title.setFont(newf);
                    System.out.println("$$$$$$$$$$$$titlepanel: resizing font to " + newf.getSize());
                }
                TitlePanel.this.title.paint(g);
                g.setColor(UIManager.getColor("P10"));
                g.fillRect(0, 20, 1, height - 20);
                g.fillRect(width - 1, 20, 1, height - 20);
                g.fillRect(0, height - 1, width, 1);
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(20, 1, 1, 1);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }
        };
        if (UIManager.getLookAndFeel() instanceof CuiLookAndFeel) {
            this.setBorder(this.bborder);
        } else {
            this.titledBorder1 = new TitledBorder("Title");
            this.setBorder(this.titledBorder1);
        }
    }

    public String getTitle() {
        if (UIManager.getLookAndFeel() instanceof CuiLookAndFeel) {
            return this.title.getText();
        }
        return this.titledBorder1.getTitle();
    }

    public void setTitle(String title) {
        if (UIManager.getLookAndFeel() instanceof CuiLookAndFeel) {
            this.title.setText(title);
        } else {
            this.titledBorder1.setTitle(title);
        }
    }

    public void setTitleColor(Color titleColor) {
        this.titledBorder1.setTitleColor(titleColor);
    }

    public Color getTitleColor() {
        return this.titledBorder1.getTitleColor();
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel(new CuiLookAndFeel());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        TitlePanel.testFrame(argv);
    }

    public static JFrame testFrame(String[] args) {
        TitlePanel p = new TitlePanel();
        JFrame f = new JFrame("test");
        f.setContentPane(p);
        f.setBounds(100, 100, 200, 200);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
        return f;
    }
}

