/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.ui;

import com.ge.med.terra.xpv.ui.WindowLevelModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;

public class WindowLevelControl
extends JComponent {
    protected static final int WINDOW_MINIMUM = 0;
    protected static final int WINDOW_MAXIMUM = 1;
    protected double windowMin;
    protected double windowMax;
    protected double rangeMin;
    protected double rangeMax;
    protected WindowLevelModel model_ = null;
    protected Color[] colorMap_;
    protected List listeners_ = new ArrayList();
    ChangeListener modelListener_ = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            WindowLevelControl.this.fromModel();
            WindowLevelControl.this.fireStateChanged();
        }
    };
    protected JSlider[] slider_ = new JSlider[]{new JSlider(0, 100, 0), new JSlider(0, 100, 100)};
    protected int modelUpdate_ = 0;
    static int i = 0;

    public double getWindowMin() {
        return this.model_.getWindowMin();
    }

    public void setWindowMin(double wMin) {
        this.model_.setWindowMin(wMin);
    }

    public double getWindowMax() {
        return this.model_.getWindowMax();
    }

    public void setWindowMax(double wMax) {
        this.model_.setWindowMax(wMax);
    }

    public double getRangeMin() {
        return this.model_.getRangeMin();
    }

    public void setRangeMin(double wMin) {
        this.model_.setRangeMin(wMin);
    }

    public double getRangeMax() {
        return this.model_.getRangeMax();
    }

    public void setRangeMax(double wMax) {
        this.model_.setRangeMax(wMax);
    }

    public void setMinMaxAndRange(double wMin, double wMax, double rMin, double rMax) {
        this.model_.set(wMin, wMax, rMin, rMax);
    }

    public WindowLevelModel getModel() {
        return this.model_;
    }

    public void setModel(WindowLevelModel model) {
        if (this.model_ != null) {
            this.model_.removeChangeListener(this.modelListener_);
        }
        this.model_ = model;
        this.model_.addChangeListener(this.modelListener_);
    }

    public int getOrientation() {
        return this.slider_[0].getOrientation();
    }

    public void setOrientation(int orientation) {
        for (int i = 0; i < this.slider_.length; ++i) {
            this.slider_[i].setOrientation(orientation);
        }
    }

    public boolean getPaintLabels() {
        return this.slider_[0].getPaintLabels();
    }

    public void setPaintLabels(boolean paintLabels) {
        for (int i = 0; i < this.slider_.length; ++i) {
            this.slider_[i].setPaintLabels(paintLabels);
        }
    }

    public boolean getPaintTicks() {
        return this.slider_[0].getPaintTicks();
    }

    public void setPaintTicks(boolean paintTicks) {
        for (int i = 0; i < this.slider_.length; ++i) {
            this.slider_[i].setPaintTicks(paintTicks);
        }
    }

    public Color[] getColorMap() {
        return this.colorMap_;
    }

    public void setColorMap(Color[] colorMap) {
        this.colorMap_ = colorMap;
        this.slider_[0].setBackground(this.colorMap_[0]);
        this.slider_[1].setBackground(this.colorMap_[this.colorMap_.length - 1]);
    }

    public void setColorMap(int[] colorMap) {
        if (colorMap == null) {
            return;
        }
        Color[] cm = new Color[colorMap.length];
        for (int i = 0; i < colorMap.length; ++i) {
            cm[i] = new Color(colorMap[i]);
        }
        this.setColorMap(cm);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners_.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners_.remove(l);
    }

    protected void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        Iterator i = this.listeners_.iterator();
        while (i.hasNext()) {
            ((ChangeListener)i.next()).stateChanged(event);
        }
    }

    protected void toModel(int i) {
        if (this.modelUpdate_ > 0) {
            return;
        }
        switch (i) {
            case 0: {
                this.model_.setWindowMin(this.slider_[i].getValue());
                break;
            }
            case 1: {
                this.model_.setWindowMax(this.slider_[i].getValue());
            }
        }
    }

    protected void fromModel() {
        ++this.modelUpdate_;
        double rMin = this.model_.getRangeMin();
        double rMax = this.model_.getRangeMax();
        double wMin = this.model_.getWindowMin();
        double wMax = this.model_.getWindowMax();
        BoundedRangeModel minModel = this.slider_[0].getModel();
        minModel.setRangeProperties((int)wMin, minModel.getExtent(), (int)rMin, (int)rMax, minModel.getValueIsAdjusting());
        BoundedRangeModel maxModel = this.slider_[1].getModel();
        maxModel.setRangeProperties((int)wMax, maxModel.getExtent(), (int)rMin, (int)rMax, maxModel.getValueIsAdjusting());
        --this.modelUpdate_;
    }

    public WindowLevelControl() {
        this.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return WindowLevelControl.this.slider_[0].getMinimumSize();
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return WindowLevelControl.this.slider_[0].getPreferredSize();
            }

            @Override
            public void layoutContainer(Container parent) {
                Dimension size = parent.getSize();
                for (int i = 0; i < WindowLevelControl.this.slider_.length; ++i) {
                    WindowLevelControl.this.slider_[i].setSize(size);
                }
            }
        });
        this.setModel(new WindowLevelModel(0.0, 100.0, 0.0, 100.0));
        for (int i = 0; i < this.slider_.length; ++i) {
            this.slider_[i].setUI(new WLSliderUI(this.slider_[i], i));
            this.slider_[i].setSnapToTicks(true);
            this.slider_[i].setOpaque(false);
            this.slider_[i].setPaintTicks(false);
            this.slider_[i].setPaintLabels(false);
            final int iF = i;
            this.slider_[i].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    WindowLevelControl.this.toModel(iF);
                }
            });
            this.add(this.slider_[i]);
        }
        this.setColorMap(new Color[]{Color.black, Color.white});
        this.fromModel();
    }

    public static void main(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            if (!argv[i].equals("-version") && !argv[i].equals("-v")) continue;
            System.exit(0);
        }
        boolean ptkLaf = true;
        for (int i = 0; i < argv.length; ++i) {
            if (!argv[i].equals("-n") && !argv[i].equals("-noPtkLaf")) continue;
            ptkLaf = false;
        }
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        WindowLevelControl wlc = new WindowLevelControl();
        wlc.setOrientation(1);
        wlc.setColorMap(new Color[]{Color.red, Color.orange, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta});
        wlc.setForeground(Color.white);
        JButton next = new JButton("next");
        final WindowLevelControl fwlc = wlc;
        next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (i) {
                    case 0: {
                        fwlc.setRangeMax(150.0);
                        break;
                    }
                    case 1: {
                        fwlc.setRangeMin(20.0);
                    }
                }
                ++i;
            }
        });
        frame.getContentPane().add(wlc);
        frame.getContentPane().add((Component)next, "East");
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    protected class WLSliderUI
    extends BasicSliderUI {
        protected int k_;

        public WLSliderUI(JSlider s, int k) {
            super(s);
            this.k_ = k;
        }

        @Override
        public boolean contains(JComponent c, int x, int y) {
            return this.thumbRect.contains(x, y);
        }

        @Override
        protected void calculateTrackBuffer() {
            this.trackBuffer = this.slider.getOrientation() == 0 ? this.thumbRect.width / 2 : this.thumbRect.height / 2;
        }

        @Override
        protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
            final JSlider sliderF = slider;
            return new BasicSliderUI.TrackListener(){
                protected int pressedPosition_;
                protected int pressedValue_;
                protected double pressedScale_;

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    this.pressedPosition_ = sliderF.getOrientation() == 0 ? e.getX() : e.getY();
                    this.pressedValue_ = sliderF.getValue();
                    this.pressedScale_ = (double)(sliderF.getMaximum() - sliderF.getMinimum()) / (double)(sliderF.getOrientation() == 0 ? ((WLSliderUI)WLSliderUI.this).trackRect.width : -((WLSliderUI)WLSliderUI.this).trackRect.height);
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (!sliderF.isEnabled()) {
                        return;
                    }
                    this.currentMouseX = e.getX();
                    this.currentMouseY = e.getY();
                    if (this.offset == 0) {
                        return;
                    }
                    int currentPosition = sliderF.getOrientation() == 0 ? e.getX() : e.getY();
                    int currentValue = this.pressedValue_ + (int)Math.round((double)(currentPosition - this.pressedPosition_) * this.pressedScale_);
                    BoundedRangeModel model = sliderF.getModel();
                    model.setRangeProperties(currentValue, model.getExtent(), Math.min(model.getMinimum(), currentValue), Math.max(model.getMaximum(), currentValue), model.getValueIsAdjusting());
                    if (sliderF.getOrientation() == 0) {
                        int halfThumbWidth = ((WLSliderUI)WLSliderUI.this).thumbRect.width / 2;
                        int finalPosition = WLSliderUI.this.xPositionForValue(sliderF.getValue());
                        WLSliderUI.this.setThumbLocation(finalPosition - halfThumbWidth, ((WLSliderUI)WLSliderUI.this).thumbRect.y);
                        this.pressedPosition_ = WLSliderUI.this.xPositionForValue(this.pressedValue_);
                    } else {
                        int halfThumbHeight = ((WLSliderUI)WLSliderUI.this).thumbRect.height / 2;
                        int finalPosition = WLSliderUI.this.yPositionForValue(sliderF.getValue());
                        WLSliderUI.this.setThumbLocation(((WLSliderUI)WLSliderUI.this).thumbRect.x, finalPosition - halfThumbHeight);
                        this.pressedPosition_ = WLSliderUI.this.yPositionForValue(this.pressedValue_);
                    }
                }
            };
        }

        @Override
        public void paintTrack(Graphics g) {
            if (this.k_ != 1) {
                return;
            }
            Rectangle lowBounds = new Rectangle(this.trackRect);
            Rectangle rampBounds = new Rectangle(this.trackRect);
            Rectangle highBounds = new Rectangle(this.trackRect);
            if (this.slider.getOrientation() == 0) {
                rampBounds.x = this.xPositionForValue((int)WindowLevelControl.this.model_.getWindowMin());
                lowBounds.width = rampBounds.x - lowBounds.x;
                highBounds.x = this.xPositionForValue((int)WindowLevelControl.this.model_.getWindowMax());
                rampBounds.width = highBounds.x - rampBounds.x;
                highBounds.width -= lowBounds.width + rampBounds.width;
                g.setColor(WindowLevelControl.this.colorMap_[0]);
                g.fillRect(lowBounds.x, lowBounds.y, lowBounds.width, lowBounds.height);
                g.setColor(WindowLevelControl.this.colorMap_[WindowLevelControl.this.colorMap_.length - 1]);
                g.fillRect(highBounds.x, highBounds.y, highBounds.width, highBounds.height);
                if (WindowLevelControl.this.colorMap_.length < 3) {
                    ((Graphics2D)g).setPaint(new GradientPaint(rampBounds.x, 0.0f, WindowLevelControl.this.colorMap_[0], rampBounds.x + rampBounds.width, 0.0f, WindowLevelControl.this.colorMap_[WindowLevelControl.this.colorMap_.length - 1]));
                    g.fillRect(rampBounds.x, rampBounds.y, rampBounds.width, rampBounds.height);
                } else {
                    for (int i = 0; i < rampBounds.width - 1; ++i) {
                        g.setColor(WindowLevelControl.this.colorMap_[i * WindowLevelControl.this.colorMap_.length / rampBounds.width]);
                        g.fillRect(rampBounds.x + i, rampBounds.y, 1, rampBounds.height);
                    }
                }
            } else {
                rampBounds.y = this.yPositionForValue((int)WindowLevelControl.this.model_.getWindowMax());
                highBounds.height = rampBounds.y - highBounds.y;
                lowBounds.y = this.yPositionForValue((int)WindowLevelControl.this.model_.getWindowMin());
                rampBounds.height = lowBounds.y - rampBounds.y;
                lowBounds.height -= highBounds.height + rampBounds.height;
                g.setColor(WindowLevelControl.this.colorMap_[0]);
                g.fillRect(lowBounds.x, lowBounds.y, lowBounds.width, lowBounds.height);
                g.setColor(WindowLevelControl.this.colorMap_[WindowLevelControl.this.colorMap_.length - 1]);
                g.fillRect(highBounds.x, highBounds.y, highBounds.width, highBounds.height);
                if (WindowLevelControl.this.colorMap_.length < 3) {
                    ((Graphics2D)g).setPaint(new GradientPaint(0.0f, rampBounds.y, WindowLevelControl.this.colorMap_[WindowLevelControl.this.colorMap_.length - 1], 0.0f, rampBounds.y + rampBounds.height, WindowLevelControl.this.colorMap_[0]));
                    g.fillRect(rampBounds.x, rampBounds.y, rampBounds.width, rampBounds.height);
                } else {
                    for (int i = 0; i < rampBounds.height - 1; ++i) {
                        g.setColor(WindowLevelControl.this.colorMap_[i * WindowLevelControl.this.colorMap_.length / rampBounds.height]);
                        g.fillRect(rampBounds.x, rampBounds.y + rampBounds.height - i - 1, rampBounds.width, 1);
                    }
                }
                g.setColor(Color.red);
                g.drawString(String.valueOf(WindowLevelControl.this.model_.getWindowMax()), rampBounds.x, rampBounds.y + 20);
                g.drawString(String.valueOf(WindowLevelControl.this.model_.getWindowMin()), lowBounds.x, lowBounds.y - 15);
            }
        }

        @Override
        public void paintTicks(Graphics g) {
            if (this.k_ != 3) {
                return;
            }
            Rectangle tickBounds = this.tickRect;
            int w = tickBounds.width;
            int h = tickBounds.height;
            g.setColor(this.slider.getForeground());
            int maj = this.slider.getMajorTickSpacing();
            int min = this.slider.getMinorTickSpacing();
            if (this.slider.getOrientation() == 0) {
                int xPos;
                int value;
                g.translate(0, tickBounds.y);
                if (this.slider.getMinorTickSpacing() > 0) {
                    for (value = this.slider.getMaximum() / this.slider.getMinorTickSpacing() * this.slider.getMinorTickSpacing(); value >= this.slider.getMinimum(); value -= this.slider.getMinorTickSpacing()) {
                        xPos = this.xPositionForValue(value);
                        this.paintMinorTickForHorizSlider(g, tickBounds, xPos);
                    }
                }
                if (this.slider.getMajorTickSpacing() > 0) {
                    for (value = this.slider.getMaximum() / this.slider.getMajorTickSpacing() * this.slider.getMajorTickSpacing(); value >= this.slider.getMinimum(); value -= this.slider.getMajorTickSpacing()) {
                        xPos = this.xPositionForValue(value);
                        this.paintMajorTickForHorizSlider(g, tickBounds, xPos);
                    }
                }
                g.translate(0, -tickBounds.y);
            } else {
                int yPos;
                int value;
                g.translate(tickBounds.x, 0);
                if (this.slider.getMinorTickSpacing() > 0) {
                    for (value = this.slider.getMaximum() / this.slider.getMinorTickSpacing() * this.slider.getMinorTickSpacing(); value >= this.slider.getMinimum(); value -= this.slider.getMinorTickSpacing()) {
                        yPos = this.yPositionForValue(value);
                        this.paintMinorTickForVertSlider(g, tickBounds, yPos);
                    }
                }
                if (this.slider.getMajorTickSpacing() > 0) {
                    for (value = this.slider.getMaximum() / this.slider.getMajorTickSpacing() * this.slider.getMajorTickSpacing(); value >= this.slider.getMinimum(); value -= this.slider.getMajorTickSpacing()) {
                        yPos = this.yPositionForValue(value);
                        this.paintMajorTickForVertSlider(g, tickBounds, yPos);
                    }
                }
                g.translate(-tickBounds.x, 0);
            }
        }
    }
}

