/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.UIManager;

public class DTPicture
extends JComponent
implements MouseMotionListener,
MouseListener {
    private MouseEvent firstMouseEvent = null;
    private int portNo = -1;
    private boolean empty = false;
    JComponent sub = null;

    public DTPicture() {
        this.init();
    }

    public JComponent getComponent() {
        return this.sub;
    }

    public void setComponent(JComponent comp) {
        this.sub = comp;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public boolean getEmpty() {
        return this.empty;
    }

    public ImageIcon getImage() {
        if (this.sub == null) {
            return null;
        }
        ImageIcon img = (ImageIcon)this.sub.getClientProperty("ICON");
        if (img == null) {
            return null;
        }
        return img;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public DTPicture(JComponent sub) {
        this.sub = sub;
        this.init();
    }

    public void setPortNo(int n) {
        this.portNo = n;
    }

    public int getPortNo() {
        return this.portNo;
    }

    private void init() {
        this.setPreferredSize(new Dimension(125, 125));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        TransferHandler handler = c.getTransferHandler();
        handler.exportToClipboard(c, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
        this.firstMouseEvent = null;
    }

    public void setJComponet(JComponent sub) {
        this.sub = sub;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.firstMouseEvent = e;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.firstMouseEvent != null) {
            e.consume();
            int ctrlMask = 128;
            int action = (e.getModifiersEx() & ctrlMask) == ctrlMask ? 1 : 2;
            int dx = Math.abs(e.getX() - this.firstMouseEvent.getX());
            int dy = Math.abs(e.getY() - this.firstMouseEvent.getY());
            if (dx > 5 || dy > 5) {
                JComponent c = (JComponent)e.getSource();
                TransferHandler handler = c.getTransferHandler();
                handler.exportAsDrag(c, this.firstMouseEvent, action);
                this.firstMouseEvent = null;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.firstMouseEvent = null;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        ImageIcon img;
        Graphics2D g2d = (Graphics2D)graphics;
        if (this.empty) {
            g2d.setColor(Color.black);
        } else {
            g2d.setColor(UIManager.getColor("P9"));
        }
        Image image = null;
        if (this.sub != null && (img = (ImageIcon)this.sub.getClientProperty("ICON")) != null) {
            image = img.getImage();
        }
        if (image != null) {
            float sx = (float)this.getWidth() / (float)image.getWidth(this);
            float sy = (float)this.getHeight() / (float)image.getHeight(this);
            boolean isX = true;
            if (sx > sy) {
                sx = sy;
            } else {
                isX = false;
                sy = sx;
            }
            g2d.scale(sx, sy);
            g2d.fillRect(0, 0, (int)((float)this.getWidth() / sx), (int)((float)this.getHeight() / sy));
            if (isX) {
                float stx = (float)this.getWidth() / sx;
                g2d.drawImage(image, ((int)stx - image.getWidth(this)) / 2, 0, this);
            } else {
                float sty = (float)this.getHeight() / sy;
                g2d.drawImage(image, 0, ((int)sty - image.getHeight(this)) / 2, this);
            }
        } else {
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

