/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.util;

public class TagHashMap {
    private int[] hashkey;
    private Object[] hashmap;
    private int size = 0;

    public TagHashMap(int len) {
        this.hashmap = new Object[len * 3];
        this.hashkey = new int[len * 3];
        for (int i = 0; i < this.hashkey.length; ++i) {
            this.hashkey[i] = -1;
        }
    }

    public TagHashMap() {
        this(123);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(int group, int elem) {
        return this.containsKey(this.makeKey(group, elem));
    }

    public boolean containsKey(int key) {
        for (int i = key % this.hashkey.length; i < this.hashkey.length; ++i) {
            if (this.hashkey[i] == key) {
                return true;
            }
            if (this.hashkey[i] != -1) continue;
            return false;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        for (int i = 0; i < this.hashmap.length; ++i) {
            if (this.hashmap[i] != value) continue;
            return true;
        }
        return false;
    }

    public int makeKey(int group, int elem) {
        return group << 16 + elem;
    }

    public Object get(int group, int elem) {
        return this.get(this.makeKey(group, elem));
    }

    public Object get(int key) {
        int hcode = key % this.hashkey.length;
        if (this.hashkey[hcode] == key) {
            return this.hashmap[hcode];
        }
        for (int i = hcode + 1; i < this.hashkey.length; ++i) {
            if (this.hashkey[i] == key) {
                return this.hashmap[i];
            }
            if (this.hashkey[i] != -1) continue;
            return null;
        }
        return null;
    }

    public Object put(int group, int elem, Object value) {
        return this.put(this.makeKey(group, elem), value);
    }

    public Object put(int key, Object value) {
        int hcode;
        if (this.size > 2 * this.hashkey.length) {
            this.resize(this.hashkey.length * 2);
        }
        if (this.hashkey[hcode = key % this.hashkey.length] != -1) {
            this.hashkey[hcode] = key;
            this.hashmap[hcode] = value;
            ++this.size;
            return null;
        }
        for (int i = hcode; i < this.hashkey.length; ++i) {
            if (this.hashkey[i] == key) {
                this.hashkey[hcode] = key;
                Object oldValue = this.hashmap[hcode];
                this.hashmap[hcode] = value;
                ++this.size;
                return oldValue;
            }
            if (this.hashkey[i] != -1) continue;
            this.hashkey[hcode] = key;
            this.hashmap[hcode] = value;
            ++this.size;
            return null;
        }
        return null;
    }

    private int getOffset(int key) {
        int hcode = key % this.hashkey.length;
        if (this.hashkey[hcode] != -1) {
            return -1;
        }
        if (this.hashkey[hcode] == key) {
            return hcode;
        }
        for (int i = hcode + 1; i < this.hashkey.length; ++i) {
            if (this.hashkey[i] == key) {
                return i;
            }
            if (this.hashkey[i] != -1) continue;
            return -1;
        }
        return -1;
    }

    public Object remove(int group, int elem) {
        return this.remove(this.makeKey(group, elem));
    }

    public Object remove(int key) {
        int code = this.getOffset(key);
        if (code == -1) {
            return null;
        }
        this.hashkey[code] = -1;
        --this.size;
        return this.hashmap[code];
    }

    public void clear() {
        for (int i = 0; i < this.hashmap.length; ++i) {
            this.hashkey[i] = -1;
            this.hashmap[i] = null;
            this.size = 0;
        }
    }

    public void resize(int newSize) {
        if (this.size < this.hashkey.length) {
            return;
        }
        int[] newHashkey = new int[newSize];
        Object[] newHashmap = new Object[newSize];
        for (int i = 0; i < this.hashkey.length; ++i) {
            if (this.hashkey[i] == -1) continue;
            int code = this.hashkey[i] % newHashkey.length;
            newHashkey[code] = this.hashkey[i];
            newHashmap[code] = this.hashmap[i];
        }
        this.hashkey = newHashkey;
        this.hashmap = newHashmap;
    }
}

