/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.util;

import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.RowColCapable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class XPprint {
    PrintPort pport = null;
    boolean setCol;
    int nImages = 1;

    public XPprint(JComponent port) {
        if (port instanceof FramePositioningCapable) {
            this.nImages = ((FramePositioningCapable)((Object)port)).getNumFrames();
        }
        this.pport = new PrintPort(port);
    }

    public XPprint(JComponent port, int numImages, int width, int height, boolean setRowcol) {
        port.setSize(width, height);
        port.setDoubleBuffered(false);
        this.pport = new PrintPort(port);
        this.nImages = numImages;
        this.setCol = setRowcol;
    }

    public Book getBook() {
        Book book = new Book();
        int rows = this.pport.getRows();
        int cols = this.pport.getCols();
        int pg = this.nImages;
        if (this.setCol && (pg = (int)Math.ceil(this.nImages / (rows * cols))) * rows * cols < this.nImages) {
            ++pg;
        }
        for (int i = 0; i < pg; ++i) {
            book.append(this.pport, new PageFormat());
        }
        return book;
    }

    public void print() {
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        int rows = this.pport.getRows();
        int cols = this.pport.getCols();
        int pg = this.nImages;
        if (this.setCol && (pg = (int)Math.ceil(this.nImages / (rows * cols))) * rows * cols < this.nImages) {
            ++pg;
        }
        for (int i = 0; i < pg; ++i) {
            book.append(this.pport, new PageFormat());
        }
        printerJob.setPageable(book);
        final boolean doPrint = printerJob.printDialog();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                if (doPrint) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        // empty catch block
                    }
                }
            }
        });
        t.start();
    }

    class PrintPort
    implements Printable {
        private JComponent port = null;
        private int nRows = 1;
        private int nCols = 1;
        private final JFrame jf = new JFrame("Offscreen");
        private final JPanel jp = new JPanel();

        public PrintPort(JComponent port) {
            this.port = port;
            if (port instanceof RowColCapable) {
                this.nRows = ((RowColCapable)((Object)port)).getRows();
                this.nCols = ((RowColCapable)((Object)port)).getCols();
            }
        }

        int getCols() {
            return this.nCols;
        }

        int getRows() {
            return this.nRows;
        }

        @Override
        public int print(Graphics g, PageFormat format, int pageIndex) throws PrinterException {
            if (this.port instanceof FramePositioningCapable) {
                ((FramePositioningCapable)((Object)this.port)).setFrameIndex(this.nRows * this.nCols * pageIndex);
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(format.getImageableX(), format.getImageableY());
            this.port.setPreferredSize(this.port.getSize());
            this.jf.setContentPane(this.port);
            this.jf.pack();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            double sx = format.getImageableWidth() / (double)this.port.getWidth();
            double sy = format.getImageableHeight() / (double)this.port.getHeight();
            if (sx > sy) {
                sx = sy;
            } else {
                sy = sx;
            }
            g2d.scale(sx, sy);
            this.port.paint(g2d);
            this.jf.setContentPane(this.jp);
            return 0;
        }
    }
}

