/*
 * Decompiled with CFR 0.152.
 */
package srjdom;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.SOPClass;
import com.archimed.dicom.TagReadEvent;
import com.archimed.dicom.TagReadListener;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import srjdom.DcmDOM;
import srjdom.SRCommon;

public class EncapsulatedDocument
extends DcmDOM {
    private static int seriesNumber = 5000;
    private static int[] neededTags = new int[]{131073, 131088, 0x100010, 0x100020, 0x100021, 0x100022, 0x100030, 0x100040, 0x101002, 0x20000D, 524320, 524336, 524432, 0x200010, 524368, 524400, 0x200011, 528446, 524323, 524339, 524330, 2622209, 4325395, 528720, 528725, 4325392, 4235331, 524544, 524546, 524548, 4236435, 524293, 524310, 524312};
    private static TagReadListener tagReadListener = new TagReadListener(){

        @Override
        public void afterHeader(TagReadEvent e) {
            int i;
            int tag2 = e.getTag();
            for (i = 0; i < neededTags.length && neededTags[i] != tag2; ++i) {
            }
            if (i < neededTags.length && neededTags[i] == tag2) {
                e.setDataReadStatus(0);
            } else {
                e.setDataReadStatus(2);
            }
        }
    };

    public EncapsulatedDocument() {
    }

    public EncapsulatedDocument(Type type, String sopIUID, String impCUID) throws DicomException {
        this(type.getSOPClassUID(), sopIUID, SRCommon.TS_EXPLICIT_LITTLE_ENDIAN, impCUID);
    }

    public EncapsulatedDocument(String sopCUID, String sopIUID, String impCUID) throws DicomException {
        this(sopCUID, sopIUID, SRCommon.TS_EXPLICIT_LITTLE_ENDIAN, impCUID);
    }

    public EncapsulatedDocument(String sopCUID, String sopIUID, String trSyntaxUID, String impCUID) throws DicomException {
        super(sopCUID, sopIUID, trSyntaxUID, impCUID);
    }

    public String getDocumentTitle() {
        String documentTitle = null;
        if (this.dcmObj != null) {
            try {
                documentTitle = this.dcmObj.getS(4325392);
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        return documentTitle;
    }

    public void setDocumentTitle(String documentTitle) {
        if (this.dcmObj != null) {
            try {
                this.dcmObj.set(4325392, documentTitle);
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
    }

    public String getMIMEType() {
        String mimeType = null;
        if (this.dcmObj != null) {
            try {
                mimeType = this.dcmObj.getS(4325394);
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        return mimeType;
    }

    public void fill(String dcmFileName, String seriesIUID, String docFileName, String docFileMIMEType, BurnedInAnnotation burnedInAnnotation) {
        this.initDICOMTags(dcmFileName, burnedInAnnotation);
        if (this.dcmObj != null) {
            try {
                this.dcmObj.set(524384, "OT");
                this.dcmObj.set(0x20000E, seriesIUID);
                this.dcmObj.set(524400, "GE MEDICAL SYSTEMS");
                this.dcmObj.set(524388, "WSD");
                this.dcmObj.set(2097171, "1");
                this.dcmObj.set(4325394, docFileMIMEType);
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        this.attachDocument(docFileName);
        this.buildDOM(this.metaInfo, this.root);
        this.buildDOM(this.dcmObj, this.root);
    }

    public void initDICOMTags(String fileName, BurnedInAnnotation burnedInAnnotation) {
        SRCommon.logger.info("> initDICOMTags(): " + fileName);
        DicomReader dcmReader = new DicomReader();
        dcmReader.addTagReadListener(tagReadListener);
        DicomObject dcmInitFrom = SRCommon.openDCM(new File(fileName), dcmReader);
        if (this.dcmObj != null && dcmInitFrom != null) {
            try {
                DicomObject item;
                SRCommon.copyType1CTag(dcmInitFrom, this.dcmObj, 524293, "ISO_IR 100");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 0x100010, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 0x100020, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 0x100021, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 0x100030, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 0x100040, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 0x101000, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 0x101002);
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 0x20000D, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 524320, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 524336, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 524432, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 0x200010, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 524368, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 0x200011, String.valueOf(seriesNumber));
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 528446, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 524323, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 524339, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 524330, "");
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 2622209, burnedInAnnotation.toString());
                if (dcmInitFrom.getSize(4325395) <= 0) {
                    item = new DicomObject();
                    item.set(528720, dcmInitFrom.get(524310));
                    item.set(528725, dcmInitFrom.get(524312));
                    this.dcmObj.set(4325395, item);
                } else {
                    SRCommon.copyTag(dcmInitFrom, this.dcmObj, 4325395);
                }
                item = (DicomObject)dcmInitFrom.get(4235331);
                if (item != null) {
                    SRCommon.copyTag(dcmInitFrom, this.dcmObj, 4325392, item.get(524548));
                }
                SRCommon.copyTag(dcmInitFrom, this.dcmObj, 4235331);
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        SRCommon.logger.info("< initDICOMTags()");
    }

    public void attachDocument(String fileName) {
        this.attachDocument(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachDocument(File file) {
        SRCommon.logger.info("> attachDocument(): " + file);
        if (this.dcmObj != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                SRCommon.logger.info("\t# of bytes: " + fis.available());
                byte[] docBytes = new byte[fis.available()];
                fis.read(docBytes);
                this.dcmObj.setBytes(4325393, docBytes, 0);
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ex) {
                        SRCommon.logger.log(Level.WARNING, null, ex);
                    }
                }
            }
        }
        SRCommon.logger.info("< attachDocument(): ");
    }

    public void saveDCM(File file) throws IOException, DicomException, UnknownUIDException {
        SRCommon.logger.info("> saveDCM(): " + file);
        FileOutputStream fout = new FileOutputStream(file);
        int transferSyntax = UID.getUIDEntry(SRCommon.getJDTString(this.metaInfo, 131088)).getConstant();
        this.dcmObj.write(fout, true, transferSyntax, true, false);
        fout.close();
        SRCommon.logger.info("< saveDCM()");
    }

    public void retrieveDocument() {
        try {
            this.retrieveDocument(this.dcmObj.getS(4325392) + ".pdf");
        }
        catch (Exception ex) {
            SRCommon.logger.log(Level.WARNING, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveDocument(String fileName) {
        SRCommon.logger.info("> retrieveDocument()");
        if (this.dcmObj != null) {
            FileOutputStream fos = null;
            try {
                byte[] docBytes = this.dcmObj.getBytes(4325393, 0);
                fos = new FileOutputStream(fileName);
                fos.write(docBytes);
                fos.flush();
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ex) {
                        SRCommon.logger.log(Level.WARNING, null, ex);
                    }
                }
            }
        }
        SRCommon.logger.info("< retrieveDocument(): " + fileName);
    }

    private static void usage() {
        System.out.println("Options:");
        System.out.println("\t-c, --create  <DICOM file to initialize from> <Document to encapsulate>");
        System.out.println("\t-x, --extract <DICOM Encapsulated Document>");
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            EncapsulatedDocument.usage();
            System.exit(1);
        }
        String dcmToInitFrom = null;
        String doc = null;
        String dcmEncapDoc = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-c") || args[i].equalsIgnoreCase("--create")) {
                if (args.length < 3) {
                    EncapsulatedDocument.usage();
                    System.exit(1);
                }
                dcmToInitFrom = args[i + 1];
                doc = args[i + 2];
                if (doc.endsWith(".pdf")) continue;
                System.out.println(doc + " is not PDF file!");
                System.exit(2);
                continue;
            }
            if (!args[i].equalsIgnoreCase("-x") && !args[i].equalsIgnoreCase("--extract")) continue;
            if (args.length < 2) {
                EncapsulatedDocument.usage();
                System.exit(1);
            }
            dcmEncapDoc = args[i + 1];
        }
        EncapsulatedDocument encapDoc = new EncapsulatedDocument();
        if (dcmToInitFrom != null && doc != null) {
            try {
                System.out.println("Encapsulate PDF to DICOM...");
                encapDoc.fill(dcmToInitFrom, "1.2.3", doc, "application/pdf", BurnedInAnnotation.NO);
                encapDoc.saveDCM(new File("huhu.dcm"));
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        if (dcmEncapDoc != null) {
            try {
                System.out.println("Retrieve PDF form DICOM...");
                encapDoc.readDCM(dcmEncapDoc);
                System.out.println("    (0042,0010) DocumentTitle: [" + encapDoc.getDocumentTitle() + "]");
                System.out.println("    (0042,0012) MIMETypeofEncapsulatedDocument: [" + encapDoc.getMIMEType() + "]");
                encapDoc.retrieveDocument();
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        encapDoc.writeXML();
        encapDoc.writeXML(encapDoc.getDocumentTitle() + ".xml");
    }

    public static enum BurnedInAnnotation {
        YES,
        NO;

    }

    public static enum Type {
        PDF(SOPClass.EncapsulatedPDFStorageUID.getValue(), "application/pdf"),
        CDA("1.2.840.10008.5.1.4.1.1.104.2", "text/xml");

        private String sopClassUID;
        private String mimeType;

        private Type(String sopCUID, String mime) {
            this.sopClassUID = sopCUID;
            this.mimeType = mime;
        }

        public String getSOPClassUID() {
            return this.sopClassUID;
        }

        public String getMIMEType() {
            return this.mimeType;
        }
    }
}

