/*
 * Decompiled with CFR 0.152.
 */
package srjdom;

import com.archimed.dicom.DicomObject;
import java.util.logging.Level;
import srjdom.IssuerOfPatientIDMacro;
import srjdom.PatientIDsItem;
import srjdom.SRCommon;
import srjdom.SRNode;
import srjdom.SRSeq;

public class PatientIDsSeq
extends SRSeq {
    PatientIDsSeq() {
        this(0);
    }

    PatientIDsSeq(int maxItem) {
        super(0x101002, maxItem);
    }

    public void appendChild(PatientIDsItem child) {
        super.appendChild(child);
    }

    public void removeChild(PatientIDsItem child) {
        super.removeChild(child);
    }

    @Override
    protected void appendChild(SRNode child) {
        if (!(child instanceof PatientIDsItem)) {
            throw new IllegalArgumentException("child is not PatientIDsItem instance.");
        }
        super.appendChild(child);
    }

    @Override
    protected void removeChild(SRNode child) {
        if (!(child instanceof PatientIDsItem)) {
            throw new IllegalArgumentException("child is not PatientIDsItem instance.");
        }
        super.removeChild(child);
    }

    public void fill(DicomObject dcm) {
        SRCommon.logger.info("> fill():\t" + dcm + " size: " + dcm.getSize(0x101002));
        for (int i = 0; i < dcm.getSize(0x101002); ++i) {
            try {
                DicomObject item = (DicomObject)dcm.get(0x101002, i);
                if (item == null) continue;
                IssuerOfPatientIDMacro issuerOfPatientIDMacro = new IssuerOfPatientIDMacro();
                issuerOfPatientIDMacro.fill(item);
                PatientIDsItem patientIDsItem = new PatientIDsItem(SRCommon.getJDTString(item, 0x100020), issuerOfPatientIDMacro, PatientIDsItem.PatientIDType.valueOf(SRCommon.getJDTString(item, 0x100022)));
                this.appendChild(patientIDsItem);
                continue;
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        SRCommon.logger.info("< fill()");
    }
}

