/*
 * Decompiled with CFR 0.152.
 */
package srjdom;

import java.util.logging.Level;
import org.w3c.dom.Element;
import srjdom.SRCommon;
import srjdom.SRDOMDoc;

public class SRDOMValidator {
    private SRDOMDoc srDOM = null;
    private Element root = null;

    public SRDOMValidator(SRDOMDoc srDOMDoc) {
        this.srDOM = srDOMDoc;
        this.root = this.srDOM.root;
    }

    public void validate() {
        this.removeEmptyPrivate();
        this.removeEmptyType1C();
    }

    private void removeEmptyPrivate() {
        SRCommon.logger.info("> removeEmptyPrivate()");
        if (this.srDOM.privateCreator != null && this.srDOM.privateCreator.xmlTag.getParentNode() != null) {
            try {
                String privCreator = this.srDOM.privateCreator.getValue();
                if (privCreator == null || privCreator.trim().equalsIgnoreCase("")) {
                    this.root.removeChild(this.srDOM.privateCreator.xmlTag);
                }
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        if (this.srDOM.appSpecificData != null && this.srDOM.appSpecificData.xmlTag.getParentNode() != null) {
            try {
                String appSpecData = this.srDOM.appSpecificData.getValue();
                if (appSpecData == null || appSpecData.trim().equalsIgnoreCase("")) {
                    this.root.removeChild(this.srDOM.appSpecificData.xmlTag);
                }
            }
            catch (Exception ex) {
                SRCommon.logger.log(Level.WARNING, null, ex);
            }
        }
        SRCommon.logger.info("< removeEmptyPrivate()");
    }

    private void removeEmptyType1C() {
        String specificCharacterSet;
        String obsDateTime;
        SRCommon.logger.info("> removeEmptyType1C()");
        if (this.srDOM.otherPatientIDsSeq.getLength() <= 0) {
            this.removeChildNode(this.root, this.srDOM.otherPatientIDsSeq.xmlTag);
        }
        if (this.srDOM.synchronizationModule != null) {
            if (this.srDOM.synchronizationModule.synchronizationFrameOfReferenceUID.isEmpty() || this.srDOM.synchronizationModule.synchronizationTrigger.isEmpty() || this.srDOM.synchronizationModule.acquisitionTimeSynchronized.isEmpty()) {
                this.removeChildNode(this.root, this.srDOM.synchronizationModule.synchronizationFrameOfReferenceUID.xmlTag);
                this.removeChildNode(this.root, this.srDOM.synchronizationModule.synchronizationTrigger.xmlTag);
                this.removeChildNode(this.root, this.srDOM.synchronizationModule.triggerSourceOrType.xmlTag);
                this.removeChildNode(this.root, this.srDOM.synchronizationModule.synchronizationChannel.xmlTag);
                this.removeChildNode(this.root, this.srDOM.synchronizationModule.acquisitionTimeSynchronized.xmlTag);
                this.removeChildNode(this.root, this.srDOM.synchronizationModule.timeSource.xmlTag);
                this.removeChildNode(this.root, this.srDOM.synchronizationModule.timeDistributionProtocol.xmlTag);
                this.removeChildNode(this.root, this.srDOM.synchronizationModule.ntpSourceAddress.xmlTag);
            } else if (this.srDOM.synchronizationModule.synchronizationChannel.isEmpty()) {
                this.removeChildNode(this.root, this.srDOM.synchronizationModule.synchronizationChannel.xmlTag);
            }
        }
        if (this.srDOM.verifyingObserverSeq.getLength() <= 0) {
            this.removeChildNode(this.root, this.srDOM.verifyingObserverSeq.xmlTag);
        }
        if (this.srDOM.predecessorDocumentsSeq.getLength() <= 0) {
            this.removeChildNode(this.root, this.srDOM.predecessorDocumentsSeq.xmlTag);
        }
        if (this.srDOM.identicalDocumentsSeq.getLength() <= 0) {
            this.removeChildNode(this.root, this.srDOM.identicalDocumentsSeq.xmlTag);
        }
        if (this.srDOM.referencedReqSeq.getLength() <= 0) {
            this.removeChildNode(this.root, this.srDOM.referencedReqSeq.xmlTag);
        }
        if (this.srDOM.currentReqProcEvidenceSeq.getLength() <= 0) {
            this.removeChildNode(this.root, this.srDOM.currentReqProcEvidenceSeq.xmlTag);
        }
        if (this.srDOM.pertinentOtherEvidenceSeq.getLength() <= 0) {
            this.removeChildNode(this.root, this.srDOM.pertinentOtherEvidenceSeq.xmlTag);
        }
        if (this.srDOM.contentTemplateSeq.getLength() <= 0) {
            this.removeChildNode(this.root, this.srDOM.contentTemplateSeq.xmlTag);
        }
        if ((obsDateTime = this.srDOM.observationDateTime.getValue()) == null || obsDateTime.trim().equalsIgnoreCase("")) {
            this.removeChildNode(this.root, this.srDOM.observationDateTime.xmlTag);
        }
        if ((specificCharacterSet = this.srDOM.specificCharacterSet.getValue()) == null || specificCharacterSet.trim().equalsIgnoreCase("")) {
            this.removeChildNode(this.root, this.srDOM.specificCharacterSet.xmlTag);
        }
        SRCommon.logger.info("< removeEmptyType1C()");
    }

    private void removeChildNode(Element parent, Element child) {
        try {
            parent.removeChild(child);
        }
        catch (Exception ex) {
            SRCommon.logger.log(Level.WARNING, null, ex);
        }
    }
}

