/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.VolatileImage;
import java.security.AccessController;
import sun.awt.image.BufImgSurfaceData;
import sun.awt.windows.WWindowPeer;
import sun.java2d.DestSurfaceProvider;
import sun.java2d.InvalidPipeException;
import sun.java2d.Surface;
import sun.java2d.d3d.D3DSurfaceData;
import sun.java2d.opengl.WGLSurfaceData;
import sun.java2d.pipe.BufferedContext;
import sun.java2d.pipe.RenderQueue;
import sun.java2d.pipe.hw.AccelGraphicsConfig;
import sun.java2d.pipe.hw.AccelSurface;
import sun.security.action.GetPropertyAction;

abstract class TranslucentWindowPainter {
    protected Window window;
    protected WWindowPeer peer;
    private static final boolean forceOpt = Boolean.valueOf(AccessController.doPrivileged(new GetPropertyAction("sun.java2d.twp.forceopt", "false")));
    private static final boolean forceSW = Boolean.valueOf(AccessController.doPrivileged(new GetPropertyAction("sun.java2d.twp.forcesw", "false")));

    public static TranslucentWindowPainter createInstance(WWindowPeer peer) {
        GraphicsConfiguration gc = peer.getGraphicsConfiguration();
        if (!forceSW && gc instanceof AccelGraphicsConfig) {
            String gcName = gc.getClass().getSimpleName();
            AccelGraphicsConfig agc = (AccelGraphicsConfig)((Object)gc);
            if ((agc.getContextCapabilities().getCaps() & 0x100) != 0 || forceOpt) {
                if (gcName.startsWith("D3D")) {
                    return new VIOptD3DWindowPainter(peer);
                }
                if (forceOpt && gcName.startsWith("WGL")) {
                    return new VIOptWGLWindowPainter(peer);
                }
            }
        }
        return new BIWindowPainter(peer);
    }

    protected TranslucentWindowPainter(WWindowPeer peer) {
        this.peer = peer;
        this.window = (Window)peer.getTarget();
    }

    protected abstract Image getBackBuffer(boolean var1);

    protected abstract boolean update(Image var1);

    public abstract void flush();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWindow(boolean repaint) {
        boolean done = false;
        Image bb = this.getBackBuffer(repaint);
        while (!done) {
            if (repaint) {
                Graphics2D g = (Graphics2D)bb.getGraphics();
                try {
                    this.window.paintAll(g);
                }
                finally {
                    g.dispose();
                }
            }
            if (done = this.update(bb)) continue;
            repaint = true;
            bb = this.getBackBuffer(true);
        }
    }

    private static final Image clearImage(Image bb) {
        Graphics2D g = (Graphics2D)bb.getGraphics();
        int w = bb.getWidth(null);
        int h = bb.getHeight(null);
        g.setComposite(AlphaComposite.Src);
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(0, 0, w, h);
        return bb;
    }

    private static class VIOptWGLWindowPainter
    extends VIOptWindowPainter {
        protected VIOptWGLWindowPainter(WWindowPeer peer) {
            super(peer);
        }

        @Override
        protected boolean updateWindowAccel(long psdops, int w, int h) {
            return WGLSurfaceData.updateWindowAccelImpl(psdops, this.peer, w, h);
        }
    }

    private static class VIOptD3DWindowPainter
    extends VIOptWindowPainter {
        protected VIOptD3DWindowPainter(WWindowPeer peer) {
            super(peer);
        }

        @Override
        protected boolean updateWindowAccel(long psdops, int w, int h) {
            return D3DSurfaceData.updateWindowAccelImpl(psdops, this.peer.getData(), w, h);
        }
    }

    private static abstract class VIOptWindowPainter
    extends VIWindowPainter {
        protected VIOptWindowPainter(WWindowPeer peer) {
            super(peer);
        }

        protected abstract boolean updateWindowAccel(long var1, int var3, int var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean update(Image bb) {
            Surface s;
            if (bb instanceof DestSurfaceProvider && (s = ((DestSurfaceProvider)((Object)bb)).getDestSurface()) instanceof AccelSurface) {
                final int w = bb.getWidth(null);
                final int h = bb.getHeight(null);
                final boolean[] arr = new boolean[]{false};
                final AccelSurface as = (AccelSurface)s;
                RenderQueue rq = as.getContext().getRenderQueue();
                rq.lock();
                try {
                    BufferedContext.validateContext(as);
                    rq.flushAndInvokeNow(new Runnable(){

                        @Override
                        public void run() {
                            long psdops = as.getNativeOps();
                            arr[0] = this.updateWindowAccel(psdops, w, h);
                        }
                    });
                }
                catch (InvalidPipeException invalidPipeException) {
                }
                finally {
                    rq.unlock();
                }
                return arr[0];
            }
            return super.update(bb);
        }
    }

    private static class VIWindowPainter
    extends BIWindowPainter {
        private VolatileImage viBB;

        protected VIWindowPainter(WWindowPeer peer) {
            super(peer);
        }

        @Override
        protected Image getBackBuffer(boolean clear) {
            int w = this.window.getWidth();
            int h = this.window.getHeight();
            GraphicsConfiguration gc = this.peer.getGraphicsConfiguration();
            if (this.viBB == null || this.viBB.getWidth() != w || this.viBB.getHeight() != h || this.viBB.validate(gc) == 2) {
                this.flush();
                if (gc instanceof AccelGraphicsConfig) {
                    AccelGraphicsConfig agc = (AccelGraphicsConfig)((Object)gc);
                    this.viBB = agc.createCompatibleVolatileImage(w, h, 3, 2);
                }
                if (this.viBB == null) {
                    this.viBB = gc.createCompatibleVolatileImage(w, h, 3);
                }
                this.viBB.validate(gc);
            }
            return clear ? TranslucentWindowPainter.clearImage(this.viBB) : this.viBB;
        }

        @Override
        public void flush() {
            if (this.viBB != null) {
                this.viBB.flush();
                this.viBB = null;
            }
        }
    }

    private static class BIWindowPainter
    extends TranslucentWindowPainter {
        private BufferedImage backBuffer;

        protected BIWindowPainter(WWindowPeer peer) {
            super(peer);
        }

        @Override
        protected Image getBackBuffer(boolean clear) {
            int w = this.window.getWidth();
            int h = this.window.getHeight();
            if (this.backBuffer == null || this.backBuffer.getWidth() != w || this.backBuffer.getHeight() != h) {
                this.flush();
                this.backBuffer = new BufferedImage(w, h, 3);
            }
            return clear ? (BufferedImage)TranslucentWindowPainter.clearImage(this.backBuffer) : this.backBuffer;
        }

        @Override
        protected boolean update(Image bb) {
            VolatileImage viBB = null;
            if (bb instanceof BufferedImage) {
                BufferedImage bi = (BufferedImage)bb;
                int[] data = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
                this.peer.updateWindowImpl(data, bi.getWidth(), bi.getHeight());
                return true;
            }
            if (bb instanceof VolatileImage) {
                Surface s;
                viBB = (VolatileImage)bb;
                if (bb instanceof DestSurfaceProvider && (s = ((DestSurfaceProvider)((Object)bb)).getDestSurface()) instanceof BufImgSurfaceData) {
                    int w = viBB.getWidth();
                    int h = viBB.getHeight();
                    BufImgSurfaceData bisd = (BufImgSurfaceData)s;
                    int[] data = ((DataBufferInt)bisd.getRaster(0, 0, w, h).getDataBuffer()).getData();
                    this.peer.updateWindowImpl(data, w, h);
                    return true;
                }
            }
            BufferedImage bi = (BufferedImage)TranslucentWindowPainter.clearImage(this.backBuffer);
            int[] data = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
            this.peer.updateWindowImpl(data, bi.getWidth(), bi.getHeight());
            return viBB != null ? !viBB.contentsLost() : true;
        }

        @Override
        public void flush() {
            if (this.backBuffer != null) {
                this.backBuffer.flush();
                this.backBuffer = null;
            }
        }
    }
}

