/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;
import java.awt.peer.TrayIconPeer;
import sun.awt.SunToolkit;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.windows.WObjectPeer;
import sun.awt.windows.WPopupMenuPeer;
import sun.awt.windows.WToolkit;

final class WTrayIconPeer
extends WObjectPeer
implements TrayIconPeer {
    static final int TRAY_ICON_WIDTH = 16;
    static final int TRAY_ICON_HEIGHT = 16;
    static final int TRAY_ICON_MASK_SIZE = 32;
    IconObserver observer = new IconObserver();
    boolean firstUpdate = true;
    Frame popupParent = new Frame("PopupMessageWindow");
    PopupMenu popup;

    @Override
    protected void disposeImpl() {
        if (this.popupParent != null) {
            this.popupParent.dispose();
        }
        this.popupParent.dispose();
        this._dispose();
        WToolkit.targetDisposedPeer(this.target, this);
    }

    WTrayIconPeer(TrayIcon target) {
        this.target = target;
        this.popupParent.addNotify();
        this.create();
        this.updateImage();
    }

    @Override
    public void updateImage() {
        Image image = ((TrayIcon)this.target).getImage();
        if (image != null) {
            this.updateNativeImage(image);
        }
    }

    @Override
    public native void setToolTip(String var1);

    @Override
    public synchronized void showPopupMenu(final int x, final int y) {
        if (this.isDisposed()) {
            return;
        }
        SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            @Override
            public void run() {
                PopupMenu newPopup = ((TrayIcon)WTrayIconPeer.this.target).getPopupMenu();
                if (WTrayIconPeer.this.popup != newPopup) {
                    if (WTrayIconPeer.this.popup != null) {
                        WTrayIconPeer.this.popupParent.remove(WTrayIconPeer.this.popup);
                    }
                    if (newPopup != null) {
                        WTrayIconPeer.this.popupParent.add(newPopup);
                    }
                    WTrayIconPeer.this.popup = newPopup;
                }
                if (WTrayIconPeer.this.popup != null) {
                    ((WPopupMenuPeer)WTrayIconPeer.this.popup.getPeer()).show(WTrayIconPeer.this.popupParent, new Point(x, y));
                }
            }
        });
    }

    @Override
    public void displayMessage(String caption, String text, String messageType) {
        if (caption == null) {
            caption = "";
        }
        if (text == null) {
            text = "";
        }
        this._displayMessage(caption, text, messageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void updateNativeImage(Image image) {
        if (this.isDisposed()) {
            return;
        }
        boolean autosize = ((TrayIcon)this.target).isImageAutoSize();
        BufferedImage bufImage = new BufferedImage(16, 16, 2);
        Graphics2D gr = bufImage.createGraphics();
        if (gr != null) {
            try {
                gr.setPaintMode();
                gr.drawImage(image, 0, 0, autosize ? 16 : image.getWidth(this.observer), autosize ? 16 : image.getHeight(this.observer), this.observer);
                this.createNativeImage(bufImage);
                this.updateNativeIcon(!this.firstUpdate);
                if (this.firstUpdate) {
                    this.firstUpdate = false;
                }
            }
            finally {
                gr.dispose();
            }
        }
    }

    void createNativeImage(BufferedImage bimage) {
        WritableRaster raster = bimage.getRaster();
        byte[] andMask = new byte[32];
        int[] pixels = ((DataBufferInt)raster.getDataBuffer()).getData();
        int npixels = pixels.length;
        int ficW = raster.getWidth();
        for (int i = 0; i < npixels; ++i) {
            int ibyte = i / 8;
            int omask = 1 << 7 - i % 8;
            if ((pixels[i] & 0xFF000000) != 0 || ibyte >= andMask.length) continue;
            int n = ibyte;
            andMask[n] = (byte)(andMask[n] | omask);
        }
        if (raster instanceof IntegerComponentRaster) {
            ficW = ((IntegerComponentRaster)raster).getScanlineStride();
        }
        this.setNativeIcon(((DataBufferInt)bimage.getRaster().getDataBuffer()).getData(), andMask, ficW, raster.getWidth(), raster.getHeight());
    }

    void postEvent(AWTEvent event) {
        WToolkit.postEvent(WToolkit.targetToAppContext(this.target), event);
    }

    native void create();

    synchronized native void _dispose();

    native void updateNativeIcon(boolean var1);

    native void setNativeIcon(int[] var1, byte[] var2, int var3, int var4, int var5);

    native void _displayMessage(String var1, String var2, String var3);

    class IconObserver
    implements ImageObserver {
        IconObserver() {
        }

        @Override
        public boolean imageUpdate(Image image, int flags, int x, int y, int width, int height) {
            if (image != ((TrayIcon)WTrayIconPeer.this.target).getImage() || WTrayIconPeer.this.isDisposed()) {
                return false;
            }
            if ((flags & 0x33) != 0) {
                WTrayIconPeer.this.updateNativeImage(image);
            }
            return (flags & 0x20) == 0;
        }
    }
}

