/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.BreakIterator;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CalendarNameProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.util.locale.provider.AuxLocaleProviderAdapter;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleServiceProviderPool;

public class SPILocaleProviderAdapter
extends AuxLocaleProviderAdapter {
    @Override
    public LocaleProviderAdapter.Type getAdapterType() {
        return LocaleProviderAdapter.Type.SPI;
    }

    @Override
    protected <P extends LocaleServiceProvider> P findInstalledProvider(final Class<P> c) {
        try {
            return (P)((LocaleServiceProvider)AccessController.doPrivileged(new PrivilegedExceptionAction<P>(){

                @Override
                public P run() {
                    LocaleServiceProvider delegate = null;
                    for (LocaleServiceProvider provider : ServiceLoader.loadInstalled(c)) {
                        if (delegate == null) {
                            try {
                                delegate = (LocaleServiceProvider)Class.forName(SPILocaleProviderAdapter.class.getCanonicalName() + "$" + c.getSimpleName() + "Delegate").newInstance();
                            }
                            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                                LocaleServiceProviderPool.config(SPILocaleProviderAdapter.class, e.toString());
                                return null;
                            }
                        }
                        ((Delegate)((Object)delegate)).addImpl(provider);
                    }
                    return delegate;
                }
            }));
        }
        catch (PrivilegedActionException e) {
            LocaleServiceProviderPool.config(SPILocaleProviderAdapter.class, e.toString());
            return null;
        }
    }

    private static <P extends LocaleServiceProvider> P getImpl(Map<Locale, P> map, Locale locale) {
        for (Locale l : LocaleServiceProviderPool.getLookupLocales(locale)) {
            LocaleServiceProvider ret = (LocaleServiceProvider)map.get(l);
            if (ret == null) continue;
            return (P)ret;
        }
        return null;
    }

    static class TimeZoneNameProviderDelegate
    extends TimeZoneNameProvider
    implements Delegate<TimeZoneNameProvider> {
        private ConcurrentMap<Locale, TimeZoneNameProvider> map = new ConcurrentHashMap<Locale, TimeZoneNameProvider>();

        TimeZoneNameProviderDelegate() {
        }

        @Override
        public void addImpl(TimeZoneNameProvider impl) {
            for (Locale l : impl.getAvailableLocales()) {
                this.map.putIfAbsent(l, impl);
            }
        }

        @Override
        public TimeZoneNameProvider getImpl(Locale locale) {
            return (TimeZoneNameProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public String getDisplayName(String ID, boolean daylight, int style, Locale locale) {
            TimeZoneNameProvider tznp = this.getImpl(locale);
            assert (tznp != null);
            return tznp.getDisplayName(ID, daylight, style, locale);
        }

        @Override
        public String getGenericDisplayName(String ID, int style, Locale locale) {
            TimeZoneNameProvider tznp = this.getImpl(locale);
            assert (tznp != null);
            return tznp.getGenericDisplayName(ID, style, locale);
        }
    }

    static class LocaleNameProviderDelegate
    extends LocaleNameProvider
    implements Delegate<LocaleNameProvider> {
        private ConcurrentMap<Locale, LocaleNameProvider> map = new ConcurrentHashMap<Locale, LocaleNameProvider>();

        LocaleNameProviderDelegate() {
        }

        @Override
        public void addImpl(LocaleNameProvider impl) {
            for (Locale l : impl.getAvailableLocales()) {
                this.map.putIfAbsent(l, impl);
            }
        }

        @Override
        public LocaleNameProvider getImpl(Locale locale) {
            return (LocaleNameProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public String getDisplayLanguage(String languageCode, Locale locale) {
            LocaleNameProvider lnp = this.getImpl(locale);
            assert (lnp != null);
            return lnp.getDisplayLanguage(languageCode, locale);
        }

        @Override
        public String getDisplayScript(String scriptCode, Locale locale) {
            LocaleNameProvider lnp = this.getImpl(locale);
            assert (lnp != null);
            return lnp.getDisplayScript(scriptCode, locale);
        }

        @Override
        public String getDisplayCountry(String countryCode, Locale locale) {
            LocaleNameProvider lnp = this.getImpl(locale);
            assert (lnp != null);
            return lnp.getDisplayCountry(countryCode, locale);
        }

        @Override
        public String getDisplayVariant(String variant, Locale locale) {
            LocaleNameProvider lnp = this.getImpl(locale);
            assert (lnp != null);
            return lnp.getDisplayVariant(variant, locale);
        }
    }

    static class CurrencyNameProviderDelegate
    extends CurrencyNameProvider
    implements Delegate<CurrencyNameProvider> {
        private ConcurrentMap<Locale, CurrencyNameProvider> map = new ConcurrentHashMap<Locale, CurrencyNameProvider>();

        CurrencyNameProviderDelegate() {
        }

        @Override
        public void addImpl(CurrencyNameProvider impl) {
            for (Locale l : impl.getAvailableLocales()) {
                this.map.putIfAbsent(l, impl);
            }
        }

        @Override
        public CurrencyNameProvider getImpl(Locale locale) {
            return (CurrencyNameProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public String getSymbol(String currencyCode, Locale locale) {
            CurrencyNameProvider cnp = this.getImpl(locale);
            assert (cnp != null);
            return cnp.getSymbol(currencyCode, locale);
        }

        @Override
        public String getDisplayName(String currencyCode, Locale locale) {
            CurrencyNameProvider cnp = this.getImpl(locale);
            assert (cnp != null);
            return cnp.getDisplayName(currencyCode, locale);
        }
    }

    static class CalendarNameProviderDelegate
    extends CalendarNameProvider
    implements Delegate<CalendarNameProvider> {
        private ConcurrentMap<Locale, CalendarNameProvider> map = new ConcurrentHashMap<Locale, CalendarNameProvider>();

        CalendarNameProviderDelegate() {
        }

        @Override
        public void addImpl(CalendarNameProvider impl) {
            for (Locale l : impl.getAvailableLocales()) {
                this.map.putIfAbsent(l, impl);
            }
        }

        @Override
        public CalendarNameProvider getImpl(Locale locale) {
            return (CalendarNameProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public String getDisplayName(String calendarType, int field, int value, int style, Locale locale) {
            CalendarNameProvider cdp = this.getImpl(locale);
            assert (cdp != null);
            return cdp.getDisplayName(calendarType, field, value, style, locale);
        }

        @Override
        public Map<String, Integer> getDisplayNames(String calendarType, int field, int style, Locale locale) {
            CalendarNameProvider cdp = this.getImpl(locale);
            assert (cdp != null);
            return cdp.getDisplayNames(calendarType, field, style, locale);
        }
    }

    static class CalendarDataProviderDelegate
    extends CalendarDataProvider
    implements Delegate<CalendarDataProvider> {
        private ConcurrentMap<Locale, CalendarDataProvider> map = new ConcurrentHashMap<Locale, CalendarDataProvider>();

        CalendarDataProviderDelegate() {
        }

        @Override
        public void addImpl(CalendarDataProvider impl) {
            for (Locale l : impl.getAvailableLocales()) {
                this.map.putIfAbsent(l, impl);
            }
        }

        @Override
        public CalendarDataProvider getImpl(Locale locale) {
            return (CalendarDataProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public int getFirstDayOfWeek(Locale locale) {
            CalendarDataProvider cdp = this.getImpl(locale);
            assert (cdp != null);
            return cdp.getFirstDayOfWeek(locale);
        }

        @Override
        public int getMinimalDaysInFirstWeek(Locale locale) {
            CalendarDataProvider cdp = this.getImpl(locale);
            assert (cdp != null);
            return cdp.getMinimalDaysInFirstWeek(locale);
        }
    }

    static class NumberFormatProviderDelegate
    extends NumberFormatProvider
    implements Delegate<NumberFormatProvider> {
        private ConcurrentMap<Locale, NumberFormatProvider> map = new ConcurrentHashMap<Locale, NumberFormatProvider>();

        NumberFormatProviderDelegate() {
        }

        @Override
        public void addImpl(NumberFormatProvider impl) {
            for (Locale l : impl.getAvailableLocales()) {
                this.map.putIfAbsent(l, impl);
            }
        }

        @Override
        public NumberFormatProvider getImpl(Locale locale) {
            return (NumberFormatProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public NumberFormat getCurrencyInstance(Locale locale) {
            NumberFormatProvider nfp = this.getImpl(locale);
            assert (nfp != null);
            return nfp.getCurrencyInstance(locale);
        }

        @Override
        public NumberFormat getIntegerInstance(Locale locale) {
            NumberFormatProvider nfp = this.getImpl(locale);
            assert (nfp != null);
            return nfp.getIntegerInstance(locale);
        }

        @Override
        public NumberFormat getNumberInstance(Locale locale) {
            NumberFormatProvider nfp = this.getImpl(locale);
            assert (nfp != null);
            return nfp.getNumberInstance(locale);
        }

        @Override
        public NumberFormat getPercentInstance(Locale locale) {
            NumberFormatProvider nfp = this.getImpl(locale);
            assert (nfp != null);
            return nfp.getPercentInstance(locale);
        }
    }

    static class DecimalFormatSymbolsProviderDelegate
    extends DecimalFormatSymbolsProvider
    implements Delegate<DecimalFormatSymbolsProvider> {
        private ConcurrentMap<Locale, DecimalFormatSymbolsProvider> map = new ConcurrentHashMap<Locale, DecimalFormatSymbolsProvider>();

        DecimalFormatSymbolsProviderDelegate() {
        }

        @Override
        public void addImpl(DecimalFormatSymbolsProvider impl) {
            for (Locale l : impl.getAvailableLocales()) {
                this.map.putIfAbsent(l, impl);
            }
        }

        @Override
        public DecimalFormatSymbolsProvider getImpl(Locale locale) {
            return (DecimalFormatSymbolsProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public DecimalFormatSymbols getInstance(Locale locale) {
            DecimalFormatSymbolsProvider dfsp = this.getImpl(locale);
            assert (dfsp != null);
            return dfsp.getInstance(locale);
        }
    }

    static class DateFormatSymbolsProviderDelegate
    extends DateFormatSymbolsProvider
    implements Delegate<DateFormatSymbolsProvider> {
        private ConcurrentMap<Locale, DateFormatSymbolsProvider> map = new ConcurrentHashMap<Locale, DateFormatSymbolsProvider>();

        DateFormatSymbolsProviderDelegate() {
        }

        @Override
        public void addImpl(DateFormatSymbolsProvider impl) {
            for (Locale l : impl.getAvailableLocales()) {
                this.map.putIfAbsent(l, impl);
            }
        }

        @Override
        public DateFormatSymbolsProvider getImpl(Locale locale) {
            return (DateFormatSymbolsProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public DateFormatSymbols getInstance(Locale locale) {
            DateFormatSymbolsProvider dfsp = this.getImpl(locale);
            assert (dfsp != null);
            return dfsp.getInstance(locale);
        }
    }

    static class DateFormatProviderDelegate
    extends DateFormatProvider
    implements Delegate<DateFormatProvider> {
        private ConcurrentMap<Locale, DateFormatProvider> map = new ConcurrentHashMap<Locale, DateFormatProvider>();

        DateFormatProviderDelegate() {
        }

        @Override
        public void addImpl(DateFormatProvider impl) {
            for (Locale l : impl.getAvailableLocales()) {
                this.map.putIfAbsent(l, impl);
            }
        }

        @Override
        public DateFormatProvider getImpl(Locale locale) {
            return (DateFormatProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public DateFormat getTimeInstance(int style, Locale locale) {
            DateFormatProvider dfp = this.getImpl(locale);
            assert (dfp != null);
            return dfp.getTimeInstance(style, locale);
        }

        @Override
        public DateFormat getDateInstance(int style, Locale locale) {
            DateFormatProvider dfp = this.getImpl(locale);
            assert (dfp != null);
            return dfp.getDateInstance(style, locale);
        }

        @Override
        public DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale locale) {
            DateFormatProvider dfp = this.getImpl(locale);
            assert (dfp != null);
            return dfp.getDateTimeInstance(dateStyle, timeStyle, locale);
        }
    }

    static class CollatorProviderDelegate
    extends CollatorProvider
    implements Delegate<CollatorProvider> {
        private ConcurrentMap<Locale, CollatorProvider> map = new ConcurrentHashMap<Locale, CollatorProvider>();

        CollatorProviderDelegate() {
        }

        @Override
        public void addImpl(CollatorProvider impl) {
            for (Locale l : impl.getAvailableLocales()) {
                this.map.putIfAbsent(l, impl);
            }
        }

        @Override
        public CollatorProvider getImpl(Locale locale) {
            return (CollatorProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public Collator getInstance(Locale locale) {
            CollatorProvider cp = this.getImpl(locale);
            assert (cp != null);
            return cp.getInstance(locale);
        }
    }

    static class BreakIteratorProviderDelegate
    extends BreakIteratorProvider
    implements Delegate<BreakIteratorProvider> {
        private ConcurrentMap<Locale, BreakIteratorProvider> map = new ConcurrentHashMap<Locale, BreakIteratorProvider>();

        BreakIteratorProviderDelegate() {
        }

        @Override
        public void addImpl(BreakIteratorProvider impl) {
            for (Locale l : impl.getAvailableLocales()) {
                this.map.putIfAbsent(l, impl);
            }
        }

        @Override
        public BreakIteratorProvider getImpl(Locale locale) {
            return (BreakIteratorProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public BreakIterator getWordInstance(Locale locale) {
            BreakIteratorProvider bip = this.getImpl(locale);
            assert (bip != null);
            return bip.getWordInstance(locale);
        }

        @Override
        public BreakIterator getLineInstance(Locale locale) {
            BreakIteratorProvider bip = this.getImpl(locale);
            assert (bip != null);
            return bip.getLineInstance(locale);
        }

        @Override
        public BreakIterator getCharacterInstance(Locale locale) {
            BreakIteratorProvider bip = this.getImpl(locale);
            assert (bip != null);
            return bip.getCharacterInstance(locale);
        }

        @Override
        public BreakIterator getSentenceInstance(Locale locale) {
            BreakIteratorProvider bip = this.getImpl(locale);
            assert (bip != null);
            return bip.getSentenceInstance(locale);
        }
    }

    static interface Delegate<P extends LocaleServiceProvider> {
        public void addImpl(P var1);

        public P getImpl(Locale var1);
    }
}

