/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.cycling;

import com.agfa.pacs.base.swing.progress.IActivityIndicator;
import com.agfa.pacs.base.swing.util.FocusUtil;
import com.agfa.pacs.base.swing.util.ProgressUtil;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.util.PatientKeyUtils;
import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.DataManagerListenerAdapter;
import com.agfa.pacs.impaxee.data.manager.IDataManagerListener;
import com.agfa.pacs.impaxee.data.manager.IDisplaySetListener;
import com.agfa.pacs.impaxee.glue.cycling.LoadCommand;
import com.agfa.pacs.impaxee.glue.cycling.Messages;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEPatientData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEStudyContainer;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEStudyData;
import com.agfa.pacs.impaxee.glue.monitoring.AutomaticStudyMonitoring;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.IMultiplePatientHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.save.gui.UnsavedDataManager;
import com.agfa.pacs.impaxee.sessions.SessionBuilder;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.cycling.ICycleListProvider;
import com.agfa.pacs.listtext.cycling.ICycleListProviderListener;
import com.agfa.pacs.listtext.cycling.ILoadCommand;
import com.agfa.pacs.listtext.cycling.LoadContext;
import com.agfa.pacs.listtext.cycling.RelevancyManager;
import com.agfa.pacs.listtext.cycling.prefs.CycleListPreferences;
import com.agfa.pacs.listtext.cycling.prefs.ICycleListPreferences;
import com.agfa.pacs.listtext.lta.base.LTAUtil;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklist;
import com.agfa.pacs.listtext.lta.base.worklists.NormalizedWorklistManager;
import com.agfa.pacs.listtext.lta.filter.FilterHelper;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.util.PerformanceUtils;
import com.agfa.pacs.listtext.lta.util.SendError;
import com.agfa.pacs.listtext.lta.util.SimplePatient;
import com.agfa.pacs.listtext.lta.util.StudyList;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObjectUtilities;
import com.agfa.pacs.listtext.swingx.icon.IconUtil;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.permission.Permissions;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import com.tiani.config.LayoutConfig;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.MainFrame2;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.IDataSelectionListener;
import com.tiani.jvision.patinfo.studies.StudyAgeChecker;
import com.tiani.util.message.Message;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.dcm4che3.data.Attributes;

public class ImpaxEECycleListProvider
implements ICycleListProvider {
    private static final ALogger logger = ALogger.getLogger(ImpaxEECycleListProvider.class);
    private static ImpaxEECycleListProvider instance;
    private static final long IGNORED_DOUBLE_CLICK_TIME = 2000L;
    private static final long FIX_OCCUPIED_MEMORY;
    public static final long AVAILABLE_MEMORY;
    protected final IEventEngine eventEngine = EventEngineFactory.getInstance();
    protected final int TEXT_AREA_CANCEL_INIT_REQUEST_EVENT = this.eventEngine.getEventID("TEXT_AREA_CANCEL_INIT_REQUEST");
    protected boolean syncTextArea = true;
    private IDataSelectionListener dataSelectionListener;
    private RemovingDataManagerListener dataManagerListener;
    private static final DataManager dm;
    private SessionBuilder lastSession = null;
    private final ICycleListPreferences prefs;
    private IActivityIndicator activityIndicator;
    protected String willBeSynchronizedUID = null;
    private List<ICycleListProviderListener> listeners = new CopyOnWriteArrayList<ICycleListProviderListener>();
    private int lastOpenedDataHashCode;
    private long lastOpenedDataTimestamp;
    private Object syncMonitor = new Object();
    private WeakReference<List<ILoadCommand>> lastLoadCommandsRef = null;
    private boolean handleRemoveMessagesBasedOnIAConfiguration;

    static {
        FIX_OCCUPIED_MEMORY = Product.isReducedVersion() ? 0x5000000 : 0xB400000;
        AVAILABLE_MEMORY = Math.round((double)(Runtime.getRuntime().maxMemory() - FIX_OCCUPIED_MEMORY) * Config.impaxee.jvision.memory.FillLimit.get());
        dm = DataManager.getInstance();
    }

    public static ImpaxEECycleListProvider getInstance() {
        return instance;
    }

    public ImpaxEECycleListProvider() {
        instance = this;
        this.dataSelectionListener = new PatientAndHangingDataSelectionListener();
        this.dataManagerListener = new RemovingDataManagerListener();
        this.prefs = new CycleListPreferences(ConfigurationProviderFactory.getConfig());
        this.handleRemoveMessagesBasedOnIAConfiguration = ConfigurationProviderFactory.getConfig().getBoolean("listtext.service.removeDataBasedOnSettingInIA");
        DataSelectionManager.getInstance().addListener(this.dataSelectionListener);
        DataManager.getInstance().addListener((IDataManagerListener)this.dataManagerListener);
        DataManager.getInstance().addDisplaySetListener((IDisplaySetListener)this.dataManagerListener);
        AutomaticStudyMonitoring.init();
        StudyAgeChecker.init();
    }

    public IStudyInfo[] getSessions() {
        HashSet<IStudyInfo> hashSet = new HashSet<IStudyInfo>();
        for (IPatientRepresentation iPatientRepresentation : DataManager.getInstance().getPatientRepresentations()) {
            for (IHangingSession iHangingSession : iPatientRepresentation.getSessions()) {
                if (iHangingSession.getStudyInstance() == null) continue;
                hashSet.add(iHangingSession.getStudyInstance());
            }
        }
        return hashSet.toArray(new IStudyInfo[hashSet.size()]);
    }

    public IStudyInfo[] getStudies() {
        ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>();
        for (IStudyData iStudyData : DataManager.getInstance().getAllStudies()) {
            IStudyInfo iStudyInfo = (IStudyInfo)((ImpaxEEStudyData)iStudyData).getDataInfo();
            if (iStudyInfo == null || arrayList.contains(iStudyInfo)) continue;
            arrayList.add(iStudyInfo);
        }
        return arrayList.toArray(new IStudyInfo[arrayList.size()]);
    }

    public IStudyInfo[] getDisplayedStudies() {
        return this.getDisplayedStudies(DataSelectionManager.getInstance().getCurrentPatient());
    }

    public IPatientInfo getDisplayedPatient() {
        IPatientData iPatientData;
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation != null && (iPatientData = iPatientRepresentation.getPatientData()) instanceof ImpaxEEPatientData) {
            return (IPatientInfo)((ImpaxEEPatientData)iPatientData).getDataInfo();
        }
        return null;
    }

    private IStudyInfo[] getDisplayedStudies(IPatientRepresentation iPatientRepresentation) {
        ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>();
        if (iPatientRepresentation != null) {
            for (IStudyData iStudyData : iPatientRepresentation.getPatientData().getStudies()) {
                if (!(iStudyData instanceof ImpaxEEStudyData)) continue;
                arrayList.add((IStudyInfo)((ImpaxEEStudyData)iStudyData).getDataInfo());
            }
        }
        return arrayList.toArray(new IStudyInfo[arrayList.size()]);
    }

    public boolean isStudyDisplayed(String string) {
        if (string != null) {
            IStudyInfo[] iStudyInfoArray;
            IStudyInfo[] iStudyInfoArray2 = iStudyInfoArray = this.getDisplayedStudies();
            int n = iStudyInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStudyInfo iStudyInfo = iStudyInfoArray2[n2];
                if (string.equals(iStudyInfo.getStudyUID())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean mergePatientsAndDisplay(IPatientInfo iPatientInfo, List<? extends IDataInfo> list) throws Exception {
        List list2 = DataInfoUtilities.getLevel(list, IPatientInfo.class);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = iPatientInfo.getKey();
        Object object = null;
        for (Object object2 : list2) {
            if (!object2.getKey().equals(string)) {
                arrayList.add(object2.getKey());
                continue;
            }
            object = object2;
        }
        if (object != null) {
            Object object2;
            dm.markTemporaryMerged(string, arrayList);
            object2 = new ArrayList();
            List list3 = DataInfoUtilities.extractChildrenBelongingToParent((IDataInfo)object, list);
            object2.addAll(list3);
            list.removeAll(list3);
            object2.addAll(list);
            return this.addToCycleListImpl((List<? extends IDataInfo>)object2, false, true, new LoadContext().setAllowMultiplePatients(true));
        }
        dm.markTemporaryMerged(string, arrayList);
        return this.addToCycleListImpl(list, false, true, new LoadContext().setAllowMultiplePatients(true));
    }

    private boolean areMultiplePatientsAllowed() {
        return !Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get();
    }

    public boolean isCurrentWorklistInConference() {
        INormalizedWorklist iNormalizedWorklist = NormalizedWorklistManager.getInstance().getOpenedWorklist();
        return iNormalizedWorklist != null && iNormalizedWorklist.isInConference();
    }

    public boolean canPatientBeMerged(IPatientInfo iPatientInfo) {
        if (dm.getPatient(iPatientInfo.getKey()) != null) {
            return false;
        }
        return !dm.isTemporaryMergeActiveForPatient(iPatientInfo.getKey());
    }

    public boolean isPatientMergedTo(IPatientInfo iPatientInfo, IPatientInfo iPatientInfo2) {
        return dm.isPatientMergedTo(iPatientInfo.getKey(), iPatientInfo2.getKey());
    }

    public void handleDisplayedStudiesChanged(IStudyInfo[] iStudyInfoArray, IStudyData iStudyData, IStudyContainer iStudyContainer) {
        if (iStudyData != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < iStudyInfoArray.length) {
                if (iStudyInfoArray[n2].getKey().equals(iStudyData.getKey())) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n != 0) {
                IStudyInfo iStudyInfo = iStudyInfoArray[n];
                iStudyInfoArray[n] = iStudyInfoArray[0];
                iStudyInfoArray[0] = iStudyInfo;
            }
        }
        if (this.syncTextArea) {
            this.syncTextArea(iStudyInfoArray, iStudyContainer);
        }
        this.fireDisplayedStudiesChanged(iStudyInfoArray, iStudyContainer);
    }

    public void showMessagePopup(String string, Integer n) {
        Message.showMessagePopup((String)string, (Integer)n);
    }

    public void removeAllFromCycleList(boolean bl) {
        DataManager.getInstance().removeAllPatients(true, bl);
    }

    public synchronized void showActivityIndicator() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ImpaxEECycleListProvider.this.activityIndicator != null) {
                    return;
                }
                try {
                    ImpaxEECycleListProvider.this.activityIndicator = ProgressUtil.createActivityIndicator((Component)JVision2.getMainFrame(), (int)LayoutConfig.getInstance().getScreenColumns(), (boolean)true, (IActivityIndicator.DisplayMode)IActivityIndicator.DisplayMode.LAYER);
                    ImpaxEECycleListProvider.this.activityIndicator.setText(Messages.getString("ImpaxEECycleListProvider.FetchData"));
                    ImpaxEECycleListProvider.this.activityIndicator.show();
                }
                catch (Exception exception) {}
            }
        });
    }

    public synchronized void hideActivityIndicator() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ImpaxEECycleListProvider.this.activityIndicator != null) {
                    ImpaxEECycleListProvider.this.activityIndicator.close();
                    ImpaxEECycleListProvider.this.activityIndicator = null;
                }
            }
        });
    }

    public final boolean addToCycleList(List<? extends IDataInfo> list, boolean bl, LoadContext loadContext) throws Exception {
        return this.addToCycleListImpl(list, bl, false, loadContext);
    }

    public final boolean addToCycleListAndDisplay(List<? extends IDataInfo> list, boolean bl) throws Exception {
        return this.addToCycleListImpl(list, bl, true, null);
    }

    public boolean addToCycleListAndDisplay(List<? extends IDataInfo> list, boolean bl, LoadContext loadContext) throws Exception {
        int n = list.hashCode();
        long l = System.currentTimeMillis();
        if (this.lastOpenedDataHashCode == n && l - this.lastOpenedDataTimestamp < 2000L) {
            logger.info("Ignored double click");
            return false;
        }
        this.lastOpenedDataHashCode = n;
        this.lastOpenedDataTimestamp = l;
        return this.addToCycleListImpl(list, bl, true, loadContext);
    }

    private static IPatientInfo getPatient(IDataInfo iDataInfo) {
        while (iDataInfo != null && iDataInfo.getHierarchyLevel() != Level.Patient) {
            iDataInfo = iDataInfo.getTreeParent();
        }
        return (IPatientInfo)iDataInfo;
    }

    private static void mergePatients(List<? extends IDataInfo> list) {
        if (list.size() <= 1) {
            return;
        }
        IPatientInfo iPatientInfo = null;
        Iterator<? extends IDataInfo> iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            IDataInfo iDataInfo = iterator.next();
            IPatientInfo iPatientInfo2 = ImpaxEECycleListProvider.getPatient(iDataInfo);
            if (iPatientInfo == null) {
                iPatientInfo = iPatientInfo2;
                continue;
            }
            if (iPatientInfo == iPatientInfo2 || !Objects.equals(iPatientInfo.getKey(), iPatientInfo2.getKey())) continue;
            IDataInfo iDataInfo2 = iDataInfo.getTreeParent();
            IDataInfo iDataInfo3 = iDataInfo;
            if (DataInfoUtilities.findEqual((Collection)DataInfoUtilities.getLevel((IDataInfo)iPatientInfo, (Level)iDataInfo.getHierarchyLevel()), (IDataInfo)iDataInfo) != null) {
                iterator.remove();
                continue;
            }
            while (true) {
                IDataInfo iDataInfo4;
                if ((iDataInfo4 = DataInfoUtilities.findEqual((Collection)DataInfoUtilities.getLevel((IDataInfo)iPatientInfo, (Level)iDataInfo2.getHierarchyLevel()), (IDataInfo)iDataInfo2)) != null) {
                    iDataInfo4.addChild(iDataInfo3);
                    continue block0;
                }
                iDataInfo3 = iDataInfo2;
                iDataInfo2 = iDataInfo2.getTreeParent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToCycleListImpl(List<? extends IDataInfo> list, boolean bl, boolean bl2, LoadContext loadContext) {
        Object object;
        boolean bl3;
        logger.info("Starting to open a study");
        ImpaxEECycleListProvider.mergePatients(list);
        List<ILoadCommand> list2 = LoadCommand.createLoadCommands(list, bl && Base.isLoadRelevantPriorsEnabled(), true, loadContext);
        boolean bl4 = bl3 = this.areMultiplePatientsAllowed() || loadContext != null && loadContext.isAllowMultiplePatients();
        if (!bl3 && list2.size() > 1) {
            logger.warn("Loading multiple patients forbidden: " + list2);
            this.showMultiplePatientWarning();
            return false;
        }
        boolean bl5 = Permissions.getInstance().isAllowed("ViewUnreported");
        Object object2 = list2.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            object.performTillState(ILoadCommand.LoadState.ResolveRefs);
            if (!bl3 && object.hasMultiplePatients()) {
                this.showMultiplePatientWarning();
                return false;
            }
            if (bl5 || !object.hasUnreportedStudies()) continue;
            logger.warn("Trying to open unreported Study");
            SendError.sendErrorMessage((Exception)new Exception("You cannot review unreported study!"));
            return false;
        }
        DataManager.getInstance().setPreferablyLoadKeyImagesEnabled(this.prefs.isPreferredLoadingEnabled());
        object = this;
        synchronized (object) {
            if (this.lastLoadCommandsRef != null && (object2 = (List)this.lastLoadCommandsRef.get()) != null) {
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    ILoadCommand iLoadCommand = (ILoadCommand)iterator.next();
                    iLoadCommand.cancel();
                }
            }
            this.lastLoadCommandsRef = new WeakReference<List<ILoadCommand>>(list2);
        }
        object = new LoadRunnable(list2, bl2);
        boolean bl6 = EventQueue.isDispatchThread();
        if (bl2 && bl6) {
            new Thread((Runnable)object, "ImpaxEE-AddToCycleList-Thread").start();
        } else {
            ((LoadRunnable)object).run();
        }
        return true;
    }

    protected void showMultiplePatientWarning() {
        Message.warning((String)Messages.getString("ImpaxEECycleListProvider.MultipleUnallowedOpenTitle"), (Object)Messages.getString("ImpaxEECycleListProvider.MultipleUnallowedOpenMessage"));
    }

    public boolean addToCycleListAsPrior(IStudyInfo iStudyInfo, List<? extends IDataInfo> list) {
        IPatientRepresentation iPatientRepresentation = dm.getPatientRepresentation(iStudyInfo.getTreeParent().getKey());
        if (iPatientRepresentation == null || iPatientRepresentation.getStudyContainers().isEmpty()) {
            this.addToCycleListImpl(list, false, false, null);
            return true;
        }
        List list2 = DataInfoUtilities.getLevel(list, (Level)Level.Study);
        for (IStudyContainer iStudyContainer : iPatientRepresentation.getStudyContainers()) {
            for (IStudyInfo iStudyInfo2 : list2) {
                ((ImpaxEEStudyContainer)iStudyContainer).addPriorAndLoad(iStudyInfo2);
            }
        }
        FocusUtil.requestFocusAfterImageLoading((Window)JVision2.getMainFrame(), (Window)LTAUtil.getMainWindow());
        return true;
    }

    public void removeFromCycleList(List<? extends IDataInfo> list, boolean bl) {
        logger.debug("Trying to REMOVE " + list.size() + " objects from the cyclelist...");
        if (bl && this.handleRemoveMessagesBasedOnIAConfiguration && !Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.get()) {
            logger.info("Ignore remove if only one patient deactivated");
            return;
        }
        ArrayList<IPatientData> arrayList = new ArrayList<IPatientData>(2);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
        block0: for (IDataInfo iDataInfo : list) {
            Object object;
            if (iDataInfo instanceof IPatientInfo) {
                object = dm.getPatientRepresentation(iDataInfo.getKey());
                if (object == null) continue;
                arrayList.add(object.getPatientData());
                continue;
            }
            if (iDataInfo instanceof IStudyInfo) {
                object = dm.getStudy(iDataInfo.getKey());
                if (object != null) {
                    arrayList2.add(object);
                    continue;
                }
                boolean bl2 = false;
                for (IPatientRepresentation iPatientRepresentation : dm.getPatientRepresentations()) {
                    for (IHangingSession iHangingSession : iPatientRepresentation.getSessions()) {
                        if (iHangingSession.getStudyInstance() != iDataInfo) continue;
                        IDisplaySet[] iDisplaySetArray = iHangingSession.getSplitAndSortRuntime().getDisplaySets();
                        int n = iDisplaySetArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IDisplaySet iDisplaySet = iDisplaySetArray[n2];
                            if (!arrayList2.contains(iDisplaySet.getStudy())) {
                                arrayList2.add(iDisplaySet.getStudy());
                            }
                            ++n2;
                        }
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue block0;
                }
                continue;
            }
            if (iDataInfo instanceof ISeriesInfo) {
                throw new UnsupportedOperationException();
            }
            if (!(iDataInfo instanceof IObjectInfo)) continue;
            throw new UnsupportedOperationException();
        }
        if (arrayList.isEmpty()) {
            arrayList = null;
        }
        if (arrayList2.isEmpty()) {
            arrayList2 = null;
        }
        UnsavedDataManager unsavedDataManager = new UnsavedDataManager();
        if (arrayList != null) {
            for (IPatientData iPatientData : arrayList) {
                unsavedDataManager.manageSave((JFrame)JVision2.getMainFrame(), Collections.singleton(DataManager.getInstance().getPatientRepresentation(iPatientData.getKey())), null);
            }
        }
        if (arrayList2 != null) {
            for (IStudyData iStudyData : arrayList2) {
                unsavedDataManager.manageSave((JFrame)JVision2.getMainFrame(), Collections.singleton(DataManager.getInstance().getPatientRepresentation(iStudyData.getParent().getKey())), iStudyData);
            }
        }
        if (arrayList2 != null) {
            ArrayList<IHangingSession> arrayList3 = new ArrayList<IHangingSession>();
            for (Object object : arrayList2) {
                IPatientRepresentation iPatientRepresentation;
                iPatientRepresentation = dm.getPatientRepresentation(object.getParent().getKey());
                String string = object.getKey();
                IDisplaySet[] iDisplaySetArray = iPatientRepresentation.getDecompositionRuntime().getDisplaySets();
                int n = iDisplaySetArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IHangingSession iHangingSession;
                    iHangingSession = iDisplaySetArray[n3];
                    if (iHangingSession.getOneObject().getParent().getParent().getKey().equals(string)) {
                        arrayList3.add(iHangingSession);
                    }
                    ++n3;
                }
            }
            dm.removeDisplaySet(arrayList3.toArray(new IDisplaySet[arrayList3.size()]), SplitAndSortChangeType.MANUAL_REMOVAL, true, bl);
        }
        if (arrayList != null) {
            for (IPatientData iPatientData : arrayList) {
                dm.removePatient(iPatientData.getKey(), true, bl);
            }
        }
    }

    public boolean displayFromCycleList(List<? extends IDataInfo> list, LoadContext loadContext) {
        List list2 = DataInfoUtilities.getLevel(list, (Level)Level.Study);
        if (!list2.isEmpty()) {
            DataSelectionManager dataSelectionManager = DataSelectionManager.getInstance();
            if (this.lastSession != null) {
                if (this.isSessionOfPatient(((IStudyInfo)list2.get(0)).getPatient().getKey(), this.lastSession.getDataset())) {
                    Collection collection = this.lastSession.getContainedStudies();
                    if (!collection.isEmpty()) {
                        IStudyData iStudyData = (IStudyData)collection.iterator().next();
                        List list3 = DataInfoUtilities.cloneAndCutBelow(Collections.singletonList((IStudyInfo)((ImpaxEEStudyData)iStudyData).getDataInfo()));
                        RelevancyManager.getInstance().startSearchRelevant(null, list3, false);
                    }
                    this.lastSession.display();
                    this.lastSession = null;
                    FocusUtil.requestFocusAfterImageLoading((Window)JVision2.getMainFrame(), (Window)LTAUtil.getMainWindow());
                    return true;
                }
                this.lastSession = null;
            } else {
                String string = ((IStudyInfo)list2.get(0)).getStudyUID();
                IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(((IStudyInfo)list2.get(0)).getTreeParent().getKey());
                IHanging iHanging = dataSelectionManager.getActiveHanging();
                if (iHanging != null && Objects.equals(iHanging.getStudyContainer().getBaseStudy().getKey(), string)) {
                    return true;
                }
                IHanging iHanging2 = null;
                int n = 0;
                while (n < iPatientRepresentation.countHangings()) {
                    if (iPatientRepresentation.getHanging(n).getStudyContainer().getBaseStudy().getStudyInstanceUID().equals(string)) {
                        iHanging2 = iPatientRepresentation.getHanging(n);
                        break;
                    }
                    ++n;
                }
                if (iHanging2 == null) {
                    try {
                        this.addToCycleListAndDisplay(list, Base.isLoadRelevantPriorsEnabled(), loadContext);
                    }
                    catch (Exception exception) {
                        logger.error("Could not load study", (Throwable)exception);
                        return false;
                    }
                    return true;
                }
                dataSelectionManager.setActiveHanging(iPatientRepresentation, iHanging2, true, true);
                dataSelectionManager.displayCurrentPatient(((IStudyInfo)list2.get(0)).getTreeParent().getKey());
                FocusUtil.requestFocusAfterImageLoading((Window)JVision2.getMainFrame(), (Window)LTAUtil.getMainWindow());
                return true;
            }
        }
        return false;
    }

    private boolean isSessionOfPatient(String string, Attributes attributes) {
        String string2 = PatientKeyUtils.generatePatientKey((Attributes)attributes);
        if (CompareUtils.equals((Object)string, (Object)string2)) {
            return true;
        }
        IPatientData iPatientData = dm.getSimilarPatient(attributes, null);
        return iPatientData != null && CompareUtils.equals((Object)string, (Object)iPatientData.getKey());
    }

    private IStudyInfo[] extractStudyInfos(IStudyData[] iStudyDataArray) {
        ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>();
        IStudyData[] iStudyDataArray2 = iStudyDataArray;
        int n = iStudyDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStudyInfo iStudyInfo;
            IStudyData iStudyData = iStudyDataArray2[n2];
            IStudyInfo iStudyInfo2 = iStudyInfo = iStudyData instanceof ImpaxEEStudyData ? (IStudyInfo)((ImpaxEEStudyData)iStudyData).getDataInfo() : null;
            if (iStudyData != null) {
                arrayList.add(iStudyInfo);
            }
            ++n2;
        }
        return arrayList.toArray(new IStudyInfo[arrayList.size()]);
    }

    protected void handleStudiesAdded(IStudyData[] iStudyDataArray) {
        this.fireStudiesAdded(this.extractStudyInfos(iStudyDataArray));
    }

    protected void handleStudiesRemoved(IStudyData[] iStudyDataArray, boolean bl) {
        this.fireStudiesRemoved(this.extractStudyInfos(iStudyDataArray), bl);
    }

    protected void handlePatientRemoved(IPatientData iPatientData, Collection<IStudyData> collection, boolean bl) {
        this.firePatientRemoved((IPatientInfo)iPatientData.getQueryObject(), this.extractStudyInfos(collection.toArray(new IStudyData[collection.size()])), bl);
    }

    private String getLoggingKey(IDataInfo iDataInfo) {
        return PatientKeyUtils.generatePatientKey((String)iDataInfo.getString(0x100020), null, (String)iDataInfo.getString(0x100021));
    }

    public static List<IObjectInfo> expandThinSliceArchive(IStudyInfo iStudyInfo, IDataInfoNode iDataInfoNode) {
        try {
            List list = ImpaxEECycleListProvider.hasAdditionalThinSliceSeries(iStudyInfo, iDataInfoNode);
            if (!list.isEmpty()) {
                List list2 = DataInfoUtilities.getLevel(list, IStudyInfo.class);
                PerformanceUtils.getObjectLevel((IStudyInfo)((IStudyInfo)list2.get(0)));
                list = DataInfoUtilities.getLevel((Collection)list2, ISeriesInfo.class);
                List list3 = DataInfoUtilities.getLevel((IDataInfo)iStudyInfo, ISeriesInfo.class);
                Set set = list3.stream().map(iSeriesInfo -> iSeriesInfo.getSeriesUID()).collect(Collectors.toSet());
                list.removeIf(iSeriesInfo -> set.contains(iSeriesInfo.getSeriesUID()));
                ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>(256);
                for (ISeriesInfo iSeriesInfo2 : list) {
                    iSeriesInfo2.getAttributes().setProperty("ThinArchive", (Object)Boolean.TRUE);
                    iStudyInfo.addChild((IDataInfo)iSeriesInfo2);
                    arrayList.addAll(DataInfoUtilities.getLevel((IDataInfo)iSeriesInfo2, IObjectInfo.class));
                }
                return arrayList;
            }
            return Collections.emptyList();
        }
        catch (Exception exception) {
            logger.error("Thin slice archive search failed", (Throwable)exception);
            Message.warning((Object)Messages.getString("ImpaxEECycleListProvider.ThinSliceSearchFailed"));
            return Collections.emptyList();
        }
    }

    public static boolean hasAdditionalThinSliceData(IStudyInfo iStudyInfo, IDataInfoNode iDataInfoNode) {
        return !ImpaxEECycleListProvider.hasAdditionalThinSliceSeries(iStudyInfo, iDataInfoNode).isEmpty();
    }

    private static List<ISeriesInfo> hasAdditionalThinSliceSeries(IStudyInfo iStudyInfo, IDataInfoNode iDataInfoNode) {
        if (iDataInfoNode == null) {
            return Collections.emptyList();
        }
        try {
            IPersistantFilter iPersistantFilter = FilterUtilities.getStudyForUID((String)iStudyInfo.getStudyUID());
            iPersistantFilter.setExpandLevel(Level.Series);
            List list = DataInfoUtilities.getLevel((IDataInfo)FilterHelper.performSyncSearch((IPersistantFilter)iPersistantFilter, (IDataInfoSource)iDataInfoNode), ISeriesInfo.class);
            List list2 = DataInfoUtilities.getLevel((IDataInfo)iStudyInfo, ISeriesInfo.class);
            Set set = list2.stream().map(iSeriesInfo -> iSeriesInfo.getSeriesUID()).collect(Collectors.toSet());
            list.removeIf(iSeriesInfo -> set.contains(iSeriesInfo.getSeriesUID()));
            return list;
        }
        catch (Exception exception) {
            logger.error("Thin slice archive search failed", (Throwable)exception);
            Message.warning((Object)Messages.getString("ImpaxEECycleListProvider.ThinSliceSearchFailed"));
            return Collections.emptyList();
        }
    }

    static boolean checkMemory(List<IObjectInfo> list) {
        if (Product.isCDViewer()) {
            return false;
        }
        int n = list.size();
        long l = dm.getRequiredMemory(n);
        if (AVAILABLE_MEMORY < l) {
            logger.info("Not enough memory for patient loading.Required:" + l);
            return true;
        }
        return false;
    }

    public void blankDisplay() {
        DataSelectionManager.getInstance().setCurrentPatient(null);
        if (JVision2.getMainFrame() != null) {
            JVision2.getMainFrame().clearAllDisplays();
        }
    }

    public List<Window> getAllWindows() {
        if (JVision2.getMainFrame() == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(JVision2.getMainFrame());
    }

    public ICycleListPreferences getCycleListPreferences() {
        return this.prefs;
    }

    public boolean markPatientsMerged(ReferencedObjectUtilities.ReferencedResult referencedResult) {
        Object object2;
        if (referencedResult.getMergedDataCount() > 1) {
            JOptionPane.showMessageDialog(null, Messages.getString("TemporaryMergeSession.MultipleMerge.Message"), Messages.getString("TemporaryMergeSession.MultipleMerge.Title"), 0);
            return false;
        }
        List list = DataInfoUtilities.mergeDuplicates((List)referencedResult.toOpen);
        List list2 = DataInfoUtilities.getLevel((Collection)list, IPatientInfo.class);
        String string = referencedResult.getMergedData(0).getObject().getTreeParent().getTreeParent().getTreeParent().getKey();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : list2) {
            if (!object2.getKey().equals(string)) {
                arrayList.add(object2.getKey());
            }
            SimplePatient simplePatient = new SimplePatient(object2);
            if (object2.getKey().equals(string)) {
                string2 = simplePatient.toString();
            }
            stringBuilder.append("- ").append(simplePatient.toString()).append('\n');
        }
        object2 = MessageFormat.format(Messages.getString("TemporaryMergeSession"), stringBuilder.toString(), string2);
        int n = JOptionPane.showConfirmDialog(null, object2, Messages.getString("TemporaryMergePatientsAction_TemporaryPatientMerge"), 2, 2, IconUtil.getWarningIcon((int)54));
        if (n == 2) {
            return false;
        }
        dm.markTemporaryMerged(string, arrayList);
        Collections.sort(referencedResult.toOpen, new MergedPatientSorter(string));
        return true;
    }

    public void addCycleListProviderListener(ICycleListProviderListener iCycleListProviderListener) {
        if (iCycleListProviderListener != null && !this.listeners.contains(iCycleListProviderListener)) {
            this.listeners.add(iCycleListProviderListener);
        }
    }

    protected void fireDisplayedStudiesChanged(IStudyInfo[] iStudyInfoArray, IStudyContainer iStudyContainer) {
        IStudyInfo iStudyInfo = null;
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        String string = null;
        if (iStudyContainer != null) {
            iStudyInfo = (IStudyInfo)iStudyContainer.getBaseStudy().getQueryObject();
            int n = 0;
            while (n < iStudyContainer.getRelevantPriorCount()) {
                hashSet.add(iStudyContainer.getPriorInfo(n).getStudyUID());
                ++n;
            }
            string = iStudyContainer.getAndResetContextID();
            bl = iStudyContainer.isLoadedFromRIS();
        }
        for (ICycleListProviderListener iCycleListProviderListener : this.listeners) {
            iCycleListProviderListener.displayedStudiesChanged(iStudyInfo, iStudyInfoArray, hashSet, iStudyContainer == null ? null : string, bl);
        }
    }

    protected void fireStudiesRemoved(IStudyInfo[] iStudyInfoArray, boolean bl) {
        for (ICycleListProviderListener iCycleListProviderListener : this.listeners) {
            iCycleListProviderListener.studiesRemoved(iStudyInfoArray, bl);
        }
    }

    protected void fireStudiesAdded(IStudyInfo[] iStudyInfoArray) {
        for (ICycleListProviderListener iCycleListProviderListener : this.listeners) {
            iCycleListProviderListener.studiesAdded(iStudyInfoArray);
        }
    }

    protected void firePatientRemoved(IPatientInfo iPatientInfo, IStudyInfo[] iStudyInfoArray, boolean bl) {
        for (ICycleListProviderListener iCycleListProviderListener : this.listeners) {
            iCycleListProviderListener.patientRemoved(iPatientInfo, iStudyInfoArray, bl);
        }
    }

    public final void setTextAreaSyncEnabled(boolean bl) {
        this.syncTextArea = bl;
    }

    public void syncTextArea() {
        this.syncTextArea(this.getDisplayedStudies(), Collections.emptyList(), false);
    }

    private void syncTextArea(IStudyInfo[] iStudyInfoArray, IStudyContainer iStudyContainer) {
        ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>();
        if (iStudyContainer != null) {
            int n = 0;
            while (n < iStudyContainer.getRelevantPriorCount()) {
                arrayList.add(iStudyContainer.getPriorInfo(n));
                ++n;
            }
        }
        this.syncTextArea(iStudyInfoArray, arrayList, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncTextArea(IStudyInfo[] iStudyInfoArray, List<IStudyInfo> list, boolean bl) {
        Object object = this.syncMonitor;
        synchronized (object) {
            if (iStudyInfoArray == null || iStudyInfoArray.length == 0) {
                IEvent iEvent = this.eventEngine.createInternalEvent(Base.EVENT_ID_TEXTAREA_INIT_REQUEST);
                iEvent.setDestination(null, "textarea");
                iEvent.setActionInfo(ActionInfo.SINGLE);
                iEvent.setPayload((Object)new StudyList(Collections.emptyList()));
                this.eventEngine.sendEvent(iEvent);
                return;
            }
            if (iStudyInfoArray[0].getKey().equals(this.willBeSynchronizedUID)) {
                if (bl) {
                    this.willBeSynchronizedUID = null;
                } else {
                    return;
                }
            }
            logger.debug("Synchronize textarea using study(1/" + iStudyInfoArray.length + "): " + iStudyInfoArray[0].getStudyUID());
            IEvent iEvent = this.eventEngine.createInternalEvent(Base.EVENT_ID_TEXTAREA_INIT_REQUEST);
            iEvent.setDestination(null, "textarea");
            iEvent.setActionInfo(ActionInfo.SINGLE);
            iEvent.setPayload((Object)new StudyList(this.cloneAndCut(Arrays.asList(iStudyInfoArray)), this.cloneAndCut(list)));
            this.eventEngine.sendEvent(iEvent);
        }
    }

    private List<IStudyInfo> cloneAndCut(List<IStudyInfo> list) {
        List list2 = DataInfoUtilities.getLevel(list, ISeriesInfo.class);
        return DataInfoUtilities.getLevel((Collection)DataInfoUtilities.cloneAndCutBelow((Collection)list2), IStudyInfo.class);
    }

    private class LoadRunnable
    implements Runnable {
        private List<ILoadCommand> commands;
        private boolean displayFirstPatient;

        public LoadRunnable(List<ILoadCommand> list, boolean bl) {
            this.commands = list;
            this.displayFirstPatient = bl;
        }

        @Override
        public void run() {
            try {
                ImpaxEECycleListProvider.this.showActivityIndicator();
                boolean bl = true;
                if (!this.displayFirstPatient && !EventQueue.isDispatchThread()) {
                    Thread.currentThread().setPriority(1);
                }
                for (ILoadCommand iLoadCommand : this.commands) {
                    iLoadCommand.performTillState(ILoadCommand.LoadState.Expanded);
                    if (iLoadCommand.hasError()) {
                        MainFrame2.getFrames()[0].toFront();
                        MainFrame2.getFrames()[0].requestFocus();
                        Object object = iLoadCommand.getLastError();
                        String string = object.toString();
                        if (object instanceof Throwable) {
                            string = ((Throwable)object).getLocalizedMessage();
                        }
                        JOptionPane.showMessageDialog(MainFrame2.getFrames()[0], string);
                        return;
                    }
                    iLoadCommand.performAllSteps();
                    if (this.displayFirstPatient && bl) {
                        iLoadCommand.display();
                    } else {
                        iLoadCommand.addToImageArea();
                    }
                    bl = false;
                }
            }
            finally {
                ImpaxEECycleListProvider.this.hideActivityIndicator();
            }
        }
    }

    private static class MergedPatientSorter
    implements Comparator<IDataInfo> {
        private String patientKey;

        public MergedPatientSorter(String string) {
            this.patientKey = string;
        }

        @Override
        public int compare(IDataInfo iDataInfo, IDataInfo iDataInfo2) {
            boolean bl;
            boolean bl2 = PatientKeyUtils.generatePatientKey((Attributes)iDataInfo.getAttributes()).equals(this.patientKey);
            if (bl2 ^ (bl = PatientKeyUtils.generatePatientKey((Attributes)iDataInfo2.getAttributes()).equals(this.patientKey))) {
                return 0;
            }
            return bl2 ? -1 : 1;
        }
    }

    private class PatientAndHangingDataSelectionListener
    extends DataSelectionListenerAdapter {
        private PatientAndHangingDataSelectionListener() {
        }

        public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
            IHanging iHanging = dataSelectionManager.getActiveHanging();
            IStudyData iStudyData = null;
            IStudyContainer iStudyContainer = null;
            if (iHanging != null && (iStudyContainer = iHanging.getStudyContainer()) != null) {
                iStudyData = iStudyContainer.getBaseStudy();
            }
            if (iStudyData == null) {
                ImpaxEECycleListProvider.this.handleDisplayedStudiesChanged(null, null, null);
            } else if (ImpaxEECycleListProvider.this.syncTextArea) {
                ImpaxEECycleListProvider.this.syncTextArea(ImpaxEECycleListProvider.this.getDisplayedStudies(), iStudyContainer);
            }
        }

        public void newActiveStudySelected(IStudyData iStudyData) {
            IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
            if (iHanging != null) {
                if (iHanging instanceof IMultiplePatientHanging) {
                    ImpaxEECycleListProvider.this.handleDisplayedStudiesChanged(new IStudyInfo[]{(IStudyInfo)iStudyData.getQueryObject()}, iStudyData, null);
                } else {
                    ImpaxEECycleListProvider.this.handleDisplayedStudiesChanged(ImpaxEECycleListProvider.this.getDisplayedStudies(), iStudyData, iHanging.getStudyContainer());
                }
            } else {
                ImpaxEECycleListProvider.this.handleDisplayedStudiesChanged(ImpaxEECycleListProvider.this.getDisplayedStudies(), iStudyData, null);
            }
        }
    }

    private class RemovingDataManagerListener
    extends DataManagerListenerAdapter
    implements IDisplaySetListener {
        private RemovingDataManagerListener() {
        }

        public void patientRemoved(IPatientRepresentation iPatientRepresentation, boolean bl) {
            logger.debug("Handling patient removal notification (key: " + ImpaxEECycleListProvider.this.getLoggingKey(iPatientRepresentation.getPatientData().getQueryObject()) + ")");
            Collection collection = iPatientRepresentation.getPatientData().getStudies();
            ImpaxEECycleListProvider.this.handlePatientRemoved(iPatientRepresentation.getPatientData(), collection, bl);
        }

        public void studyAdded(IStudyData iStudyData) {
            ImpaxEECycleListProvider.this.handleStudiesAdded(new IStudyData[]{iStudyData});
        }

        public void studyRemoved(IStudyData iStudyData, boolean bl) {
            logger.info("Handling study removal (" + iStudyData.getStudyInstanceUID() + ")");
            ImpaxEECycleListProvider.this.handleStudiesRemoved(new IStudyData[]{iStudyData}, bl);
        }

        public void displaySetAdded(IPatientRepresentation iPatientRepresentation, List<IDisplaySet> list, SplitAndSortChangeType splitAndSortChangeType) {
        }

        public void displaySetsRemoved(IDisplaySet[] iDisplaySetArray, SplitAndSortChangeType splitAndSortChangeType) {
        }

        public void repaintDisplaySets() {
        }
    }
}

