/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.cycling;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.swing.util.FocusUtil;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.glue.cycling.Messages;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.lta.base.LTAComponentFactory;
import com.agfa.pacs.listtext.lta.base.LTAUtil;
import com.agfa.pacs.listtext.lta.util.referencedobject.IUnresolvedReferencedObjectHandler;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ImpaxEEUnresolvedReferencedObjectHandler
implements IUnresolvedReferencedObjectHandler {
    private static final int DETAILS_DEFAULT_MARGIN = LTAComponentFactory.instance.scaleInt(5);
    private static final int DETAILS_MAXIMUM_HEIGHT = LTAComponentFactory.instance.scaleInt(280);

    public boolean isUnresolvedReferencedObjectsAcceptable(final String string, final ReferringObjectType referringObjectType, final int n, final Collection<ReferencedSOP> collection) {
        if (Product.isHeadless()) {
            return false;
        }
        final String string2 = referringObjectType == ReferringObjectType.SESSION ? "Session" : "KeyObject";
        final ResultHolder resultHolder = new ResultHolder();
        EventUtil.invokeSynchronous((Runnable)new Runnable(){

            @Override
            public void run() {
                int n4;
                int n2;
                Object[] objectArray;
                if (referringObjectType == ReferringObjectType.SESSION && n == 0) {
                    objectArray = string;
                    n2 = -1;
                    n4 = 0;
                } else {
                    JPanel jPanel = LTAComponentFactory.instance.createPanel((LayoutManager)new GridBagLayout());
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    JLabel jLabel = LTAComponentFactory.instance.createLabel(ImpaxEEUnresolvedReferencedObjectHandler.compileReferenceObjectsList(collection));
                    jLabel.setBorder(LTAComponentFactory.instance.createEmptyBorder(DETAILS_DEFAULT_MARGIN));
                    JScrollPane jScrollPane = LTAComponentFactory.instance.createScrollPane((Component)jLabel, Integer.valueOf(20), Integer.valueOf(31), null, null);
                    jScrollPane.setVisible(false);
                    Dimension dimension = jScrollPane.getPreferredSize();
                    if (dimension.height > DETAILS_MAXIMUM_HEIGHT) {
                        dimension.height = DETAILS_MAXIMUM_HEIGHT;
                        jScrollPane.setPreferredSize(dimension);
                    }
                    gridBagConstraints.gridy = 0;
                    gridBagConstraints.weightx = 1.0;
                    jPanel.add((Component)LTAComponentFactory.instance.createLabel(null), gridBagConstraints);
                    gridBagConstraints.weightx = 0.0;
                    jPanel.add((Component)LTAComponentFactory.instance.createButton((Action)new ToggleVisibilityAction(jScrollPane)), gridBagConstraints);
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = 1;
                    gridBagConstraints.gridwidth = 2;
                    gridBagConstraints.fill = 2;
                    jPanel.add((Component)jScrollPane, gridBagConstraints);
                    objectArray = new Object[]{string, jPanel, Messages.getString("UnresolvedReferencedObjects.ErrorDialog.Question.Proceed")};
                    n2 = 0;
                    n4 = 2;
                }
                FocusUtil.activateWindow((Window)LTAUtil.getMainWindow(), (FocusUtil.WindowAction)FocusUtil.WindowAction.ToFrontAndRequestFocus);
                int n3 = JOptionPane.showConfirmDialog(LTAUtil.getMainWindow(), objectArray, Messages.getString("UnresolvedReferencedObjects.ErrorDialog.Title." + string2), n2, n4);
                resultHolder.setResult(n2 == 0 && n3 == 0);
            }
        });
        return resultHolder.getResult();
    }

    public static String compileReferenceObjectsList(Collection<ReferencedSOP> collection) {
        List list;
        HashMap<Object, ArrayList<String>> hashMap = new HashMap<Object, ArrayList<String>>();
        for (ReferencedSOP referencedSOP : collection) {
            String string = referencedSOP.getSeries().getSeriesInstanceUID();
            list = (ArrayList<String>)hashMap.get(string);
            if (list == null) {
                list = new ArrayList<String>(2);
                hashMap.put(string, (ArrayList<String>)list);
            }
            list.add(referencedSOP.getSOPInstanceUID());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(Messages.getString("UnresolvedReferencedObjects.ErrorDialog.Details.Header"));
        stringBuilder.append(":<ul>");
        for (Map.Entry entry : hashMap.entrySet()) {
            stringBuilder.append("<li>");
            stringBuilder.append(MessageFormat.format(Messages.getString("UnresolvedReferencedObjects.ErrorDialog.Details.Series"), entry.getKey()));
            list = (List)entry.getValue();
            if (list.size() > 1) {
                stringBuilder.append(" (");
                stringBuilder.append(MessageFormat.format(Messages.getString("UnresolvedReferencedObjects.ErrorDialog.Details.ObjectCount"), list.size()));
                stringBuilder.append(')');
            }
            stringBuilder.append("<ul>");
            for (String string : list) {
                stringBuilder.append("<li>");
                stringBuilder.append(MessageFormat.format(Messages.getString("UnresolvedReferencedObjects.ErrorDialog.Details.Object"), string));
                stringBuilder.append("</li>");
            }
            stringBuilder.append("</li>");
        }
        stringBuilder.append("</ul></html>");
        return stringBuilder.toString();
    }

    private static class ResultHolder {
        private volatile boolean result;

        private ResultHolder() {
        }

        boolean getResult() {
            return this.result;
        }

        void setResult(boolean bl) {
            this.result = bl;
        }
    }

    private static class ToggleVisibilityAction
    extends AbstractAction {
        private final Component component;

        ToggleVisibilityAction(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("Component must not be null.");
            }
            this.component = component;
            this.updateActionName();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.component.setVisible(!this.component.isVisible());
            this.updateActionName();
            this.packOwnerWindow();
        }

        private void updateActionName() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Messages.getString("UnresolvedReferencedObjects.ErrorDialog.Details.Button"));
            stringBuilder.append(' ');
            if (this.component.isVisible()) {
                stringBuilder.append("<<");
            } else {
                stringBuilder.append(">>");
            }
            this.putValue("Name", stringBuilder.toString());
        }

        private void packOwnerWindow() {
            Window window = SwingUtilities2.windowForComponent((Component)this.component);
            if (window != null) {
                window.pack();
            }
        }
    }
}

