/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.cycling;

import com.agfa.pacs.base.swing.util.FocusUtil;
import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.hw.manager.DicomDataRequest;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.WaitDicomDataFinished;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.agfa.pacs.data.shared.hw.DicomRetrieverProviderFactory;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.hw.IDicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomRetriever;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.instanceinfo.impl.IMPAXEEWADOInstanceInfo;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataProviderIdentifier;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.impaxee.PerformanceProfiler;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.HangingEvaluation;
import com.agfa.pacs.impaxee.glue.cycling.ImpaxEECycleListProvider;
import com.agfa.pacs.impaxee.glue.cycling.Messages;
import com.agfa.pacs.impaxee.glue.cycling.OrigSourceObjectInfo;
import com.agfa.pacs.impaxee.glue.cycling.PreLoadDicomDataListener;
import com.agfa.pacs.impaxee.glue.data.AbstractImageObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEPatientData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEESeriesData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEStudyContainer;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEStudyData;
import com.agfa.pacs.impaxee.glue.data.composite.CompositeObjectDataFactoryProvider;
import com.agfa.pacs.impaxee.glue.data.composite.ICompositeObjectDataFactory;
import com.agfa.pacs.impaxee.hanging.HangingRuntimeManager;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.impl.HangingCaseDisplay;
import com.agfa.pacs.impaxee.hanging.impl.PatientRepresentationFactory;
import com.agfa.pacs.impaxee.sessions.SessionBuilder;
import com.agfa.pacs.impaxee.splitsort.ReverseStudyDateComparator;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeSet;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.cycling.CycleListProviderFactory;
import com.agfa.pacs.listtext.cycling.ICycleListProvider;
import com.agfa.pacs.listtext.cycling.ILoadCommand;
import com.agfa.pacs.listtext.cycling.LoadContext;
import com.agfa.pacs.listtext.cycling.RelevancyManager;
import com.agfa.pacs.listtext.cycling.prefs.ICycleListPreferences;
import com.agfa.pacs.listtext.lta.base.LTAUtil;
import com.agfa.pacs.listtext.lta.priors.IRelevancyListener;
import com.agfa.pacs.listtext.lta.util.Modality;
import com.agfa.pacs.listtext.lta.util.PerformanceUtils;
import com.agfa.pacs.listtext.lta.util.referencedobject.IReferencedObjectProvider;
import com.agfa.pacs.listtext.lta.util.referencedobject.InvalidSessionLoadAbortion;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObjectProviderFactory;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObjectUtilities;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencesNotFoundException;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.agfa.pacs.tools.IDisposable;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.dcm4che3.data.Attributes;

public class LoadCommand
implements ILoadCommand {
    private static final ALogger LOGGER = ALogger.getLogger(LoadCommand.class);
    private static final long IMPLICIT_VALIDITY_DURATION = 5000L;
    private static final PerformanceProfiler profiler = PerformanceProfiler.getInstance();
    private static final ICycleListProvider cycleList = CycleListProviderFactory.getInstance().getCycleListProvider();
    private static final DataManager dm = DataManager.getInstance();
    private static final IDicomCache dicomCache = DicomCacheFactory.getInstance().getDicomCache();
    private static final DataSelectionManager dsm = DataSelectionManager.getInstance();
    private static final ICycleListPreferences preferences = ImpaxEECycleListProvider.getInstance().getCycleListPreferences();
    private Collection<? extends IDataInfo> data2load;
    private boolean loadPriors;
    private LoadContext context;
    private final boolean interactive;
    private final boolean loadAsMainStudy;
    private boolean shouldBePrefetched = false;
    private int hashCode;
    private long timestampOfExpanding = -1L;
    private boolean ignorePrefLoadingOfKeyImages = false;
    private Exception lastException = null;
    private String lastErrorMessage = null;
    private List<List<? extends IDataInfo>> resolvedReferences;
    private boolean temporaryMergedSession = false;
    private List<IObjectInfo> objects;
    private boolean hasUnreportedStudies = false;
    private List<IObjectInfo> preLoadSessionObjects = new ArrayList<IObjectInfo>(8);
    private List<IObjectInfo> preLoadKOObjects = new ArrayList<IObjectInfo>(8);
    private List<IObjectInfo> preLoadPresentationObjects = new ArrayList<IObjectInfo>();
    private Map<String, IImageObjectData> objectMap = new HashMap<String, IImageObjectData>(256);
    private Map<String, ISeriesData> sequenceMap = new HashMap<String, ISeriesData>(64);
    private WaitDicomDataFinished waitForHeaders = new WaitDicomDataFinished();
    private final Map<IObjectInfo, ICompositeObjectDataFactory> preLoadCompositeObjects = new HashMap<IObjectInfo, ICompositeObjectDataFactory>();
    private volatile ILoadCommand.LoadState state = ILoadCommand.LoadState.Initiated;
    private int numberSupressedDocuments = 0;
    private Set<String> sessionBaseStudies = new HashSet<String>();
    private volatile boolean canceled = false;
    private Map<String, PreloadPatientResult> patients = new LinkedHashMap<String, PreloadPatientResult>();
    private BlockingQueue<Runnable> sessionQueue = new LinkedBlockingQueue<Runnable>();
    private SessionBuilder lastSession = null;
    private Map<String, List<IStudyInfo>> cachedPriors = new HashMap<String, List<IStudyInfo>>();

    public static List<ILoadCommand> createLoadCommands(List<? extends IDataInfo> list, boolean bl, boolean bl2, LoadContext loadContext) {
        ArrayList<ILoadCommand> arrayList = new ArrayList<ILoadCommand>();
        list = DataInfoUtilities.cloneData(list);
        List list2 = DataInfoUtilities.getLevel((Collection)list, (Level)Level.Patient);
        for (IPatientInfo iPatientInfo : list2) {
            List list3 = DataInfoUtilities.extractChildrenBelongingToParent((IDataInfo)iPatientInfo, (List)list);
            list3 = DataInfoUtilities.getLevel((Collection)list3, IStudyInfo.class);
            LoadCommand loadCommand = new LoadCommand(list3, bl, true, bl2, false, loadContext);
            arrayList.add(loadCommand);
        }
        return arrayList;
    }

    public static LoadCommand createNonInteractiveLoadCommand(Collection<? extends IDataInfo> collection) {
        return new LoadCommand(collection, false, false, false, false, null);
    }

    public static LoadCommand createLoadCommandForPrior(IStudyInfo iStudyInfo, boolean bl) {
        return new LoadCommand(Collections.singletonList(iStudyInfo), false, false, bl, false, null);
    }

    public static LoadCommand createLoadCommandForCompleteStudy(IStudyInfo iStudyInfo) {
        return new LoadCommand(Collections.singletonList(iStudyInfo), false, false, false, true, null);
    }

    private LoadCommand(Collection<? extends IDataInfo> collection, boolean bl, boolean bl2, boolean bl3, boolean bl4, LoadContext loadContext) {
        this.data2load = collection;
        this.loadAsMainStudy = bl2;
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IDataInfo object : collection) {
            arrayList.add(object.getKey());
            if (this.shouldBePrefetched) continue;
            if (object instanceof IStudyInfo) {
                String string = DicomUtils.getModalitiesInStudiesAsString((Attributes)object.getAttributes(), (boolean)true, (boolean)true);
                if (StringUtils.isEmpty((CharSequence)string) || !string.contains("CT") && !string.contains("MR") && !string.contains("PT") && !string.equals("KO")) continue;
                this.shouldBePrefetched = true;
                continue;
            }
            this.shouldBePrefetched = true;
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            hashCodeBuilder.append((Object)string);
        }
        hashCodeBuilder.append(bl);
        this.hashCode = hashCodeBuilder.toHashCode();
        this.loadPriors = bl;
        this.interactive = bl3;
        this.ignorePrefLoadingOfKeyImages = bl4;
        this.context = loadContext;
    }

    public String getID() {
        return this.context != null ? this.context.getContextID() : null;
    }

    public String toString() {
        if (this.data2load != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('{');
            for (IDataInfo iDataInfo : this.data2load) {
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(iDataInfo.getKey());
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
        return super.toString();
    }

    public boolean hasError() {
        return this.lastErrorMessage != null || this.lastException != null;
    }

    public Object getLastError() {
        if (this.lastException != null) {
            return this.lastException;
        }
        return this.lastErrorMessage;
    }

    public boolean hasUnreportedStudies() {
        if (this.state.compareTo((Enum)ILoadCommand.LoadState.ResolveRefs) < 0) {
            throw new IllegalStateException();
        }
        return this.hasUnreportedStudies;
    }

    public List<IStudyData> getStudies() {
        ArrayList<IStudyData> arrayList = new ArrayList<IStudyData>();
        for (PreloadPatientResult preloadPatientResult : this.patients.values()) {
            arrayList.addAll(preloadPatientResult.patient.getPatientData().getStudies());
        }
        return arrayList;
    }

    public boolean hasMultiplePatients() {
        if (this.patients != null) {
            return this.patients.size() > 1;
        }
        if (this.resolvedReferences != null) {
            return !this.temporaryMergedSession && this.resolvedReferences.size() > 1;
        }
        return false;
    }

    public boolean performNextStep() {
        long l = System.currentTimeMillis();
        try {
            switch (this.state) {
                case Initiated: {
                    this.state = ILoadCommand.LoadState.ResolveRefs;
                    this.resolveReferences();
                    break;
                }
                case ResolveRefs: {
                    this.state = ILoadCommand.LoadState.Expanded;
                    this.expandData();
                    this.registerStudies();
                    break;
                }
                case Expanded: {
                    this.state = ILoadCommand.LoadState.Preloaded;
                    this.preload();
                    break;
                }
                case Preloaded: {
                    this.state = ILoadCommand.LoadState.Done;
                    this.loadPrior();
                    break;
                }
                case PriorsLoaded: {
                    this.state = ILoadCommand.LoadState.Done;
                    break;
                }
                case Done: 
                case Error: 
                case Canceled: {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error during load", (Throwable)exception);
            this.state = ILoadCommand.LoadState.Error;
        }
        LOGGER.info("Performing step {} took {} ms", (Object)this.state, (Object)(System.currentTimeMillis() - l));
        return true;
    }

    private void registerStudies() {
        for (IStudyInfo iStudyInfo : DataInfoUtilities.getLevel(this.objects, IStudyInfo.class)) {
            dicomCache.registerStudyUsage(iStudyInfo.getStudyUID(), (IDisposable)iStudyInfo);
        }
    }

    private void checkAndExpandThinSliceArchive(List<IObjectInfo> list) {
        List list2 = DataInfoUtilities.getLevel(list, IStudyInfo.class);
        for (IStudyInfo iStudyInfo : list2) {
            IDataProviderIdentifier iDataProviderIdentifier = iStudyInfo.getSource().getIdentifier();
            String string = iDataProviderIdentifier.getPropertiesOwner().properties().getProperty("thinSliceArchive");
            if (string == null) continue;
            boolean bl = true;
            for (ISeriesInfo iSeriesInfo : iStudyInfo.getSeries()) {
                bl &= ((Boolean)iSeriesInfo.getAttributes().getProperty("ThinArchive", (Object)Boolean.FALSE)).booleanValue();
            }
            if (bl) continue;
            list.addAll(ImpaxEECycleListProvider.expandThinSliceArchive(iStudyInfo, Base.getConfiguredDataInfoNodeByName((String)string)));
        }
    }

    private void expandData() {
        for (List<? extends IDataInfo> list : this.resolvedReferences) {
            ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>(256);
            if (this.isPreferredLoadingOfKeyImagesEnabled()) {
                arrayList.addAll(DataInfoUtilities.getLevel(list, IObjectInfo.class));
            } else {
                for (IDataInfo iDataInfo : list) {
                    if (iDataInfo.getHierarchyLevel() == Level.Study) {
                        arrayList.addAll(PerformanceUtils.getObjectLevel((IStudyInfo)((IStudyInfo)iDataInfo)));
                        continue;
                    }
                    if (iDataInfo.getHierarchyLevel() == Level.Object) {
                        arrayList.add((IObjectInfo)iDataInfo);
                        continue;
                    }
                    arrayList.addAll(DataInfoUtilities.getLevel((IDataInfo)iDataInfo, (Level)Level.Object));
                }
            }
            if (Base.isUsingThinArchive() && this.loadAsMainStudy) {
                this.checkAndExpandThinSliceArchive(arrayList);
            }
            if (ImpaxEECycleListProvider.checkMemory(arrayList)) {
                this.state = ILoadCommand.LoadState.Error;
                this.lastErrorMessage = Messages.getString("ImpaxEECycleListProvider.TooMuchMemory");
                this.cleanup();
                return;
            }
            if (this.objects == null) {
                this.objects = arrayList;
                continue;
            }
            this.objects.addAll(arrayList);
        }
        this.resolvedReferences = null;
        this.timestampOfExpanding = System.currentTimeMillis();
    }

    public void cleanUpPreload() {
        this.patients.clear();
        this.data2load = null;
        this.sequenceMap.clear();
        this.objectMap.clear();
        this.preLoadCompositeObjects.clear();
        this.preLoadKOObjects.clear();
        this.preLoadSessionObjects.clear();
        this.lastSession = null;
        this.context = null;
    }

    public void cleanup() {
        this.cleanUpPreload();
        this.objects = null;
        this.resolvedReferences = null;
        this.cachedPriors = null;
        this.state = ILoadCommand.LoadState.Error;
    }

    private void evaluateHPs() {
        for (PreloadPatientResult preloadPatientResult : this.patients.values()) {
            preloadPatientResult.hp = HangingRuntimeManager.getInstance().triggerFirstHPEvaluation(preloadPatientResult.patient);
        }
    }

    private int getNumberOfAvailableImages(IStudyInfo iStudyInfo) {
        if (!this.isPreferredLoadingOfKeyImagesEnabled()) {
            return -1;
        }
        if (this.data2load != null) {
            List list = DataInfoUtilities.getLevel(this.data2load, IStudyInfo.class);
            for (ISeriesInfo iSeriesInfo : list) {
                if (!iSeriesInfo.equalsKey((IDataInfo)iStudyInfo)) continue;
                iStudyInfo = iSeriesInfo;
                break;
            }
        }
        int n = 0;
        for (ISeriesInfo iSeriesInfo : iStudyInfo.getSeries()) {
            String string = iSeriesInfo.getString(524384);
            if (Modality.SR.dicom().equals(string) || Modality.PR.dicom().equals(string) || Modality.KO.dicom().equals(string)) continue;
            if (iSeriesInfo.containsValue(2101769)) {
                n += iSeriesInfo.getInt(2101769);
                continue;
            }
            n += iSeriesInfo.children().size();
        }
        return n;
    }

    private IPatientData checkCreatePatient(IPatientInfo iPatientInfo) {
        PreloadPatientResult preloadPatientResult = this.patients.get(iPatientInfo.getKey());
        if (preloadPatientResult == null) {
            preloadPatientResult = new PreloadPatientResult(iPatientInfo);
            this.patients.put(iPatientInfo.getKey(), preloadPatientResult);
        }
        return preloadPatientResult.patient.getPatientData();
    }

    void addObject(IObjectInfo iObjectInfo, IImageObjectData iImageObjectData) {
        if (iImageObjectData != null) {
            iImageObjectData = this.getOrCreateSeriesData(iObjectInfo).addObject(iImageObjectData);
        }
        this.objectMap.put(iObjectInfo.getSOPInstanceUID(), iImageObjectData);
    }

    private ISeriesData getOrCreateSeriesData(IObjectInfo iObjectInfo) {
        ISeriesInfo iSeriesInfo = (ISeriesInfo)iObjectInfo.getTreeParent();
        ISeriesData iSeriesData = this.sequenceMap.get(iSeriesInfo.getKey());
        if (iSeriesData == null) {
            iSeriesData = new ImpaxEESeriesData(iSeriesInfo, false);
            this.sequenceMap.put(iSeriesInfo.getKey(), iSeriesData);
            IStudyInfo iStudyInfo = (IStudyInfo)iSeriesInfo.getTreeParent();
            IPatientInfo iPatientInfo = (IPatientInfo)iStudyInfo.getTreeParent();
            IPatientData iPatientData = this.checkCreatePatient(iPatientInfo);
            IStudyData iStudyData = iPatientData.getStudy(iStudyInfo.getKey());
            if (iStudyData == null) {
                iStudyData = dm.createStudy(iStudyInfo, iPatientData, this.getNumberOfAvailableImages(iStudyInfo), ImpaxEEStudyData.class);
                if (this.context != null && this.context.isBlindReporting()) {
                    ((ImpaxEEStudyData)iStudyData).removeFromStudyMonitoring();
                }
                this.patients.get(iPatientData.getKey()).newStudies.add(iStudyInfo.getKey());
            }
            iSeriesData.setParent(iStudyData);
            iStudyData.addSeries(iSeriesData);
        }
        return iSeriesData;
    }

    void addObjectIfNotAlreadyContained(IObjectInfo iObjectInfo) {
        if (!this.objectMap.containsKey(iObjectInfo.getSOPInstanceUID())) {
            this.addObject(iObjectInfo);
            LOGGER.debug("Added object to load session of complete current study");
        }
    }

    private boolean supressEvidenceDocuments(IObjectInfo iObjectInfo, String string, UIDType uIDType) {
        if (this.context != null && this.context.isBlindReporting()) {
            if (uIDType == UIDType.Image && !UIDUtilities.isType((String)string, (UIDType)UIDType.SecondaryCapture)) {
                return false;
            }
            if (uIDType == UIDType.Presentation || uIDType == UIDType.KeyObject) {
                ++this.numberSupressedDocuments;
                return true;
            }
            if (CompareUtils.equals((Object)iObjectInfo.getString(0x181018), (Object)Product.getProductName()) || CompareUtils.equals((Object)iObjectInfo.getString(528528), (Object)Product.getProductName())) {
                ++this.numberSupressedDocuments;
                return true;
            }
        }
        return false;
    }

    private boolean isPreferredLoadingOfKeyImagesEnabled() {
        return !this.ignorePrefLoadingOfKeyImages && preferences.isPreferredLoadingEnabled();
    }

    IFrameObjectData[] getFramesOfImage(String string) {
        IObjectData iObjectData = (IObjectData)this.objectMap.get(string);
        if (iObjectData instanceof IImageObjectData) {
            return ((IImageObjectData)iObjectData).frames();
        }
        return null;
    }

    private boolean isLoadForProcessingData() {
        return this.context != null && this.context.isLoadForProcessing();
    }

    private String getPreferredHP() {
        return this.context != null ? this.context.getPreferredHP() : null;
    }

    private Object getDropTarget() {
        return this.context != null ? this.context.getDropTarget() : null;
    }

    private void addObject(IObjectInfo iObjectInfo) {
        String string = iObjectInfo.getSOPClassUID();
        UIDType uIDType = UIDUtilities.getBaseType((String)string);
        IPatientData iPatientData = null;
        if (uIDType == null) {
            LOGGER.warn("Ignoring unknown object:{},{}", (Object)iObjectInfo.getKey(), (Object)string);
            return;
        }
        switch (uIDType) {
            case Waveform: {
                if (!UIDUtilities.isType((String)string, (UIDType)UIDType.ECG)) break;
                AbstractImageObjectData abstractImageObjectData = AbstractImageObjectData.createObjectData(iObjectInfo, string, uIDType);
                this.addObject(iObjectInfo, abstractImageObjectData);
                break;
            }
            case Image: 
            case Video: 
            case USVolume: {
                if (UIDUtilities.isType((String)string, (UIDType)UIDType.ForProcessing) == this.isLoadForProcessingData()) {
                    if (this.supressEvidenceDocuments(iObjectInfo, string, uIDType)) {
                        return;
                    }
                    AbstractImageObjectData abstractImageObjectData = AbstractImageObjectData.createObjectData(iObjectInfo, string, uIDType);
                    this.addObject(iObjectInfo, abstractImageObjectData);
                    break;
                }
                LOGGER.debug("Skipping {} image:" + iObjectInfo.getKey(), (Object)(this.isLoadForProcessingData() ? "'for presentation'" : "'for processing'"));
                break;
            }
            case Presentation: {
                if (this.supressEvidenceDocuments(iObjectInfo, string, uIDType)) {
                    return;
                }
                this.preLoadPresentationObjects.add(iObjectInfo);
                break;
            }
            case KeyObject: {
                if (ReferringObjectType.OF_INTEREST.match((IDataInfo)iObjectInfo) || ReferringObjectType.FOR_PRINTING.match((IDataInfo)iObjectInfo) || ReferringObjectType.FOR_CONFERENCE.match((IDataInfo)iObjectInfo)) {
                    if (this.supressEvidenceDocuments(iObjectInfo, string, uIDType)) {
                        return;
                    }
                    this.preLoadKOObjects.add(iObjectInfo);
                    break;
                }
                if (!ReferringObjectType.SESSION.match((IDataInfo)iObjectInfo)) break;
                this.preLoadSessionObjects.add(iObjectInfo);
                break;
            }
            case Composite: {
                iPatientData = this.checkCreatePatient(iObjectInfo.getPatient());
                for (ICompositeObjectDataFactory iCompositeObjectDataFactory : CompositeObjectDataFactoryProvider.getInstance().getFactories()) {
                    if (!iCompositeObjectDataFactory.supportsData(iPatientData, iObjectInfo)) continue;
                    this.preLoadCompositeObjects.put(iObjectInfo, iCompositeObjectDataFactory);
                    break;
                }
                if (iPatientData == null) break;
                iPatientData.addAdditionalObjects(iObjectInfo);
                break;
            }
            case StructuredReport: {
                Attributes attributes = iObjectInfo.getDicomObjectMerged();
                String string2 = attributes.getString(524400);
                if (!StringUtils.containsIgnoreCase((CharSequence)string2, (CharSequence)"AGFA") && !"1.2.840.10008.5.1.4.1.1.88.50".equals(iObjectInfo.getSOPClassUID()) || (iPatientData = this.checkCreatePatient(iObjectInfo.getPatient())) == null) break;
                iPatientData.addAdditionalObjects(iObjectInfo);
            }
        }
    }

    public void preLoadWithFactory(Collection<IObjectInfo> collection, Map<IObjectInfo, ICompositeObjectDataFactory> map) {
        this.preLoadImpl(collection, map);
    }

    private void preLoadSession(Collection<IObjectInfo> collection) {
        ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>();
        IMPAXEEWADOInstanceInfo iMPAXEEWADOInstanceInfo = new IMPAXEEWADOInstanceInfo();
        for (IObjectInfo iObjectInfo : collection) {
            String string = iObjectInfo.getSource().getIdentifier().getType();
            if (string.equals("AGFADICOMWADO")) {
                IPatientData iPatientData = this.checkCreatePatient(iObjectInfo.getPatient());
                PreLoadDicomDataListener preLoadDicomDataListener = new PreLoadDicomDataListener(iObjectInfo, iPatientData, this);
                IDicomRetriever iDicomRetriever = DicomRetrieverProviderFactory.getInstance().getProvider((IInstanceInfo)iMPAXEEWADOInstanceInfo).createDicomRetriever();
                DicomDataRequest dicomDataRequest = new DicomDataRequest((ILoadableInfo)new OrigSourceObjectInfo(iObjectInfo.getTreeParent(), iObjectInfo.getAttributes(), (IInstanceInfo)iMPAXEEWADOInstanceInfo), 0, null);
                dicomDataRequest.setListener((IDicomDataListener)preLoadDicomDataListener);
                iDicomRetriever.process((IDicomDataRequest)dicomDataRequest);
                continue;
            }
            arrayList.add(iObjectInfo);
        }
        if (!arrayList.isEmpty()) {
            this.preLoad(arrayList);
        }
    }

    public void preLoad(Collection<IObjectInfo> collection) {
        this.preLoadImpl(collection, null);
    }

    public void preLoadImpl(Collection<IObjectInfo> collection, Map<IObjectInfo, ICompositeObjectDataFactory> map) {
        IDicomDataRequester iDicomDataRequester = DicomDataRequester.getInstance();
        ArrayList<IDicomDataRequest> arrayList = new ArrayList<IDicomDataRequest>(collection.size());
        for (IObjectInfo iObjectInfo : collection) {
            IDicomDataRequest iDicomDataRequest = iDicomDataRequester.createDicomDataRequest(iObjectInfo, (byte)0);
            IPatientData iPatientData = this.checkCreatePatient(iObjectInfo.getPatient());
            PreLoadDicomDataListener preLoadDicomDataListener = new PreLoadDicomDataListener(iObjectInfo, iPatientData, this);
            if (map != null) {
                preLoadDicomDataListener.setCompositeFactory(map.get(iObjectInfo));
            }
            iDicomDataRequest.setListener(this.waitForHeaders.addListener((IDicomDataListener)preLoadDicomDataListener));
            arrayList.add(iDicomDataRequest);
        }
        if (!collection.isEmpty()) {
            iDicomDataRequester.addRequests(arrayList);
            this.waitForHeaders.waitUntilFinished();
            collection.clear();
        }
    }

    private void preload() {
        List list = DataInfoUtilities.cloneData(this.objects, (boolean)false);
        for (IObjectInfo iObjectInfo : list) {
            this.addObject(iObjectInfo);
        }
        this.preLoadWithFactory(this.preLoadCompositeObjects.keySet(), this.preLoadCompositeObjects);
        this.preLoad(this.preLoadKOObjects);
        this.preLoad(this.preLoadPresentationObjects);
        long l = System.currentTimeMillis();
        this.preLoadSession(this.preLoadSessionObjects);
        LOGGER.info("Session loading:" + (System.currentTimeMillis() - l));
        this.sessionQueue.add(new SessionTerminationElement());
    }

    private List<IStudyData> getBaseStudies(PreloadPatientResult preloadPatientResult) {
        ArrayList<IStudyData> arrayList = new ArrayList<IStudyData>();
        for (String string : preloadPatientResult.newStudies) {
            if (this.sessionBaseStudies.contains(string)) continue;
            arrayList.add(preloadPatientResult.patient.getPatientData().getStudy(string));
        }
        return arrayList;
    }

    private void loadPrior() {
        for (PreloadPatientResult preloadPatientResult : this.patients.values()) {
            if (preloadPatientResult.newStudies.isEmpty()) continue;
            List<IStudyData> list = this.getBaseStudies(preloadPatientResult);
            if (this.context != null && this.context.getExplicitStudyOrdering() != null) {
                Collections.sort(list, new SortByList(this.context.getExplicitStudyOrdering()));
            } else {
                Collections.sort(list, ReverseStudyDateComparator.INSTANCE);
            }
            for (IStudyData iStudyData : list) {
                Object object;
                if (this.loadPriors) {
                    if (this.cachedPriors.containsKey(iStudyData.getKey())) {
                        object = new ImpaxEEStudyContainer(iStudyData, this.getPreferredHP(), this.getID());
                        ((ImpaxEEStudyContainer)((Object)object)).setPriors(DataInfoUtilities.cloneData(this.cachedPriors.get(iStudyData.getKey()), (boolean)this.interactive));
                        this.patients.get(preloadPatientResult.patient.getPatientKey()).addContainer((IStudyContainer)object);
                        continue;
                    }
                    object = new PriorListener(iStudyData);
                    RelevancyManager.getInstance().startSearchRelevant((IRelevancyListener)object, this.getBaseStudyList(list, iStudyData), false);
                    try {
                        boolean bl = ((PriorListener)object).priorSearch.tryAcquire(20L, TimeUnit.SECONDS);
                        if (bl) continue;
                        ((PriorListener)object).relevantFound(preloadPatientResult.patient.getPatientKey(), iStudyData.getKey(), Collections.emptyList());
                        LOGGER.warn("Priors not found in time");
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.warn("Waiting for priors interrupted");
                    }
                    continue;
                }
                if (!this.loadAsMainStudy) continue;
                object = new ImpaxEEStudyContainer(iStudyData, this.getPreferredHP(), this.getID());
                preloadPatientResult.addContainer((IStudyContainer)object);
            }
        }
    }

    private List<IStudyInfo> getBaseStudyList(List<IStudyData> list, IStudyData iStudyData) {
        ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>(list.size());
        arrayList.add((IStudyInfo)iStudyData.getQueryObject());
        for (IStudyData iStudyData2 : list) {
            if (iStudyData2 == iStudyData) continue;
            arrayList.add((IStudyInfo)iStudyData2.getQueryObject());
        }
        return arrayList;
    }

    private Collection<? extends IDataInfo> handleLoadingKOOnly(Collection<? extends IDataInfo> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        if (!this.isPreferredLoadingOfKeyImagesEnabled()) {
            return collection;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (IDataInfo iDataInfo : collection) {
            IReferencedObjectProvider iReferencedObjectProvider;
            if (preferences.matchesPreferablyLoadedType(iDataInfo, iReferencedObjectProvider = ReferencedObjectProviderFactory.getInstance().getSupportedReferencedObjectProvider(iDataInfo.getSource()))) {
                if (Level.Series.compareTo((Enum)iDataInfo.getHierarchyLevel()) > 0) {
                    arrayList.addAll(this.handleLoadingKOOnly(iDataInfo.children()));
                    continue;
                }
                arrayList.add(iDataInfo);
                continue;
            }
            if (Level.Study == iDataInfo.getHierarchyLevel()) {
                arrayList.add(iDataInfo);
                continue;
            }
            if (iReferencedObjectProvider == null || !iReferencedObjectProvider.referencedObjectsAvailable(iDataInfo, Collections.singletonList(ReferringObjectType.PRESENTATION_STATE), false)) continue;
            if (Level.Series.compareTo((Enum)iDataInfo.getHierarchyLevel()) > 0) {
                arrayList2.addAll(this.handleLoadingKOOnly(iDataInfo.children()));
                continue;
            }
            arrayList2.add(iDataInfo);
        }
        if (arrayList.isEmpty()) {
            return collection;
        }
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    private boolean needToCheckPRs(Collection<? extends IDataInfo> collection) {
        for (IDataInfo iDataInfo : collection) {
            if (iDataInfo.getHierarchyLevel() != Level.Study) {
                return true;
            }
            if (!iDataInfo.childrenAvailable()) continue;
            if (iDataInfo.containsValue(2101766)) {
                int n = iDataInfo.getInt(2101766);
                Object[] objectArray = iDataInfo.getAttributes().getStrings(524385);
                if (iDataInfo.children().size() == n || !ArrayUtils.contains((Object[])objectArray, (Object)"PR")) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private List<List<IDataInfo>> handleReferencedObjectsChecked(Collection<? extends IDataInfo> collection) {
        try {
            return this.handleReferencedObjects(collection);
        }
        catch (InvalidSessionLoadAbortion invalidSessionLoadAbortion) {
            if (!this.interactive) {
                this.lastException = invalidSessionLoadAbortion;
            }
            this.state = ILoadCommand.LoadState.Error;
            LOGGER.warn("Session abort", (Throwable)invalidSessionLoadAbortion);
        }
        catch (ReferencesNotFoundException referencesNotFoundException) {
            if (!this.interactive) {
                this.lastException = referencesNotFoundException;
            }
            this.state = ILoadCommand.LoadState.Error;
            LOGGER.warn("References problem", (Throwable)referencesNotFoundException);
        }
        return Collections.emptyList();
    }

    private List<List<IDataInfo>> handleReferencedObjects(Collection<? extends IDataInfo> collection) throws InvalidSessionLoadAbortion, ReferencesNotFoundException {
        ArrayList<List<IDataInfo>> arrayList;
        IDataInfo iDataInfo;
        if (CollectionUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        ArrayList<ReferringObjectType> arrayList2 = new ArrayList<ReferringObjectType>(ReferringObjectType.values().length);
        if (this.isPreferredLoadingOfKeyImagesEnabled()) {
            arrayList2.addAll(preferences.getPreferablyLoadedTypes());
            arrayList2.add(ReferringObjectType.SESSION);
        } else {
            arrayList2.addAll(ReferencedObjectUtilities.getAllTypes());
        }
        Iterator<? extends IDataInfo> iterator = collection.iterator();
        ArrayList arrayList3 = new ArrayList();
        while (iterator.hasNext()) {
            iDataInfo = iterator.next();
            if (!(iDataInfo instanceof IPatientInfo)) continue;
            iterator.remove();
            arrayList3.addAll(DataInfoUtilities.getLevel((IDataInfo)iDataInfo, (Level)Level.Study));
        }
        collection.addAll(arrayList3);
        if (!this.needToCheckPRs(collection)) {
            arrayList2.remove(ReferringObjectType.PRESENTATION_STATE);
        }
        iDataInfo = ReferencedObjectUtilities.getReferencedObjects(collection, arrayList2, (boolean)this.interactive);
        if (this.isPreferredLoadingOfKeyImagesEnabled() && iDataInfo.toOpen.size() == collection.size()) {
            boolean bl = true;
            arrayList = DataInfoUtilities.getLevel(collection, ISeriesInfo.class);
            for (ISeriesInfo object : arrayList) {
                if ("KO".equals(object.getString(524384))) continue;
                bl = false;
                break;
            }
            if (bl) {
                ArrayList arrayList4 = new ArrayList(ReferencedObjectUtilities.getAllTypes());
                arrayList4.removeAll(arrayList2);
                iDataInfo = ReferencedObjectUtilities.getReferencedObjects(collection, arrayList4, (boolean)true);
            }
        }
        if (iDataInfo.containsMergedData()) {
            if (this.interactive && cycleList.markPatientsMerged((ReferencedObjectUtilities.ReferencedResult)iDataInfo)) {
                this.temporaryMergedSession = true;
                List list = DataInfoUtilities.getLevel((Collection)iDataInfo.toOpen, IPatientInfo.class);
                if (list.size() == 1) {
                    return Collections.singletonList(iDataInfo.toOpen);
                }
                arrayList = new ArrayList<List<IDataInfo>>(list.size());
                for (IPatientInfo iPatientInfo : list) {
                    arrayList.add(DataInfoUtilities.extractChildrenBelongingToParent((IDataInfo)iPatientInfo, (List)iDataInfo.toOpen));
                }
                return arrayList;
            }
            if (!this.interactive) {
                this.state = ILoadCommand.LoadState.Error;
            }
            return Collections.emptyList();
        }
        return Collections.singletonList(iDataInfo.toOpen);
    }

    private void resolveReferences() {
        this.resolvedReferences = new ArrayList<List<? extends IDataInfo>>();
        Collection<? extends IDataInfo> collection = this.handleLoadingKOOnly(this.data2load);
        long l = System.currentTimeMillis();
        List<List<IDataInfo>> list = this.handleReferencedObjectsChecked(collection);
        long l2 = System.currentTimeMillis() - l;
        if (l2 > 10L) {
            LOGGER.info("Expanding session/ko took:{}ms", (Object)l2);
        }
        for (List<IDataInfo> list2 : list) {
            if (list2.isEmpty()) continue;
            for (IStudyInfo iStudyInfo : DataInfoUtilities.getLevel(list2, IStudyInfo.class)) {
                profiler.addStudyOpened(iStudyInfo, false);
                String string = iStudyInfo.getString(3276810);
                if ("READ".equals(string)) continue;
                this.hasUnreportedStudies = true;
            }
            this.resolvedReferences.add(list2);
        }
    }

    public void performAllSteps() {
        boolean bl = true;
        while (bl = this.performNextStep()) {
        }
    }

    public void performTillState(ILoadCommand.LoadState loadState) {
        while (this.state.compareTo((Enum)loadState) < 0) {
            if (!this.performNextStep()) break;
        }
    }

    public void addSession(SessionBuilder sessionBuilder) {
        if (this.lastSession == null || this.lastSession.getCreationDateTime().before(sessionBuilder.getCreationDateTime())) {
            this.lastSession = sessionBuilder;
        }
        this.sessionQueue.add((Runnable)sessionBuilder);
        this.sessionBaseStudies.add(sessionBuilder.getDataset().getString(0x20000D));
    }

    public void cancel() {
        if (this.state != ILoadCommand.LoadState.Done && this.state != ILoadCommand.LoadState.Error) {
            LOGGER.info("Job canceled, because of further job:" + this.toString());
            this.canceled = true;
            this.state = ILoadCommand.LoadState.Canceled;
        }
    }

    public void addToImageArea() {
        this.addImpl(false);
    }

    public void display() {
        this.addImpl(true);
    }

    private void addImpl(boolean bl) {
        if (this.state == ILoadCommand.LoadState.Error || this.state == ILoadCommand.LoadState.Canceled) {
            return;
        }
        if (this.state != ILoadCommand.LoadState.Done) {
            this.performAllSteps();
        }
        if (this.state != ILoadCommand.LoadState.Done) {
            throw new IllegalStateException();
        }
        if (this.getPreferredHP() != null) {
            HangingCaseDisplay.prepareWaitForHP();
        }
        if (this.numberSupressedDocuments > 0) {
            LOGGER.info("Evidence objects were supressed:" + this.numberSupressedDocuments);
        }
        if (this.canceled) {
            LOGGER.info("Stop canceled loading task");
            return;
        }
        boolean bl2 = true;
        IDisplaySet iDisplaySet = null;
        for (PreloadPatientResult preloadPatientResult : this.patients.values()) {
            Pair pair = dm.addPatient(preloadPatientResult.patient, preloadPatientResult.patient.getPatientData().getSeries());
            preloadPatientResult.patient = (IPatientRepresentation)pair.getLeft();
            if (bl2 && this.getDropTarget() != null && !((SplitAndSortChangeSet)pair.getRight()).getDisplaySetsAdded().isEmpty()) {
                iDisplaySet = (IDisplaySet)((SplitAndSortChangeSet)pair.getRight()).getDisplaySetsAdded().get(0);
            }
            for (IStudyContainer iStudyContainer : preloadPatientResult.getStudyContainers()) {
                if (preloadPatientResult.patient.hasContainerForStudy(iStudyContainer.getBaseStudy().getKey())) continue;
                preloadPatientResult.patient.addStudyContainer(iStudyContainer);
            }
            if (preloadPatientResult.hp != null) {
                preloadPatientResult.patient.applyHangingProtocol(preloadPatientResult.hp.hp, preloadPatientResult.hp.container);
                HangingRuntimeManager.getInstance().triggerFurtherHPEvaluation(preloadPatientResult.patient, preloadPatientResult.hp);
            }
            bl2 = false;
        }
        this.processSessions();
        if (bl && !this.isEmpty()) {
            if (this.lastSession == null) {
                dsm.displayCurrentPatient(this.patients.values().iterator().next().patient.getPatientKey());
                if (this.getDropTarget() instanceof VisDisplay2 && iDisplaySet != null) {
                    ((VisDisplay2)this.getDropTarget()).initVisDisplay(iDisplaySet, null, true, ActivationMode.MANUAL);
                }
            } else {
                this.lastSession.display();
            }
            FocusUtil.requestFocusAfterImageLoading((Window)JVision2.getMainFrame(), (Window)LTAUtil.getMainWindow());
        }
        this.cleanup();
    }

    private void processSessions() {
        if (!this.sessionQueue.isEmpty()) {
            Thread thread = new Thread(new ProcessSessions());
            thread.start();
        }
    }

    public boolean isEmpty() {
        for (PreloadPatientResult preloadPatientResult : this.patients.values()) {
            if (preloadPatientResult.newStudies.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        return object instanceof LoadCommand && this.hashCode == ((LoadCommand)object).hashCode;
    }

    public boolean isValid() {
        if (this.patients == null || this.state == ILoadCommand.LoadState.Error || this.state == ILoadCommand.LoadState.Canceled) {
            return false;
        }
        if (this.timestampOfExpanding < 0L || this.data2load == null) {
            return true;
        }
        if (System.currentTimeMillis() - this.timestampOfExpanding < 5000L) {
            return true;
        }
        for (IStudyInfo iStudyInfo : DataInfoUtilities.getLevel(this.data2load, IStudyInfo.class)) {
            if (PerformanceUtils.isValid((IStudyInfo)iStudyInfo)) continue;
            return false;
        }
        return true;
    }

    public int getPrefetchState() {
        return this.state.ordinal() * (100 / ILoadCommand.LoadState.Done.ordinal());
    }

    public boolean shouldBePrefetched() {
        return this.shouldBePrefetched;
    }

    private static class PreloadPatientResult {
        public HangingEvaluation hp;
        private IPatientRepresentation patient;
        private List<IStudyContainer> studyContainers = new ArrayList<IStudyContainer>();
        private Set<String> newStudies = new HashSet<String>();

        public PreloadPatientResult(IPatientInfo iPatientInfo) {
            this.patient = PatientRepresentationFactory.getInstance().newPatientRepresentation((IPatientData)new ImpaxEEPatientData(iPatientInfo));
        }

        private synchronized void addContainer(IStudyContainer iStudyContainer) {
            String string = iStudyContainer.getBaseStudy().getStudyInstanceUID();
            for (IStudyContainer iStudyContainer2 : this.studyContainers) {
                if (!iStudyContainer2.getBaseStudy().getStudyInstanceUID().equals(string)) continue;
                return;
            }
            this.studyContainers.add(iStudyContainer);
        }

        private synchronized List<IStudyContainer> getStudyContainers() {
            return new ArrayList<IStudyContainer>(this.studyContainers);
        }
    }

    private class PriorListener
    implements IRelevancyListener {
        private Semaphore priorSearch = new Semaphore(0);
        private IStudyData study;

        private PriorListener(IStudyData iStudyData) {
            this.study = iStudyData;
        }

        public void studiesFound(String string, List<IStudyInfo> list) {
        }

        private List<IStudyInfo> getPriorToPrefetch(List<IStudyInfo> list) {
            if (LoadCommand.this.interactive || list.isEmpty()) {
                return Collections.emptyList();
            }
            if (list.size() == 1) {
                return Collections.singletonList(list.get(0));
            }
            return new ArrayList<IStudyInfo>(list.subList(0, 2));
        }

        public void relevantFound(String string, String string2, List<IStudyInfo> list) {
            if (string2.equals(this.study.getStudyInstanceUID())) {
                ImpaxEEStudyContainer impaxEEStudyContainer = new ImpaxEEStudyContainer(this.study, LoadCommand.this.getPreferredHP(), LoadCommand.this.getID());
                ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>();
                for (IStudyInfo iStudyInfo : this.getPriorToPrefetch(list)) {
                    PerformanceUtils.getObjectLevel((IStudyInfo)iStudyInfo);
                    arrayList.add(iStudyInfo);
                }
                if (!LoadCommand.this.interactive && !arrayList.isEmpty()) {
                    LoadCommand.this.cachedPriors.put(string2, DataInfoUtilities.cloneData(arrayList, (boolean)false));
                }
                impaxEEStudyContainer.setPriors(list);
                ((PreloadPatientResult)LoadCommand.this.patients.get(string)).addContainer((IStudyContainer)impaxEEStudyContainer);
            } else {
                LOGGER.warn("Prior to incorrect base study {} instead of {}", (Object)string2, (Object)this.study.getStudyInstanceUID());
            }
        }

        public void searchFinished(String string, String string2, boolean bl) {
            this.priorSearch.release();
        }
    }

    private class ProcessSessions
    implements Runnable {
        private ProcessSessions() {
        }

        @Override
        public void run() {
            Runnable runnable = null;
            do {
                try {
                    runnable = (Runnable)LoadCommand.this.sessionQueue.take();
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.warn("Error on parsing session", (Throwable)interruptedException);
                }
                if (runnable == null) continue;
                runnable.run();
            } while (!(runnable instanceof SessionTerminationElement));
        }
    }

    private static class SessionTerminationElement
    implements Runnable {
        private SessionTerminationElement() {
        }

        @Override
        public void run() {
        }
    }

    private static class SortByList
    implements Comparator<IStudyData> {
        private List<String> template;

        public SortByList(List<String> list) {
            this.template = list;
        }

        @Override
        public int compare(IStudyData iStudyData, IStudyData iStudyData2) {
            int n = this.template.indexOf(iStudyData.getStudyInstanceUID());
            int n2 = this.template.indexOf(iStudyData2.getStudyInstanceUID());
            return Integer.compare(n, n2);
        }
    }
}

