/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.cycling;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.code.CodeDictionary;
import com.agfa.pacs.data.shared.data.DicomDataListenerAdapter;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.impaxee.glue.cycling.LoadCommand;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEKeyObjectData;
import com.agfa.pacs.impaxee.glue.data.composite.ICompositeObjectData;
import com.agfa.pacs.impaxee.glue.data.composite.ICompositeObjectDataFactory;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.keyimages.KeyImageType;
import com.agfa.pacs.impaxee.sessions.SessionBuilder;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.iod.ps.SoftcopyPresentationStateInformationObject;
import com.agfa.pacs.listtext.dicomobject.sr.content.SRReferencedImage;
import com.agfa.pacs.listtext.lta.util.referencedobject.KeyObjectParser;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObject;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IKeyObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;

public class PreLoadDicomDataListener
extends DicomDataListenerAdapter {
    private static final ALogger LOGGER = ALogger.getLogger(PreLoadDicomDataListener.class);
    private static final IDataInfoNode mpiArchive = Base.getMasterDataNode();
    private IObjectInfo objectInfo;
    private IPatientData patient;
    private Attributes compositeDataset;
    private ICompositeObjectData compositeObjectData;
    private ICompositeObjectDataFactory factory;
    private LoadCommand command;

    public PreLoadDicomDataListener(IObjectInfo iObjectInfo, IPatientData iPatientData, LoadCommand loadCommand) {
        this.objectInfo = iObjectInfo;
        this.patient = iPatientData;
        this.command = loadCommand;
    }

    public void setCompositeFactory(ICompositeObjectDataFactory iCompositeObjectDataFactory) {
        this.factory = iCompositeObjectDataFactory;
    }

    public void dicomDataAvailable(String string, Attributes attributes, boolean bl) {
        String string2 = attributes.getString(524310);
        if (UIDUtilities.isType((String)string2, (UIDType)UIDType.Presentation)) {
            SoftcopyPresentationStateInformationObject softcopyPresentationStateInformationObject = SoftcopyPresentationStateInformationObject.createInstance((Attributes)attributes);
            String string3 = attributes.getString(0x20000D);
            IStudyData iStudyData = this.patient.getStudy(string3);
            if (iStudyData != null) {
                iStudyData.getFramePresentationStateProviderContainer().add(softcopyPresentationStateInformationObject, false);
            }
            return;
        }
        if (UIDUtilities.isType((String)string2, (UIDType)UIDType.KeyObject)) {
            Code code = Code.create((Attributes)attributes, (int)4235331);
            if (CodeDictionary.KeyObjectSelectionDocumentTitle.JVisionSession.equals((Object)code)) {
                String string4 = null;
                IDataInfoSource iDataInfoSource = this.objectInfo.getSource();
                if (iDataInfoSource instanceof IDataInfoNode) {
                    string4 = ((IDataInfoNode)iDataInfoSource).getIdentifier().getName();
                }
                SessionBuilder sessionBuilder = new SessionBuilder(string4, attributes, (IKeyObjectData)new ImpaxEEKeyObjectData(this.objectInfo), mpiArchive != null, this.command.getID());
                this.command.addSession(sessionBuilder);
            } else if (KeyImageType.valueOf((Attributes)attributes) != null) {
                ReferringObject referringObject;
                int n = -1;
                if (code != null && code.getCodingSchemeDesignator() != null && code.getCodingSchemeDesignator().equals(CodeDictionary.TianiKeyObjectSelectionDocumentTitle.ForConference.getCodingSchemeDesignator())) {
                    n = 0;
                }
                Map map = KeyObjectParser.getAllImageReferences((List)KeyObjectParser.getKOReferences((Attributes)attributes));
                Map map2 = KeyObjectParser.getDetailedImageReferences((Attributes)attributes);
                ArrayList<Object> arrayList = new ArrayList<Object>(map.size());
                for (ReferencedSOP referencedSOP : map.values()) {
                    referringObject = this.command.getFramesOfImage(referencedSOP.getSOPInstanceUID());
                    if (referringObject == null) continue;
                    if (((IFrameObjectData[])referringObject).length == 1) {
                        arrayList.add(referringObject[0]);
                        continue;
                    }
                    SRReferencedImage sRReferencedImage = (SRReferencedImage)map2.get(referencedSOP.getSOPInstanceUID());
                    if (sRReferencedImage == null || sRReferencedImage.getReferencedFrameNumbers() == null || sRReferencedImage.getReferencedFrameNumbers().length == 0) {
                        arrayList.addAll(Arrays.asList(referringObject));
                        continue;
                    }
                    Object object = sRReferencedImage.getReferencedFrameNumbers();
                    int n2 = 0;
                    while (n2 < ((Object)object).length) {
                        try {
                            arrayList.add(referringObject[object[n2] + n]);
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Could not find referenced frame:", (Throwable)exception);
                        }
                        ++n2;
                    }
                }
                if (!arrayList.isEmpty()) {
                    try {
                        ReferencedSOP referencedSOP;
                        referencedSOP = KeyImageManager.ofFrame((IFrameObjectData)((IFrameObjectData)arrayList.get(0)));
                        KeyImageType keyImageType = KeyImageType.valueOf((Attributes)attributes);
                        referringObject = new ReferringObject(keyImageType.getType(), this.objectInfo);
                        for (IFrameObjectData iFrameObjectData : arrayList) {
                            referencedSOP.markInitially(referringObject, iFrameObjectData, keyImageType);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Could not mark KO:{}", (Object)string, (Object)exception);
                    }
                }
            }
        } else if (UIDUtilities.isType((String)string2, (UIDType)UIDType.Composite)) {
            if (bl) {
                this.compositeDataset = attributes;
            } else {
                this.createCompositeObjectData(attributes);
            }
        }
    }

    private void createCompositeObjectData(Attributes attributes) {
        if (this.factory != null) {
            this.compositeObjectData = this.factory.createObjectData(this.patient, this.objectInfo, attributes);
            this.command.addObject(this.objectInfo, this.compositeObjectData);
        }
    }

    public void dicomDataFinished(String string, IDicomDataListener.Status status, Attributes attributes) {
        if (this.compositeDataset != null) {
            this.createCompositeObjectData(this.compositeDataset);
        }
        if (this.compositeObjectData != null && CompareUtils.equals((Object)this.compositeObjectData.getSOPInstanceUID(), (Object)string)) {
            this.compositeObjectData.dicomDataFinished(string, status, attributes);
        }
    }

    public void dicomDataError(String string, String string2, Throwable throwable) {
        super.dicomDataError(string, string2, throwable);
        if (this.factory != null) {
            this.factory.onDicomDataError(this.patient, string);
        }
    }
}

