/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.cycling.thin;

import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.properties.PropertiesOwner;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.glue.cycling.ImpaxEECycleListProvider;
import com.agfa.pacs.impaxee.glue.cycling.Messages;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.cycling.CycleListProviderFactory;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.patinfo.DataSelectionManager;
import java.awt.Component;
import java.util.List;
import javax.swing.SwingUtilities;

public class CheckStudiesForThinSlices
extends AbstractPAction {
    private static final ALogger log = ALogger.getLogger(CheckStudiesForThinSlices.class);
    private static final String ID = "CHECK_STUDIES_FOR_THIN_SLICES";

    public String getID() {
        return ID;
    }

    public String getGroupName() {
        return GENERAL_GROUP;
    }

    public String getCaption() {
        return Messages.getString("CheckStudiesForThinSlices.Caption");
    }

    public String getToolTipText() {
        return Messages.getString("CheckStudiesForThinSlices.Tooltip");
    }

    public boolean perform(Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CheckStudiesForThinSlices.checkStudiesForThinSlices();
            }
        });
        return true;
    }

    private static void checkStudiesForThinSlices() {
        IStudyInfo[] iStudyInfoArray = ImpaxEECycleListProvider.getInstance().getDisplayedStudies();
        log.info("NUMBER of loaded studies: " + iStudyInfoArray.length);
        IStudyInfo[] iStudyInfoArray2 = iStudyInfoArray;
        int n = iStudyInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStudyInfo iStudyInfo = iStudyInfoArray2[n2];
            IDataInfoSource iDataInfoSource = iStudyInfo.getSource();
            PropertiesOwner propertiesOwner = iDataInfoSource.getIdentifier().getPropertiesOwner();
            String string = propertiesOwner.properties().getProperty("thinSliceArchive");
            IDataInfoNode iDataInfoNode = Base.getConfiguredDataInfoNodeByName((String)string);
            if (iDataInfoNode != null) {
                List<IObjectInfo> list = ImpaxEECycleListProvider.expandThinSliceArchive(iStudyInfo, iDataInfoNode);
                if (!list.isEmpty()) {
                    try {
                        CycleListProviderFactory.getInstance().getCycleListProvider().addToCycleList(list, false, null);
                    }
                    catch (Exception exception) {
                        log.error("Failed to add new objects to the cycle list", (Throwable)exception);
                    }
                }
            } else {
                log.error("Thin slice archive " + string + " could not be found in list of archives!");
            }
            ++n2;
        }
    }

    protected boolean isEnabledImpl() {
        return this.hasThinSliceArchive() && this.patientHasCTSliceData();
    }

    private boolean hasThinSliceArchive() {
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation != null) {
            for (IStudyData iStudyData : iPatientRepresentation.getPatientData().getStudies()) {
                IDataInfoSource iDataInfoSource = iStudyData.getQueryObject().getSource();
                PropertiesOwner propertiesOwner = iDataInfoSource.getIdentifier().getPropertiesOwner();
                String string = propertiesOwner.properties().getProperty("thinSliceArchive");
                if (string == null || string.length() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean patientHasCTSliceData() {
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation != null) {
            for (IStudyData iStudyData : iPatientRepresentation.getPatientData().getStudies()) {
                String[] stringArray = iStudyData.getModalitiesInStudy();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (string.equalsIgnoreCase("CT")) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    public boolean invokableByHangingProtocol() {
        return true;
    }
}

