/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.data;

import com.agfa.pacs.base.util.Dcm4cheUtils;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.impaxee.glue.data.IImpaxEEDataObject;
import com.agfa.pacs.impaxee.tagdictionary.PrivateTagMapper;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.agfa.pacs.listtext.lta.base.tagdictionary.TagDictionary;
import com.tiani.base.data.AbstractDataObject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public abstract class ImpaxEEDataObject<U extends IDataInfo>
extends AbstractDataObject
implements IImpaxEEDataObject<U> {
    static final PrivateTagDictionary PRIVATE_TAG_DICTIONARY = TagDictionary.getInstance().getPrivateTagDictionary();
    protected static final IDicomCache dicomCache = DicomCacheFactory.getInstance().getDicomCache();
    protected static final boolean cacheSupportsMetadata;
    protected U dataInfo;

    static {
        boolean bl = dicomCache.cachesMetadata();
        if (bl && System.getProperty("cache.metadata") != null) {
            bl = Boolean.parseBoolean(System.getProperty("cache.metadata"));
            log.info("Disabled header data caching");
        }
        cacheSupportsMetadata = bl;
    }

    public ImpaxEEDataObject(U u) {
        this.dataInfo = u;
    }

    @Override
    public U getDataInfo() {
        return this.dataInfo;
    }

    public IDataInfo getQueryObject() {
        return this.dataInfo;
    }

    public String getKey() {
        return this.dataInfo.getKey();
    }

    public String resolveString(int n) {
        Attributes attributes;
        block9: {
            block8: {
                attributes = this.getDicomObject();
                try {
                    if (PRIVATE_TAG_DICTIONARY.isWrappingPrivateTag(Integer.valueOf(n))) {
                        return PrivateTagMapper.getInstance().getString(attributes, PRIVATE_TAG_DICTIONARY.convertToPublicTag(n));
                    }
                    if (TagUtils.isPrivateGroup((int)n) && attributes.getVR(n) == VR.UN) {
                        return Dcm4cheUtils.getBytesAsString((Attributes)attributes, (int[])new int[]{n});
                    }
                    if (ElementDictionary.vrOf((int)n, null) != VR.SQ) break block8;
                    Attributes attributes2 = attributes.getNestedDataset(n);
                    if (attributes2 != null) {
                        return attributes2.getString(524544);
                    }
                    return null;
                }
                catch (Exception exception) {
                    log.error("Resolving error", (Throwable)exception);
                    return null;
                }
            }
            if (-65520 != n) break block9;
            if (this.dataInfo.getSource() != null && this.dataInfo.getSource().getIdentifier() instanceof IDicomNode) {
                return this.dataInfo.getSource().getIdentifier().getName();
            }
            return null;
        }
        return attributes.getString(n);
    }

    public Attributes resolveStringEnhanced(int[] nArray, int n) {
        return Dcm4cheUtils.getNestedDataset((int[])nArray, (Attributes)this.getDicomObject(), (boolean)false);
    }

    private static String[] encapsulateString(String string) {
        String[] stringArray;
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        return stringArray;
    }

    public String[] resolveStrings(int n) {
        try {
            if (PrivateTagDictionary.isPrivateTag((int)n)) {
                if (PRIVATE_TAG_DICTIONARY.isWrappingPrivateTag(Integer.valueOf(n))) {
                    return PrivateTagMapper.getInstance().getStrings(this.getDicomObject(), PRIVATE_TAG_DICTIONARY.convertToPublicTag(n));
                }
                return ImpaxEEDataObject.encapsulateString(this.getParent().resolveString(n));
            }
            return this.getDicomObject().getStrings(n);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return new String[]{this.getDicomObject().getString(n)};
        }
    }

    public String toString() {
        return this.dataInfo.toString();
    }
}

