/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.data;

import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.lut.IColorLookupTableSource;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.fetcher.FetcherUtils;
import com.agfa.pacs.impaxee.glue.data.AbstractImageObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEImageObjectData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEESingleFrameData;
import com.agfa.pacs.impaxee.glue.data.ImpaxEETokenData;
import com.agfa.pacs.impaxee.keyimages.IKeyImageInfo;
import com.agfa.pacs.impaxee.keyimages.IKeyImageSetter;
import com.agfa.pacs.impaxee.keyimages.NotMarkedKeyImage;
import com.agfa.pacs.listtext.dicomobject.module.equipment.IManufacturerInfo;
import com.agfa.pacs.listtext.dicomobject.module.image.IHistogramProvider;
import com.agfa.pacs.listtext.dicomobject.module.ps.BitmapDisplayShutterModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayShutterModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.DisplayedArea;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicAnnotation;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicLayer;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.ModalityLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.OverlayPlane;
import com.agfa.pacs.listtext.dicomobject.module.ps.OverlayPlaneModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.PaletteColorLUTModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationLUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.dicomobject.module.ps.SpatialTransformationModule;
import com.agfa.pacs.listtext.dicomobject.presentation.DisplayShutter;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentation.InternalManufacturerInfo;
import com.agfa.pacs.listtext.dicomobject.presentation.OverlayContainer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.OverlayFrame;
import com.agfa.pacs.listtext.lta.base.tagdictionary.PrivateTagDictionary;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.tiani.base.data.AbstractDataObject;
import com.tiani.base.data.IFrameListener;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.Orientation;
import com.tiani.base.data.RawDataContainer;
import com.tiani.base.data.RawDataContainerTokenData;
import com.tiani.base.data.TokenData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Attributes;

public class ImpaxEEFrameObjectData
extends AbstractDataObject
implements IFrameObjectData,
IKeyImageSetter {
    private static final String Label = "IMAGE";
    private static final Set<String> vendorsToDisplayEnhancedColorMRByDefault = new HashSet<String>();
    protected AbstractImageObjectData mainFrame;
    private List<IFrameListener> listeners = new ArrayList<IFrameListener>(2);
    private TokenData tokenData;
    protected int frameNumber;
    private volatile RawDataContainer rdc;
    private String key;
    private ImageFrameState ifps = null;
    private IKeyImageInfo keyImage = null;

    static {
        String[] stringArray = StringUtils.split((String)Config.impaxee.jvision.DISPLAY.VendorsToDisplayColorMR.get().toUpperCase(Locale.ENGLISH), (String)",");
        vendorsToDisplayEnhancedColorMRByDefault.addAll(Arrays.asList(stringArray));
    }

    public ImpaxEEFrameObjectData(AbstractImageObjectData abstractImageObjectData, int n) {
        this.mainFrame = abstractImageObjectData;
        this.frameNumber = n;
        this.key = abstractImageObjectData.getKey() + '_' + n;
    }

    public String getSOPInstanceUID() {
        return this.mainFrame.getSOPInstanceUID();
    }

    public String getSOPClassUID() {
        return this.mainFrame.getSOPClassUID();
    }

    public String getUID() {
        return this.mainFrame.getSOPInstanceUID();
    }

    public ISeriesData getParent() {
        return this.mainFrame.getParent();
    }

    public IImageObjectData getMainFrame() {
        return this.mainFrame;
    }

    public int getInstanceNumber() {
        return this.mainFrame.getInstanceNumber();
    }

    public boolean isEnhancedSliceObject() {
        return false;
    }

    public TokenData getTokenData() {
        if (this.tokenData == null) {
            this.tokenData = new ImpaxEETokenData(this.getDataInfo(), this.frameNumber);
        }
        return this.tokenData;
    }

    public IKeyImageInfo getKeyImageInfo() {
        if (this.keyImage != null) {
            return this.keyImage;
        }
        return NotMarkedKeyImage.INSTANCE;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public RawDataContainer getRawDataContainer() {
        return this.rdc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHasError(String string) {
        List<Object> list;
        ImpaxEEFrameObjectData impaxEEFrameObjectData2 = this;
        synchronized (impaxEEFrameObjectData2) {
            list = this.listeners == null ? Collections.emptyList() : new ArrayList<IFrameListener>(this.listeners);
        }
        for (ImpaxEEFrameObjectData impaxEEFrameObjectData2 : list) {
            impaxEEFrameObjectData2.notifyHasError(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRawDataContainer(RawDataContainer rawDataContainer) {
        List<Object> list;
        this.rdc = rawDataContainer;
        if (this.tokenData instanceof RawDataContainerTokenData) {
            ((RawDataContainerTokenData)this.tokenData).setRawDataContainer(rawDataContainer);
        }
        ImpaxEEFrameObjectData impaxEEFrameObjectData = this;
        synchronized (impaxEEFrameObjectData) {
            list = this.listeners == null ? Collections.emptyList() : new ArrayList<IFrameListener>(this.listeners);
            if (!FetcherUtils.isLossyPrefetchData((IPixelDataFrame)rawDataContainer.getPixelDataFrame())) {
                this.listeners = null;
            }
        }
        boolean bl = false;
        for (IFrameListener iFrameListener : list) {
            bl |= iFrameListener.frameAvailable((IFrameObjectData)this, null);
        }
        return bl;
    }

    public void setRawDataContainerToken() {
        if (this.tokenData instanceof RawDataContainerTokenData) {
            RawDataContainerTokenData rawDataContainerTokenData = (RawDataContainerTokenData)this.tokenData;
            rawDataContainerTokenData.setData((IFrameObjectData)this, this.rdc);
            return;
        }
        if (this.rdc != null) {
            this.tokenData = new RawDataContainerTokenData((IFrameObjectData)this, this.rdc, this.getTokenData());
        }
    }

    public IImageInformation getImageInformation() {
        return this.mainFrame.getImageInformation();
    }

    public int getColumns() {
        return this.mainFrame.getImageInformation().getColumns();
    }

    public int getRows() {
        return this.mainFrame.getImageInformation().getRows();
    }

    public Attributes getDicomObject() {
        return this.mainFrame.getDicomObject();
    }

    public Attributes getPerFrameDicomObject() {
        return this.mainFrame.getDicomObject();
    }

    public IDataInfo getQueryObject() {
        return this.mainFrame.getQueryObject();
    }

    public void setDicomObject(Attributes attributes) {
        this.mainFrame.setDicomObject(attributes);
    }

    public String resolveString(int n) {
        if (PrivateTagDictionary.isPrivateTag((int)n)) {
            if (-65535 == n) {
                if (this.mainFrame.getFrameCount() == 1) {
                    return null;
                }
                return Integer.toString(this.frameNumber);
            }
            if (-65528 == n) {
                Orientation orientation = Orientation.getOrientation((IImageInformation)this.getImageInformation());
                return orientation != null ? orientation.getValue() : null;
            }
            if (-65520 == n && ((IObjectInfo)this.mainFrame.getDataInfo()).getSource() != null && ((IObjectInfo)this.mainFrame.getDataInfo()).getSource().getIdentifier() instanceof IDicomNode) {
                return ((IObjectInfo)this.mainFrame.getDataInfo()).getSource().getIdentifier().getName();
            }
        }
        return this.mainFrame.resolveString(n);
    }

    public Attributes resolveStringEnhanced(int[] nArray, int n) {
        return this.mainFrame.resolveStringEnhanced(nArray, n);
    }

    public String[] resolveStrings(int n) {
        return this.mainFrame.resolveStrings(n);
    }

    public IFramePresentationState getFramePresentationState() {
        if (this.ifps == null) {
            this.ifps = new ImageFrameState(this.rdc.getPixelDataFrame());
        }
        return this.ifps;
    }

    public void resetFramePresentationState() {
        this.ifps = null;
    }

    public String getKey() {
        return this.key;
    }

    public IObjectInfo getDataInfo() {
        if (this.mainFrame instanceof ImpaxEEImageObjectData) {
            return (IObjectInfo)((ImpaxEEImageObjectData)this.mainFrame).getDataInfo();
        }
        if (this.mainFrame instanceof ImpaxEESingleFrameData) {
            return (IObjectInfo)((ImpaxEESingleFrameData)this.mainFrame).getDataInfo();
        }
        return null;
    }

    public ILoadableInfo getLoadableDataInfo() {
        return this.getDataInfo();
    }

    public IObjectInfo getFullDataInfo() {
        if (this.mainFrame instanceof ImpaxEEImageObjectData) {
            return ((ImpaxEEImageObjectData)this.mainFrame).getFullDataInfo();
        }
        if (this.mainFrame instanceof ImpaxEESingleFrameData) {
            return ((ImpaxEESingleFrameData)this.mainFrame).getFullDataInfo();
        }
        return null;
    }

    public boolean isLossyData() {
        IImageInformation iImageInformation = this.getImageInformation();
        if (iImageInformation == null) {
            return false;
        }
        return iImageInformation.isLossy();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImpaxEEFrameObjectData)) {
            return false;
        }
        ImpaxEEFrameObjectData impaxEEFrameObjectData = (ImpaxEEFrameObjectData)((Object)object);
        return this.getKey().equals(impaxEEFrameObjectData.getKey()) && this.getFrameNumber() == impaxEEFrameObjectData.getFrameNumber();
    }

    public int hashCode() {
        return this.getKey().hashCode() + this.getFrameNumber();
    }

    public String toString() {
        return this.mainFrame.toString();
    }

    public IDicomDataListener getDataListener() {
        return this.mainFrame;
    }

    public boolean isStartedBeingLoaded() {
        return this.mainFrame.isStartedBeingLoaded();
    }

    public synchronized void addListener(IFrameListener iFrameListener) {
        if (this.listeners == null) {
            iFrameListener.frameAvailable((IFrameObjectData)this, null);
        } else {
            this.listeners.add(iFrameListener);
        }
    }

    public void storeToCache() {
        if (this.tokenData != null) {
            this.tokenData.cleanup();
        }
        this.tokenData = null;
    }

    public String getModality() {
        return this.getMainFrame().getModality();
    }

    public String getSeriesDescription() {
        return this.getMainFrame().getSeriesDescription();
    }

    public boolean hasError() {
        return this.mainFrame.hasError();
    }

    public boolean isBeingLossyPrefetched() {
        if (this.rdc != null) {
            return FetcherUtils.isLossyPrefetchData((IPixelDataFrame)this.getRawDataContainer().getPixelDataFrame());
        }
        return this.getImageInformation().isBeingLossyPrefetched();
    }

    public boolean setLossyFetching() {
        return this.getImageInformation().setLossyFetching();
    }

    public PIcon getStatusIcon() {
        return null;
    }

    public List<PAction> getMenuEntries() {
        return Collections.emptyList();
    }

    public boolean isDisplayColorInMR() {
        if (this.getImageInformation().getImageClass() == IImageInformation.ImageClass.MR) {
            String string = this.getImageInformation().getDataset().getString(524400);
            if (string == null) {
                string = "";
            }
            return vendorsToDisplayEnhancedColorMRByDefault.contains(string.toUpperCase(Locale.ENGLISH));
        }
        return true;
    }

    public void setKeyImageInfo(IKeyImageInfo iKeyImageInfo) {
        this.keyImage = iKeyImageInfo;
    }

    private class ImageFrameState
    implements IFramePresentationState {
        private boolean forceLUT = true;
        private PaletteColorLUTModule paletteColorLUT = null;
        private List<OverlayFrame> overlayFrames = null;
        private OverlayFrame bitmapShutterOverlayFrame = null;

        public ImageFrameState(IPixelDataFrame iPixelDataFrame) {
            Attributes attributes = ImpaxEEFrameObjectData.this.getDicomObject();
            if (ImpaxEEFrameObjectData.this.getImageInformation().hasColorPaletteLUT()) {
                this.paletteColorLUT = new PaletteColorLUTModule();
                this.paletteColorLUT.readFrom(attributes);
            }
            this.forceLUT = ImpaxEEFrameObjectData.this.isDisplayColorInMR();
            int n = -1;
            if (attributes.containsValue(1578531)) {
                n = attributes.getInt(1578531, 0);
            }
            if (OverlayPlaneModule.hasOverlays((Attributes)attributes)) {
                OverlayPlaneModule overlayPlaneModule = new OverlayPlaneModule();
                overlayPlaneModule.readFrom(attributes);
                if (!overlayPlaneModule.overlayPlanes().isEmpty()) {
                    this.overlayFrames = new LinkedList<OverlayFrame>();
                    for (OverlayPlane overlayPlane : overlayPlaneModule.overlayPlanes()) {
                        OverlayContainer overlayContainer = new OverlayContainer(overlayPlane, null);
                        OverlayFrame overlayFrame = overlayContainer.getOverlayFrame(ImpaxEEFrameObjectData.this.getParent().getParent().getStudyInstanceUID(), ImpaxEEFrameObjectData.this.getSOPInstanceUID(), ImpaxEEFrameObjectData.this.frameNumber, iPixelDataFrame);
                        if (overlayFrame == null) continue;
                        if (overlayContainer.getGroupTag() == n) {
                            overlayFrame.setShutter(true);
                            this.bitmapShutterOverlayFrame = overlayFrame;
                            continue;
                        }
                        this.overlayFrames.add(overlayFrame);
                    }
                }
            }
        }

        public IManufacturerInfo getManufacturer() {
            return InternalManufacturerInfo.INSTANCE;
        }

        private DisplayedArea getDisplayedArea(IImageInformation iImageInformation) {
            DisplayedArea displayedArea = new DisplayedArea();
            displayedArea.setPresentationSizeMode(PresentationSizeMode.ScaleToFit);
            displayedArea.setDisplayedAreaBottomRightHandCorner(new int[]{iImageInformation.getColumns(), iImageInformation.getRows()});
            displayedArea.setPresentationPixelAspectRatio(iImageInformation.getPixelAspectRatio());
            double[] dArray = null;
            Attributes attributes = iImageInformation.getDataset();
            if (attributes.contains(1577316)) {
                dArray = attributes.getDoubles(1577316);
            }
            if (dArray == null && attributes.contains(1581072)) {
                dArray = attributes.getDoubles(1581072);
            }
            if (dArray == null) {
                try {
                    dArray = attributes.getDoubles(2621488);
                }
                catch (Exception exception) {
                    log.error("Pixel spacing could not be parsed");
                }
            }
            if (dArray != null) {
                displayedArea.setPresentationPixelSpacing(dArray);
            }
            return displayedArea;
        }

        public OverlayFrame getBitmapDisplayShutterOverlayFrame() {
            return this.bitmapShutterOverlayFrame;
        }

        public DisplayShutter getDisplayShutter() {
            IImageInformation iImageInformation = ImpaxEEFrameObjectData.this.getImageInformation();
            Attributes attributes = ImpaxEEFrameObjectData.this.getDicomObject();
            if (this.bitmapShutterOverlayFrame == null) {
                if (DisplayShutterModule.isModuleAvailable((Attributes)attributes)) {
                    DisplayShutterModule displayShutterModule = new DisplayShutterModule();
                    displayShutterModule.readFrom(attributes);
                    return new DisplayShutter(iImageInformation.getColumns(), iImageInformation.getRows(), displayShutterModule);
                }
                return null;
            }
            if (BitmapDisplayShutterModule.isModuleAvailable((Attributes)attributes)) {
                BitmapDisplayShutterModule bitmapDisplayShutterModule = new BitmapDisplayShutterModule();
                bitmapDisplayShutterModule.readFrom(attributes);
                return new DisplayShutter(this.bitmapShutterOverlayFrame, bitmapDisplayShutterModule);
            }
            return null;
        }

        public DisplayShutterModule getDisplayShutterModule() {
            Attributes attributes = ImpaxEEFrameObjectData.this.getDicomObject();
            if (DisplayShutterModule.isModuleAvailable((Attributes)attributes)) {
                DisplayShutterModule displayShutterModule = new DisplayShutterModule();
                displayShutterModule.readFrom(attributes);
                return displayShutterModule;
            }
            return null;
        }

        public BitmapDisplayShutterModule getBitmapDisplayShutterModule() {
            Attributes attributes = ImpaxEEFrameObjectData.this.getDicomObject();
            if (BitmapDisplayShutterModule.isModuleAvailable((Attributes)attributes)) {
                BitmapDisplayShutterModule bitmapDisplayShutterModule = new BitmapDisplayShutterModule();
                bitmapDisplayShutterModule.readFrom(attributes);
                return bitmapDisplayShutterModule;
            }
            return null;
        }

        public DisplayedArea getDisplayedArea() {
            return this.getDisplayedArea(ImpaxEEFrameObjectData.this.getImageInformation());
        }

        public List<GraphicAnnotation> getGraphicAnnotations() {
            return Collections.emptyList();
        }

        public List<GraphicLayer> getGraphicLayers() {
            return Collections.emptyList();
        }

        public String getLabel() {
            return ImpaxEEFrameObjectData.Label;
        }

        public List<OverlayFrame> getOverlayFrames() {
            return this.overlayFrames;
        }

        public String getProviderUID() {
            return ImpaxEEFrameObjectData.this.getSOPInstanceUID();
        }

        public SpatialTransformationModule getSpatialTransformation() {
            return null;
        }

        public boolean isExternal() {
            return false;
        }

        public boolean isTemporary() {
            return false;
        }

        public boolean getForceLUT() {
            return this.forceLUT;
        }

        public ModalityLUT getModalityLUT() {
            return ImpaxEEFrameObjectData.this.getImageInformation().getModalityLUT();
        }

        public void setModalityLUT(ModalityLUT modalityLUT) {
        }

        public IColorLookupTableSource getPaletteColorLUT() {
            return this.paletteColorLUT;
        }

        public PresentationLUT getPresentationLUT() {
            return ImpaxEEFrameObjectData.this.getImageInformation().getPresentationLUT();
        }

        public IVOILUT getVOILUT() {
            if (ImpaxEEFrameObjectData.this.rdc != null) {
                return ImpaxEEFrameObjectData.this.getImageInformation().getVOILUT((IHistogramProvider)ImpaxEEFrameObjectData.this.rdc);
            }
            return ImpaxEEFrameObjectData.this.getImageInformation().getVOILUT();
        }

        public void setVOILUT(IVOILUT iVOILUT) {
        }

        public IVOILUT getVOILUT(IHistogramProvider iHistogramProvider) {
            return this.getVOILUT();
        }

        public void setForceLUT(boolean bl) {
            this.forceLUT = bl;
        }
    }
}

