/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.data;

import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IDataProviderIdentifier;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.util.PatientKeyUtils;
import com.agfa.pacs.impaxee.attributefilter.AttributeFilterRegistry;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.glue.data.ImpaxEENonLeafDataObject;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEStudyData;
import com.agfa.pacs.impaxee.glue.datainfo.ImpaxEEStudyInfo;
import com.agfa.pacs.listtext.dicomobject.interfaces.IPatientIdentifier;
import com.agfa.pacs.listtext.lta.base.tagdictionary.DicomTag;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.IStudyData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.UIDUtils;

public class ImpaxEEPatientData
extends ImpaxEENonLeafDataObject<IPatientInfo>
implements IPatientData {
    private static final int[] patientTags = DicomTag.extractTags((List)AttributeFilterRegistry.getInstance().getPatientDicomTags());
    private Map<String, IStudyData> studies;
    private PersonName personName;
    private volatile boolean prefetchLossyImages = DataManager.isLossyPrefetchingEnabled();
    private final AtomicInteger worldToWorldTransformCount = new AtomicInteger(0);
    private List<IObjectInfo> additionalObjects = new CopyOnWriteArrayList<IObjectInfo>();
    private Map<Pair<String, Class<?>>, Object> generalRegistry = Collections.synchronizedMap(new HashMap(64));
    private IPatientIdentifier patientIdentifier;

    public ImpaxEEPatientData(IPatientInfo iPatientInfo) {
        super(iPatientInfo);
        String string;
        this.studies = new HashMap<String, IStudyData>();
        if (this.prefetchLossyImages && this.isNotImpaxWADOArchive(iPatientInfo.getSource())) {
            this.prefetchLossyImages = false;
        }
        if ((string = iPatientInfo.getString(0x100010)) != null) {
            this.personName = new PersonName(string, true);
        }
    }

    public PersonName getPatientName() {
        return this.personName;
    }

    private boolean isNotImpaxWADOArchive(IDataInfoSource iDataInfoSource) {
        if (iDataInfoSource == null) {
            return true;
        }
        IDataProviderIdentifier iDataProviderIdentifier = iDataInfoSource.getIdentifier();
        if (!iDataProviderIdentifier.getType().equals("AGFADICOMWADO")) {
            return true;
        }
        return Boolean.parseBoolean(iDataProviderIdentifier.getPropertiesOwner().properties().getProperty("useCGet", Boolean.TRUE.toString()));
    }

    public synchronized void notifyStudyLoaded() {
        if (this.prefetchLossyImages) {
            for (IStudyData iStudyData : this.studies.values()) {
                if (iStudyData.isStudyLoaded()) continue;
                return;
            }
            if (!Config.impaxee.workstation.AutoRetrieveLossless.get()) {
                log.info("Lossy images download, lossless download not activated");
                return;
            }
            this.startDownloadOfLosslessImages();
        }
    }

    private void startDownloadOfLosslessImages() {
        this.prefetchLossyImages = false;
        if (log.isInfoEnabled()) {
            log.info("Starting to download lossless images of patient:" + PatientKeyUtils.generatePatientKey((String)PatientKeyUtils.extractPatientId((String)this.getKey()), null, (String)PatientKeyUtils.extractIssuerOfPatientId((String)this.getKey())));
        }
        for (IStudyData iStudyData : this.studies.values()) {
            for (ISeriesData iSeriesData : iStudyData.getSeries()) {
                for (IImageObjectData iImageObjectData : iSeriesData.getObjects()) {
                    iImageObjectData.requestDownloadOfLosslessImage((byte)5);
                }
            }
        }
    }

    public void setDicomObject(Attributes attributes) {
        String string = PatientKeyUtils.generatePatientKey((Attributes)attributes);
        if (string.startsWith(this.getKey())) {
            Attributes attributes2 = new Attributes();
            attributes2.addSelected(attributes, patientTags);
            attributes2.addAll(this.dicomObject);
            this.dicomObject = attributes2;
            this.headerComplete = true;
        }
    }

    public void addStudy(IStudyData iStudyData, boolean bl) {
        iStudyData.setParent((IPatientData)this);
        this.addStudyImpl(iStudyData, bl);
    }

    private void addStudyImpl(IStudyData iStudyData, boolean bl) {
        this.studies.put(iStudyData.getKey(), iStudyData);
        if (bl) {
            DataManager.getInstance().studyAdded(iStudyData);
        }
    }

    public IDataObject removeStudy(IStudyData iStudyData, boolean bl) {
        if (iStudyData == null) {
            return null;
        }
        IDataObject iDataObject = (IDataObject)this.studies.remove(iStudyData.getKey());
        iStudyData.cleanUp();
        String string = iStudyData.getKey();
        this.additionalObjects.removeIf(iObjectInfo -> iObjectInfo.getStudyUID().equals(string));
        DataManager.getInstance().studyRemoved((IPatientData)this, iStudyData, bl);
        if (this.studies.size() == 0) {
            iDataObject = DataManager.getInstance().removePatient(this.getKey(), false, bl);
        }
        return iDataObject;
    }

    public Map<String, IStudyData> getStudiesMap() {
        HashMap<String, IStudyData> hashMap = new HashMap<String, IStudyData>();
        for (IStudyData iStudyData : this.getStudies()) {
            hashMap.put(iStudyData.getKey(), iStudyData);
        }
        return hashMap;
    }

    public IDataObject getParent() {
        return null;
    }

    public IPatientIdentifier getPatientIdentifier() {
        if (this.patientIdentifier == null) {
            this.patientIdentifier = new PrivatePatientIdentfier();
        }
        return this.patientIdentifier;
    }

    public List<ISeriesData> getSeries() {
        ArrayList<ISeriesData> arrayList = new ArrayList<ISeriesData>(20);
        for (IStudyData iStudyData : this.getStudies()) {
            for (ISeriesData iSeriesData : iStudyData.getSeries()) {
                arrayList.add(iSeriesData);
            }
        }
        return arrayList;
    }

    public ISeriesData getSerie(String string) {
        ISeriesData iSeriesData = null;
        for (IStudyData iStudyData : this.getStudies()) {
            iSeriesData = iStudyData.getSeries(string);
            if (iSeriesData == null) continue;
            return iSeriesData;
        }
        return null;
    }

    public Collection<IStudyData> getStudies() {
        return Collections.unmodifiableCollection(this.studies.values());
    }

    public IStudyData getStudy(String string) {
        return this.studies.get(string);
    }

    public IStudyData createStudyData() {
        Object u = this.getDataInfo();
        Date date = new Date();
        String string = UIDUtils.createUID();
        ImpaxEEStudyInfo impaxEEStudyInfo = new ImpaxEEStudyInfo((IDataInfo)u, string);
        impaxEEStudyInfo.getAttributes().setString(0x20000D, VR.UI, string);
        impaxEEStudyInfo.getAttributes().setDate(524320, VR.DA, new Date[]{date});
        impaxEEStudyInfo.getAttributes().setDate(524336, VR.TM, new Date[]{date});
        u.addChild((IDataInfo)impaxEEStudyInfo);
        ImpaxEEStudyData impaxEEStudyData = new ImpaxEEStudyData((IStudyInfo)impaxEEStudyInfo);
        this.addStudy(impaxEEStudyData, true);
        return impaxEEStudyData;
    }

    public void touchStudy(IStudyData iStudyData) {
        IStudyData iStudyData2 = this.studies.get(iStudyData.getKey());
        if (iStudyData2 == null) {
            this.addStudyImpl(iStudyData, true);
        }
    }

    public void cleanUp() {
        if (log.isTraceEnabled()) {
            log.trace("Cleaning up references in instance of " + this.getClass().getName() + ": " + this.getKey());
        }
        this.patientIdentifier = null;
        this.generalRegistry.clear();
        if (this.studies != null) {
            IStudyData[] iStudyDataArray = this.studies.values().toArray(new IStudyData[this.studies.size()]);
            int n = iStudyDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStudyData iStudyData = iStudyDataArray[n2];
                this.removeStudy(iStudyData, false);
                ++n2;
            }
            this.studies.clear();
        }
    }

    public synchronized void storeToCache() {
        log.info("Put patient {} to cache", (Object)PatientKeyUtils.generatePatientKey((String)this.getPatientIdentifier().getPatientID(), null, (String)this.getPatientIdentifier().getIssuerOfPatientID()));
        for (IStudyData iStudyData : this.studies.values()) {
            for (ISeriesData iSeriesData : iStudyData.getSeries()) {
                if (iSeriesData.isSecondaryCapture() && !iSeriesData.isSecondaryCaptureSaved()) continue;
                for (IObjectData iObjectData : iSeriesData.getObjects()) {
                    iObjectData.storeToCache();
                }
            }
        }
    }

    public String getModality() {
        return null;
    }

    public String getSeriesDescription() {
        return null;
    }

    public boolean isPrefetchingLossyImagesEnabled() {
        return this.prefetchLossyImages;
    }

    public boolean hasLossyPrefetchedImages() {
        if (!this.isPrefetchingLossyImagesEnabled()) {
            return false;
        }
        for (IStudyData iStudyData : this.studies.values()) {
            for (ISeriesData iSeriesData : iStudyData.getSeries()) {
                for (IImageObjectData iImageObjectData : iSeriesData.getObjects()) {
                    if (!iImageObjectData.isPrefetchingLossyImageEnabled()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean existsWorldToWorldTransforms() {
        return this.worldToWorldTransformCount.get() > 0;
    }

    public void updateWorldToWorldTransformCount(int n) {
        int n2 = this.worldToWorldTransformCount.addAndGet(n);
        if (n2 < 0) {
            log.warn("Inconsistent world-to-world transform count: " + n2);
            this.worldToWorldTransformCount.compareAndSet(n2, 0);
        }
    }

    public List<IObjectInfo> getAdditionalObjects() {
        return this.additionalObjects;
    }

    public void addAdditionalObjects(IObjectInfo iObjectInfo) {
        this.additionalObjects.add(iObjectInfo);
    }

    public void removeAdditionalObjects(List<IObjectInfo> list) {
        this.additionalObjects.removeAll(list);
    }

    public <U> U registerObject(String string, Class<U> clazz, U u) {
        return (U)this.generalRegistry.put((Pair<String, Class<?>>)ImmutablePair.of((Object)string, clazz), u);
    }

    public <U> void unregisterObject(String string, Class<U> clazz) {
        this.generalRegistry.remove(ImmutablePair.of((Object)string, clazz));
    }

    public <U> U getRegisteredObject(String string, Class<U> clazz) {
        return (U)this.generalRegistry.get(ImmutablePair.of((Object)string, clazz));
    }

    public class PrivatePatientIdentfier
    implements IPatientIdentifier {
        public String getIssuerOfPatientID() {
            return ((IPatientInfo)ImpaxEEPatientData.this.getDataInfo()).getString(0x100021);
        }

        public Date getPatientBirthDate() {
            return ((IPatientInfo)ImpaxEEPatientData.this.getDataInfo()).getDate(0x100030);
        }

        public String getPatientID() {
            return ((IPatientInfo)ImpaxEEPatientData.this.getDataInfo()).getString(0x100020);
        }

        public String getPatientName() {
            return ((IPatientInfo)ImpaxEEPatientData.this.getDataInfo()).getString(0x100010);
        }

        public String getPatientSex() {
            return ((IPatientInfo)ImpaxEEPatientData.this.getDataInfo()).getString(0x100040);
        }

        public void setIssuerOfPatientID(String string) {
            throw new UnsupportedOperationException();
        }

        public void setPatientBirthDate(Date date) {
            throw new UnsupportedOperationException();
        }

        public void setPatientID(String string) {
            throw new UnsupportedOperationException();
        }

        public void setPatientName(String string) {
            throw new UnsupportedOperationException();
        }

        public void setPatientSex(String string) {
            throw new UnsupportedOperationException();
        }
    }
}

